/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.maning.mndialoglibrary.R;
import com.maning.mndialoglibrary.config.MDialogConfig;
import com.maning.mndialoglibrary.utils.MSizeUtils;
import com.maning.mndialoglibrary.view.MNHudProgressWheel;

public class MProgressDialog {
    private static final String LoadingDefaultMsg = "\u52a0\u8f7d\u4e2d";
    private static Dialog mDialog;
    private static MDialogConfig mDialogConfig;
    private static RelativeLayout dialog_window_background;
    private static RelativeLayout dialog_view_bg;
    private static MNHudProgressWheel progress_wheel;
    private static TextView tv_show;

    private static void initDialog(Context mContext) {
        LayoutInflater inflater = LayoutInflater.from((Context)mContext);
        View mProgressDialogView = inflater.inflate(R.layout.mn_progress_dialog_layout, null);
        mDialog = new Dialog(mContext, R.style.MNCustomDialog);
        mDialog.setCancelable(false);
        mDialog.setCanceledOnTouchOutside(false);
        mDialog.setContentView(mProgressDialogView);
        WindowManager.LayoutParams layoutParams = mDialog.getWindow().getAttributes();
        layoutParams.width = -1;
        layoutParams.height = -1;
        layoutParams.gravity = 17;
        mDialog.getWindow().setAttributes(layoutParams);
        dialog_window_background = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_window_background);
        dialog_view_bg = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_view_bg);
        progress_wheel = (MNHudProgressWheel)mProgressDialogView.findViewById(R.id.progress_wheel);
        tv_show = (TextView)mProgressDialogView.findViewById(R.id.tv_show);
        progress_wheel.spin();
        MProgressDialog.configView(mContext);
    }

    private static void checkDialogConfig() {
        if (mDialogConfig == null) {
            mDialogConfig = new MDialogConfig.Builder().build();
        }
    }

    private static void configView(Context mContext) {
        MProgressDialog.checkDialogConfig();
        if (MProgressDialog.mDialogConfig.animationID != 0 && mDialog.getWindow() != null) {
            try {
                mDialog.getWindow().setWindowAnimations(MProgressDialog.mDialogConfig.animationID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mDialog.setCanceledOnTouchOutside(MProgressDialog.mDialogConfig.canceledOnTouchOutside);
        mDialog.setCancelable(MProgressDialog.mDialogConfig.cancelable);
        dialog_window_background.setBackgroundColor(MProgressDialog.mDialogConfig.backgroundWindowColor);
        GradientDrawable myGrad = new GradientDrawable();
        myGrad.setColor(MProgressDialog.mDialogConfig.backgroundViewColor);
        myGrad.setStroke(MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.strokeWidth), MProgressDialog.mDialogConfig.strokeColor);
        myGrad.setCornerRadius((float)MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.cornerRadius));
        if (Build.VERSION.SDK_INT >= 16) {
            dialog_view_bg.setBackground((Drawable)myGrad);
        } else {
            dialog_view_bg.setBackgroundDrawable((Drawable)myGrad);
        }
        dialog_view_bg.setPadding(MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.paddingLeft), MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.paddingTop), MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.paddingRight), MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.paddingBottom));
        progress_wheel.setBarColor(MProgressDialog.mDialogConfig.progressColor);
        progress_wheel.setBarWidth(MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.progressWidth));
        progress_wheel.setRimColor(MProgressDialog.mDialogConfig.progressRimColor);
        progress_wheel.setRimWidth(MProgressDialog.mDialogConfig.progressRimWidth);
        ViewGroup.LayoutParams layoutParamsProgress = progress_wheel.getLayoutParams();
        layoutParamsProgress.width = MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.progressSize);
        layoutParamsProgress.height = MSizeUtils.dp2px(mContext, MProgressDialog.mDialogConfig.progressSize);
        progress_wheel.setLayoutParams(layoutParamsProgress);
        tv_show.setTextColor(MProgressDialog.mDialogConfig.textColor);
        tv_show.setTextSize(MProgressDialog.mDialogConfig.textSize);
        dialog_window_background.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (mDialogConfig != null && mDialogConfig.canceledOnTouchOutside) {
                    MProgressDialog.dismissProgress();
                }
            }
        });
        if (MProgressDialog.mDialogConfig.windowFullscreen) {
            mDialog.getWindow().setFlags(1024, 1024);
        }
    }

    public static void showProgress(Context context) {
        MProgressDialog.showProgress(context, LoadingDefaultMsg);
    }

    public static void showProgress(Context context, String msg) {
        MProgressDialog.showProgress(context, msg, null);
    }

    public static void showProgress(Context context, MDialogConfig mDialogConfig) {
        MProgressDialog.showProgress(context, LoadingDefaultMsg, mDialogConfig);
    }

    public static void showProgress(Context context, String msg, MDialogConfig dialogConfig) {
        try {
            MProgressDialog.dismissProgress();
            if (dialogConfig == null) {
                dialogConfig = new MDialogConfig.Builder().build();
            }
            mDialogConfig = dialogConfig;
            MProgressDialog.initDialog(context);
            if (mDialog != null && tv_show != null) {
                if (TextUtils.isEmpty((CharSequence)msg)) {
                    tv_show.setVisibility(8);
                } else {
                    tv_show.setVisibility(0);
                    tv_show.setText((CharSequence)msg);
                }
                mDialog.show();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void dismissProgress() {
        try {
            if (mDialog != null && mDialog.isShowing()) {
                if (MProgressDialog.mDialogConfig.onDialogDismissListener != null) {
                    MProgressDialog.mDialogConfig.onDialogDismissListener.onDismiss();
                    MProgressDialog.mDialogConfig.onDialogDismissListener = null;
                }
                mDialogConfig = null;
                dialog_window_background = null;
                dialog_view_bg = null;
                progress_wheel = null;
                tv_show = null;
                mDialog.dismiss();
                mDialog = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isShowing() {
        if (mDialog != null) {
            return mDialog.isShowing();
        }
        return false;
    }
}

