/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.maning.mndialoglibrary.R;
import com.maning.mndialoglibrary.config.MToastConfig;
import com.maning.mndialoglibrary.utils.MSizeUtils;

public class MToast {
    private static Toast currentToast;

    public static void makeTextLong(@NonNull Context context, @NonNull CharSequence message, MToastConfig config) {
        MToast.make(config, context, message, 1).show();
    }

    public static void makeTextShort(@NonNull Context context, @NonNull CharSequence message, MToastConfig config) {
        MToast.make(config, context, message, 0).show();
    }

    public static void makeTextLong(@NonNull Context context, @NonNull CharSequence message) {
        MToast.make(null, context, message, 1).show();
    }

    public static void makeTextShort(@NonNull Context context, @NonNull CharSequence message) {
        MToast.make(null, context, message, 0).show();
    }

    private static void makeText(MToastConfig config, @NonNull Context context, @NonNull CharSequence message, int duration) {
        MToast.make(config, context, message, duration).show();
    }

    private static void makeText(@NonNull Context context, @NonNull CharSequence message, int duration) {
        MToast.make(null, context, message, duration).show();
    }

    private static Toast make(MToastConfig config, @NonNull Context context, @NonNull CharSequence message, int duration) {
        MToast.cancelToast();
        Context mCotext = context.getApplicationContext();
        if (currentToast == null) {
            currentToast = new Toast(mCotext);
        }
        View toastLayout = ((LayoutInflater)mCotext.getSystemService("layout_inflater")).inflate(R.layout.mn_toast_layout, null);
        TextView tvShowToast = (TextView)toastLayout.findViewById(R.id.tvShowToast);
        ImageView ivLeftShow = (ImageView)toastLayout.findViewById(R.id.ivLeftShow);
        LinearLayout toastBackgroundView = (LinearLayout)toastLayout.findViewById(R.id.toastBackgroundView);
        currentToast.setView(toastLayout);
        if (config == null) {
            config = new MToastConfig.Builder().build();
        }
        MToastConfig.MToastGravity toastGravity = config.toastGravity;
        int toastTextColor = config.toastTextColor;
        float toastTextSize = config.toastTextSize;
        int toastBackgroundColor = config.toastBackgroundColor;
        float toastBackgroundCornerRadius = config.toastBackgroundCornerRadius;
        Drawable toastIcon = config.toastIcon;
        int toastBackgroundStrokeColor = config.toastBackgroundStrokeColor;
        float toastBackgroundStrokeWidth = config.toastBackgroundStrokeWidth;
        if (toastIcon == null) {
            ivLeftShow.setVisibility(8);
        } else {
            ivLeftShow.setVisibility(0);
            ivLeftShow.setImageDrawable(toastIcon);
        }
        tvShowToast.setTextColor(toastTextColor);
        tvShowToast.setTextSize(2, toastTextSize);
        tvShowToast.setText(message);
        GradientDrawable myGrad = new GradientDrawable();
        myGrad.setCornerRadius((float)MSizeUtils.dp2px(mCotext, toastBackgroundCornerRadius));
        myGrad.setColor(toastBackgroundColor);
        myGrad.setStroke(MSizeUtils.dp2px(mCotext, toastBackgroundStrokeWidth), toastBackgroundStrokeColor);
        if (Build.VERSION.SDK_INT >= 16) {
            toastBackgroundView.setBackground((Drawable)myGrad);
        } else {
            toastBackgroundView.setBackgroundDrawable((Drawable)myGrad);
        }
        toastBackgroundView.setPadding(MSizeUtils.dp2px(mCotext, config.paddingLeft), MSizeUtils.dp2px(mCotext, config.paddingTop), MSizeUtils.dp2px(mCotext, config.paddingRight), MSizeUtils.dp2px(mCotext, config.paddingBottom));
        if (toastGravity == MToastConfig.MToastGravity.CENTRE) {
            currentToast.setGravity(17, 0, 0);
        } else {
            currentToast.setGravity(80, 0, MSizeUtils.dp2px(mCotext, 80.0f));
        }
        if (config.imgWidth > 0 && config.imgHeight > 0) {
            ViewGroup.LayoutParams layoutParams = ivLeftShow.getLayoutParams();
            layoutParams.width = MSizeUtils.dp2px(mCotext, config.imgWidth);
            layoutParams.height = MSizeUtils.dp2px(mCotext, config.imgHeight);
            ivLeftShow.setLayoutParams(layoutParams);
        }
        currentToast.setDuration(duration);
        return currentToast;
    }

    public static void cancelToast() {
        if (currentToast != null) {
            currentToast.cancel();
            currentToast = null;
        }
    }
}

