/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.maning.mndialoglibrary.R;
import com.maning.mndialoglibrary.config.MToastConfig;
import com.maning.mndialoglibrary.utils.MSizeUtils;

public class MToast {
    private static Toast currentToast;
    private static TextView tvShowToast;
    private static ImageView ivLeftShow;
    private static LinearLayout toastBackgroundView;

    public static void makeTextLong(@NonNull Context context, @NonNull CharSequence message, MToastConfig config) {
        MToast.make(config, context, message, 1).show();
    }

    public static void makeTextShort(@NonNull Context context, @NonNull CharSequence message, MToastConfig config) {
        MToast.make(config, context, message, 0).show();
    }

    public static void makeTextLong(@NonNull Context context, @NonNull CharSequence message) {
        MToast.make(null, context, message, 1).show();
    }

    public static void makeTextShort(@NonNull Context context, @NonNull CharSequence message) {
        MToast.make(null, context, message, 0).show();
    }

    private static void makeText(MToastConfig config, @NonNull Context context, @NonNull CharSequence message, int duration) {
        MToast.make(config, context, message, duration).show();
    }

    private static void makeText(@NonNull Context context, @NonNull CharSequence message, int duration) {
        MToast.make(null, context, message, duration).show();
    }

    private static Toast make(MToastConfig config, @NonNull Context context, @NonNull CharSequence message, int duration) {
        if (currentToast == null) {
            currentToast = new Toast(context);
        }
        View toastLayout = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.mn_toast_layout, null);
        tvShowToast = (TextView)toastLayout.findViewById(R.id.tvShowToast);
        ivLeftShow = (ImageView)toastLayout.findViewById(R.id.ivLeftShow);
        toastBackgroundView = (LinearLayout)toastLayout.findViewById(R.id.toastBackgroundView);
        currentToast.setView(toastLayout);
        if (config == null) {
            config = new MToastConfig.Builder().build();
        }
        MToastConfig.MToastGravity ToastGravity = config.ToastGravity;
        int ToastTextColor = config.ToastTextColor;
        float ToastTextSize = config.ToastTextSize;
        int ToastBackgroundColor = config.ToastBackgroundColor;
        float ToastBackgroundCornerRadius = config.ToastBackgroundCornerRadius;
        Drawable ToastIcon = config.ToastIcon;
        int ToastBackgroundStrokeColor = config.ToastBackgroundStrokeColor;
        float ToastBackgroundStrokeWidth = config.ToastBackgroundStrokeWidth;
        if (ToastIcon == null) {
            ivLeftShow.setVisibility(8);
        } else {
            ivLeftShow.setVisibility(0);
            ivLeftShow.setImageDrawable(ToastIcon);
        }
        tvShowToast.setTextColor(ToastTextColor);
        tvShowToast.setTextSize(ToastTextSize);
        GradientDrawable myGrad = new GradientDrawable();
        myGrad.setCornerRadius((float)MSizeUtils.dp2px(context, ToastBackgroundCornerRadius));
        myGrad.setColor(ToastBackgroundColor);
        myGrad.setStroke(MSizeUtils.dp2px(context, ToastBackgroundStrokeWidth), ToastBackgroundStrokeColor);
        toastBackgroundView.setBackground((Drawable)myGrad);
        toastBackgroundView.setPadding(MSizeUtils.dp2px(context, config.paddingLeft), MSizeUtils.dp2px(context, config.paddingTop), MSizeUtils.dp2px(context, config.paddingRight), MSizeUtils.dp2px(context, config.paddingBottom));
        tvShowToast.setText(message);
        currentToast.setDuration(duration);
        if (ToastGravity == MToastConfig.MToastGravity.CENTRE) {
            currentToast.setGravity(17, 0, 0);
        } else {
            currentToast.setGravity(80, 0, MSizeUtils.dp2px(context, 80.0f));
        }
        if (config.imgWidth > 0 && config.imgHeight > 0) {
            ViewGroup.LayoutParams layoutParams = ivLeftShow.getLayoutParams();
            layoutParams.width = MSizeUtils.dp2px(context, config.imgWidth);
            layoutParams.height = MSizeUtils.dp2px(context, config.imgHeight);
            ivLeftShow.setLayoutParams(layoutParams);
        }
        return currentToast;
    }
}

