/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.maning.mndialoglibrary.MProgressDialog;
import com.maning.mndialoglibrary.R;

public class MStatusDialog {
    private Handler mHandler = new Handler();
    private Context mContext;
    private Dialog mDialog;
    private RelativeLayout dialog_view_bg;
    private ImageView imageStatus;
    private TextView tvShow;
    private int imageTintColor;

    public MStatusDialog(Context context) {
        this.mContext = context;
        this.initDialog();
    }

    private void initDialog() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View mProgressDialogView = inflater.inflate(R.layout.mn_status_dialog_layout, null);
        this.mDialog = new Dialog(this.mContext, R.style.MNCustomProgressDialog);
        this.mDialog.setCancelable(false);
        this.mDialog.setCanceledOnTouchOutside(false);
        this.mDialog.setContentView(mProgressDialogView);
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = ((Activity)this.mContext).getWindowManager();
        windowManager.getDefaultDisplay().getMetrics(dm);
        int screenW = dm.widthPixels;
        int screenH = dm.heightPixels;
        WindowManager.LayoutParams layoutParams = this.mDialog.getWindow().getAttributes();
        layoutParams.width = screenW;
        layoutParams.height = screenH;
        this.mDialog.getWindow().setAttributes(layoutParams);
        this.dialog_view_bg = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_view_bg);
        this.imageStatus = (ImageView)mProgressDialogView.findViewById(R.id.imageStatus);
        this.tvShow = (TextView)mProgressDialogView.findViewById(R.id.tvShow);
        this.setBackgroundViewCornerRadius(6.0f);
        this.setTextColor(this.mContext.getResources().getColor(R.color.mn_colorDialogTextColor));
        this.setBackgroundViewColor(this.mContext.getResources().getColor(R.color.mn_colorDialogViewBg));
        this.setBackgroundViewStrokeWidthAndColor(0.0f, this.mContext.getResources().getColor(R.color.mn_colorDialogTrans));
        this.setImageTintColor(this.mContext.getResources().getColor(R.color.mn_colorDialogImageTintColor));
    }

    private void setImageShow(int flag) {
        if (flag == 1) {
            this.imageStatus.setImageResource(R.drawable.mn_icon_dialog_ok);
        } else if (flag == 2) {
            this.imageStatus.setImageResource(R.drawable.mn_icon_dialog_error);
        } else if (flag == 3) {
            this.imageStatus.setImageResource(R.drawable.mn_icon_dialog_hint);
        }
    }

    public void showSuccess(String msg) {
        this.setImageShow(1);
        this.show(msg);
    }

    public void showError(String msg) {
        this.setImageShow(2);
        this.show(msg);
    }

    public void showHint(String msg) {
        this.setImageShow(3);
        this.show(msg);
    }

    public void showCustom(Drawable customDrawable, String msg) {
        this.imageStatus.setImageDrawable(customDrawable);
        this.show(msg);
    }

    private void show(String msg) {
        this.tvShow.setText((CharSequence)msg);
        this.mDialog.show();
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                MStatusDialog.this.mDialog.dismiss();
                MStatusDialog.this.mHandler.removeCallbacksAndMessages(null);
            }
        }, 2000L);
    }

    private int getColor(String colorStr) {
        int color2 = Color.parseColor((String)colorStr);
        return color2;
    }

    public void setBackgroundViewColor(int colorID) {
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setColor(colorID);
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void setBackgroundViewColor(String colorStr) {
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setColor(this.getColor(colorStr));
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void setBackgroundViewStrokeWidthAndColor(float width, int colorID) {
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setStroke(MProgressDialog.dip2px(this.mContext, width), colorID);
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void setBackgroundViewCornerRadius(float radius) {
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setCornerRadius((float)MProgressDialog.dip2px(this.mContext, radius));
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void setImageTintColor(int colorID) {
        this.imageTintColor = colorID;
    }

    public void setTextColor(int colorID) {
        this.tvShow.setTextColor(colorID);
    }
}

