/*
 * Decompiled with CFR 0.152.
 */
package com.maning.mndialoglibrary;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.maning.mndialoglibrary.MProgressWheel;
import com.maning.mndialoglibrary.R;

public class MProgressDialog
implements View.OnClickListener {
    private Dialog mProgressDialog;
    private Context mContext;
    private OnDialogDismissListener mDialogDismissListener;
    private RelativeLayout dialog_window_background;
    private RelativeLayout dialog_view_bg;
    private MProgressWheel progress_wheel;
    private TextView tv_show;
    private boolean canceledOnTouchOutside = false;
    private static final String defaultTextShow = "\u52a0\u8f7d\u4e2d...";

    public MProgressDialog(Context context) {
        this.mContext = context;
        this.initDialog();
    }

    private void initDialog() {
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        View mProgressDialogView = inflater.inflate(R.layout.mn_progress_dialog_layout, null);
        this.mProgressDialog = new Dialog(this.mContext, R.style.MNCustomProgressDialog);
        this.mProgressDialog.setCancelable(false);
        this.mProgressDialog.setCanceledOnTouchOutside(false);
        this.mProgressDialog.setContentView(mProgressDialogView);
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = ((Activity)this.mContext).getWindowManager();
        windowManager.getDefaultDisplay().getMetrics(dm);
        int screenW = dm.widthPixels;
        int screenH = dm.heightPixels;
        WindowManager.LayoutParams layoutParams = this.mProgressDialog.getWindow().getAttributes();
        layoutParams.width = screenW;
        layoutParams.height = screenH;
        this.mProgressDialog.getWindow().setAttributes(layoutParams);
        this.dialog_window_background = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_window_background);
        this.dialog_view_bg = (RelativeLayout)mProgressDialogView.findViewById(R.id.dialog_view_bg);
        this.progress_wheel = (MProgressWheel)mProgressDialogView.findViewById(R.id.progress_wheel);
        this.tv_show = (TextView)mProgressDialogView.findViewById(R.id.tv_show);
        this.dialog_window_background.setOnClickListener((View.OnClickListener)this);
        this.progress_wheel.stopSpinning();
        this.tv_show.setText((CharSequence)defaultTextShow);
        this.setCanceledOnTouchOutside(false);
        this.setBackgroundWindowColor(this.getColor(R.color.mn_colorDialogWindowBg));
        this.setBackgroundViewColor(this.getColor(R.color.mn_colorDialogViewBg));
        this.setBackgroundViewStrokeWidthAndColor(0.0f, this.mContext.getResources().getColor(R.color.mn_colorDialogTrans));
        this.setProgressColor(this.getColor(R.color.mn_colorDialogProgressBarColor));
        this.setDialogTextColor(this.getColor(R.color.mn_colorDialogTextColor));
        this.setProgressWidth(2);
        this.setBackgroundViewCornerRadius(6.0f);
    }

    public void show() {
        this.dismiss();
        this.tv_show.setVisibility(0);
        this.tv_show.setText((CharSequence)defaultTextShow);
        if (this.mProgressDialog != null) {
            this.progress_wheel.spin();
            this.mProgressDialog.show();
        }
    }

    public void showNoText() {
        this.dismiss();
        this.tv_show.setVisibility(8);
        if (this.mProgressDialog != null) {
            this.progress_wheel.spin();
            this.mProgressDialog.show();
        }
    }

    public void show(String msg) {
        this.dismiss();
        if (TextUtils.isEmpty((CharSequence)msg)) {
            msg = defaultTextShow;
        }
        this.tv_show.setVisibility(0);
        this.tv_show.setText((CharSequence)msg);
        if (this.mProgressDialog != null) {
            this.progress_wheel.spin();
            this.mProgressDialog.show();
        }
    }

    public void dismiss() {
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.progress_wheel.stopSpinning();
            this.mProgressDialog.dismiss();
            if (this.mDialogDismissListener != null) {
                this.mDialogDismissListener.dismiss();
            }
        }
    }

    public void showWithProgress() {
        this.dismiss();
        this.progress_wheel.stopSpinning();
        this.progress_wheel.setLinearProgress(true);
        this.progress_wheel.setProgress(0.0f);
        this.tv_show.setVisibility(0);
        this.tv_show.setText((CharSequence)defaultTextShow);
        if (this.mProgressDialog != null) {
            this.mProgressDialog.show();
        }
    }

    public void setCanceledOnTouchOutside(boolean cancle) {
        this.canceledOnTouchOutside = cancle;
    }

    public void setBackgroundWindowColor(int colorID) {
        this.dialog_window_background.setBackgroundColor(colorID);
    }

    public void setBackgroundWindowColor(String colorStr) {
        this.dialog_window_background.setBackgroundColor(this.getColor(colorStr));
    }

    public void setBackgroundViewColor(int colorID) {
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setColor(colorID);
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void setBackgroundViewColor(String colorStr) {
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setColor(this.getColor(colorStr));
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void setBackgroundViewStrokeWidthAndColor(float width, int colorID) {
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setStroke(MProgressDialog.dip2px(this.mContext, width), colorID);
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void setBackgroundViewCornerRadius(float radius) {
        GradientDrawable myGrad = (GradientDrawable)this.dialog_view_bg.getBackground();
        myGrad.setCornerRadius((float)MProgressDialog.dip2px(this.mContext, radius));
        this.dialog_view_bg.setBackground((Drawable)myGrad);
    }

    public void setProgressColor(int colorID) {
        this.progress_wheel.setBarColor(colorID);
    }

    public void setProgressColor(String colorStr) {
        this.progress_wheel.setBarColor(this.getColor(colorStr));
    }

    public void setProgressWidth(int progressWidth) {
        this.progress_wheel.setBarWidth(MProgressDialog.dip2px(this.mContext, progressWidth));
    }

    public void setDialogTextColor(int colorID) {
        this.tv_show.setTextColor(colorID);
    }

    public void setDialogTextColor(String colorStr) {
        this.progress_wheel.setBarColor(this.getColor(colorStr));
    }

    private int getColor(int colorID) {
        int color2 = this.mContext.getResources().getColor(colorID);
        return color2;
    }

    private int getColor(String colorStr) {
        int color2 = Color.parseColor((String)colorStr);
        return color2;
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.dialog_window_background && this.canceledOnTouchOutside) {
            this.dismiss();
        }
    }

    public void setOnDialogDismissListener(OnDialogDismissListener dialogDismissListener) {
        this.mDialogDismissListener = dialogDismissListener;
    }

    public void setDialogProgress(float progress) {
        this.progress_wheel.setProgress(progress);
    }

    public void setProgressRimColor(int colorID) {
        this.progress_wheel.setRimColor(colorID);
    }

    public void setProgressRimWidth(int width) {
        this.progress_wheel.setRimWidth(width);
    }

    public void setDialogText(String dialogText) {
        this.tv_show.setText((CharSequence)dialogText);
    }

    public static interface OnDialogDismissListener {
        public void dismiss();
    }
}

