/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.widget.RelativeLayout;

public class MNGestureView
extends RelativeLayout {
    private static final int mHeight = 500;
    private float mDisplacementX;
    private float mDisplacementY;
    private float mInitialTy;
    private float mInitialTx;
    private boolean mTracking;
    private OnSwipeListener onSwipeListener;
    private OnCanSwipeListener onCanSwipeListener;

    public MNGestureView(Context context) {
        this(context, null);
    }

    public MNGestureView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MNGestureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mDisplacementX = event.getRawX();
                this.mDisplacementY = event.getRawY();
                this.mInitialTy = this.getTranslationY();
                this.mInitialTx = this.getTranslationX();
                break;
            }
            case 2: {
                boolean canSwipe;
                float deltaX = event.getRawX() - this.mDisplacementX;
                float deltaY = event.getRawY() - this.mDisplacementY;
                if (this.onCanSwipeListener != null && !(canSwipe = this.onCanSwipeListener.canSwipe())) break;
                if (deltaY > 0.0f && Math.abs(deltaY) > (float)(ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop() * 2) && Math.abs(deltaX) < Math.abs(deltaY) / 2.0f || this.mTracking) {
                    this.onSwipeListener.onSwiping(deltaY);
                    this.setBackgroundColor(0);
                    this.mTracking = true;
                    this.setTranslationY(this.mInitialTy + deltaY);
                    this.setTranslationX(this.mInitialTx + deltaX);
                    float mScale = 1.0f - deltaY / 500.0f;
                    if ((double)mScale < 0.3) {
                        mScale = 0.3f;
                    }
                    this.setScaleX(mScale);
                    this.setScaleY(mScale);
                }
                if (!(deltaY < 0.0f)) break;
                this.setViewDefault();
                break;
            }
            case 1: {
                if (this.mTracking) {
                    this.mTracking = false;
                    float currentTranslateY = this.getTranslationY();
                    if (currentTranslateY > 166.0f) {
                        this.onSwipeListener.downSwipe();
                        break;
                    }
                }
                this.setViewDefault();
                this.onSwipeListener.overSwipe();
            }
        }
        return false;
    }

    private void setViewDefault() {
        this.setAlpha(1.0f);
        this.setTranslationX(0.0f);
        this.setTranslationY(0.0f);
        this.setScaleX(1.0f);
        this.setScaleY(1.0f);
        this.setBackgroundColor(-16777216);
    }

    public void setOnSwipeListener(OnSwipeListener onSwipeListener) {
        this.onSwipeListener = onSwipeListener;
    }

    public void setOnGestureListener(OnCanSwipeListener onCanSwipeListener) {
        this.onCanSwipeListener = onCanSwipeListener;
    }

    public static interface OnCanSwipeListener {
        public boolean canSwipe();
    }

    public static interface OnSwipeListener {
        public void downSwipe();

        public void overSwipe();

        public void onSwiping(float var1);
    }
}

