/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.utils.immersionbar;

import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.maning.imagebrowserlibrary.utils.immersionbar.ImmersionBar;
import com.maning.imagebrowserlibrary.utils.immersionbar.RequestManagerFragment;
import com.maning.imagebrowserlibrary.utils.immersionbar.SupportRequestManagerFragment;
import java.util.HashMap;
import java.util.Map;

class RequestManagerRetriever
implements Handler.Callback {
    private String mTag = ImmersionBar.class.getName();
    private Handler mHandler;
    private static final int ID_REMOVE_FRAGMENT_MANAGER = 1;
    private static final int ID_REMOVE_SUPPORT_FRAGMENT_MANAGER = 2;
    private final Map<android.app.FragmentManager, RequestManagerFragment> mPendingFragments = new HashMap<android.app.FragmentManager, RequestManagerFragment>();
    private final Map<FragmentManager, SupportRequestManagerFragment> mPendingSupportFragments = new HashMap<FragmentManager, SupportRequestManagerFragment>();

    static RequestManagerRetriever getInstance() {
        return Holder.INSTANCE;
    }

    private RequestManagerRetriever() {
        this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
    }

    public ImmersionBar get(Activity activity) {
        RequestManagerRetriever.checkNotNull(activity, "activity is null");
        if (activity instanceof FragmentActivity) {
            return this.getSupportFragment(((FragmentActivity)activity).getSupportFragmentManager(), this.mTag + activity.toString()).get(activity);
        }
        return this.getFragment(activity.getFragmentManager(), this.mTag + activity.toString()).get(activity);
    }

    public ImmersionBar get(androidx.fragment.app.Fragment fragment) {
        RequestManagerRetriever.checkNotNull(fragment, "fragment is null");
        RequestManagerRetriever.checkNotNull(fragment.getActivity(), "fragment.getActivity() is null");
        if (fragment instanceof DialogFragment) {
            RequestManagerRetriever.checkNotNull(((DialogFragment)fragment).getDialog(), "fragment.getDialog() is null");
        }
        return this.getSupportFragment(fragment.getChildFragmentManager(), this.mTag + fragment.toString()).get(fragment);
    }

    @RequiresApi(api=17)
    public ImmersionBar get(Fragment fragment) {
        RequestManagerRetriever.checkNotNull(fragment, "fragment is null");
        RequestManagerRetriever.checkNotNull(fragment.getActivity(), "fragment.getActivity() is null");
        if (fragment instanceof android.app.DialogFragment) {
            RequestManagerRetriever.checkNotNull(((android.app.DialogFragment)fragment).getDialog(), "fragment.getDialog() is null");
        }
        return this.getFragment(fragment.getChildFragmentManager(), this.mTag + fragment.toString()).get(fragment);
    }

    public ImmersionBar get(Activity activity, Dialog dialog) {
        RequestManagerRetriever.checkNotNull(activity, "activity is null");
        RequestManagerRetriever.checkNotNull(dialog, "dialog is null");
        if (activity instanceof FragmentActivity) {
            return this.getSupportFragment(((FragmentActivity)activity).getSupportFragmentManager(), this.mTag + dialog.toString()).get(activity, dialog);
        }
        return this.getFragment(activity.getFragmentManager(), this.mTag + dialog.toString()).get(activity, dialog);
    }

    public void destroy(Activity activity, Dialog dialog) {
        if (activity == null || dialog == null) {
            return;
        }
        if (activity instanceof FragmentActivity) {
            SupportRequestManagerFragment fragment = this.getSupportFragment(((FragmentActivity)activity).getSupportFragmentManager(), this.mTag + dialog.toString(), true);
            if (fragment != null) {
                fragment.get(activity, dialog).destroy();
            }
        } else {
            RequestManagerFragment fragment = this.getFragment(activity.getFragmentManager(), this.mTag + dialog.toString(), true);
            if (fragment != null) {
                fragment.get(activity, dialog).destroy();
            }
        }
    }

    public boolean handleMessage(Message msg) {
        boolean handled = true;
        switch (msg.what) {
            case 1: {
                android.app.FragmentManager fm = (android.app.FragmentManager)msg.obj;
                this.mPendingFragments.remove(fm);
                break;
            }
            case 2: {
                FragmentManager supportFm = (FragmentManager)msg.obj;
                this.mPendingSupportFragments.remove(supportFm);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    private RequestManagerFragment getFragment(android.app.FragmentManager fm, String tag) {
        return this.getFragment(fm, tag, false);
    }

    private RequestManagerFragment getFragment(android.app.FragmentManager fm, String tag, boolean destroy) {
        RequestManagerFragment fragment = (RequestManagerFragment)fm.findFragmentByTag(tag);
        if (fragment == null && (fragment = this.mPendingFragments.get(fm)) == null) {
            if (destroy) {
                return null;
            }
            fragment = new RequestManagerFragment();
            this.mPendingFragments.put(fm, fragment);
            fm.beginTransaction().add((Fragment)fragment, tag).commitAllowingStateLoss();
            this.mHandler.obtainMessage(1, (Object)fm).sendToTarget();
        }
        if (destroy) {
            fm.beginTransaction().remove((Fragment)fragment).commitAllowingStateLoss();
            return null;
        }
        return fragment;
    }

    private SupportRequestManagerFragment getSupportFragment(FragmentManager fm, String tag) {
        return this.getSupportFragment(fm, tag, false);
    }

    private SupportRequestManagerFragment getSupportFragment(FragmentManager fm, String tag, boolean destroy) {
        SupportRequestManagerFragment fragment = (SupportRequestManagerFragment)fm.findFragmentByTag(tag);
        if (fragment == null && (fragment = this.mPendingSupportFragments.get(fm)) == null) {
            if (destroy) {
                return null;
            }
            fragment = new SupportRequestManagerFragment();
            this.mPendingSupportFragments.put(fm, fragment);
            fm.beginTransaction().add((androidx.fragment.app.Fragment)fragment, tag).commitAllowingStateLoss();
            this.mHandler.obtainMessage(2, (Object)fm).sendToTarget();
        }
        if (destroy) {
            fm.beginTransaction().remove((androidx.fragment.app.Fragment)fragment).commitAllowingStateLoss();
            return null;
        }
        return fragment;
    }

    private static <T> void checkNotNull(@Nullable T arg, @NonNull String message) {
        if (arg == null) {
            throw new NullPointerException(message);
        }
    }

    private static class Holder {
        private static final RequestManagerRetriever INSTANCE = new RequestManagerRetriever();

        private Holder() {
        }
    }
}

