/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.utils.immersionbar;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.DisplayCutout;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import com.maning.imagebrowserlibrary.utils.immersionbar.ImmersionBar;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class NotchUtils {
    private static final String SYSTEM_PROPERTIES = "android.os.SystemProperties";
    private static final String NOTCH_XIAO_MI = "ro.miui.notch";
    private static final String NOTCH_HUA_WEI = "com.huawei.android.util.HwNotchSizeUtil";
    private static final String NOTCH_VIVO = "android.util.FtFeature";
    private static final String NOTCH_OPPO = "com.oppo.feature.screen.heteromorphism";

    public static boolean hasNotchScreen(Activity activity) {
        return activity != null && (NotchUtils.hasNotchAtXiaoMi((Context)activity) || NotchUtils.hasNotchAtHuaWei((Context)activity) || NotchUtils.hasNotchAtOPPO((Context)activity) || NotchUtils.hasNotchAtVIVO((Context)activity) || NotchUtils.hasNotchAtAndroidP(activity));
    }

    public static boolean hasNotchScreen(View view) {
        return view != null && (NotchUtils.hasNotchAtXiaoMi(view.getContext()) || NotchUtils.hasNotchAtHuaWei(view.getContext()) || NotchUtils.hasNotchAtOPPO(view.getContext()) || NotchUtils.hasNotchAtVIVO(view.getContext()) || NotchUtils.hasNotchAtAndroidP(view));
    }

    private static boolean hasNotchAtAndroidP(View view) {
        return NotchUtils.getDisplayCutout(view) != null;
    }

    private static boolean hasNotchAtAndroidP(Activity activity) {
        return NotchUtils.getDisplayCutout(activity) != null;
    }

    private static DisplayCutout getDisplayCutout(Activity activity) {
        WindowInsets windowInsets;
        Window window;
        if (Build.VERSION.SDK_INT >= 28 && activity != null && (window = activity.getWindow()) != null && (windowInsets = window.getDecorView().getRootWindowInsets()) != null) {
            return windowInsets.getDisplayCutout();
        }
        return null;
    }

    private static DisplayCutout getDisplayCutout(View view) {
        WindowInsets windowInsets;
        if (Build.VERSION.SDK_INT >= 28 && view != null && (windowInsets = view.getRootWindowInsets()) != null) {
            return windowInsets.getDisplayCutout();
        }
        return null;
    }

    private static boolean hasNotchAtXiaoMi(Context context) {
        int result = 0;
        if ("Xiaomi".equals(Build.MANUFACTURER)) {
            try {
                ClassLoader classLoader = context.getClassLoader();
                Class<?> aClass = classLoader.loadClass(SYSTEM_PROPERTIES);
                Method method = aClass.getMethod("getInt", String.class, Integer.TYPE);
                result = (Integer)method.invoke(aClass, NOTCH_XIAO_MI, 0);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return result == 1;
    }

    private static boolean hasNotchAtHuaWei(Context context) {
        boolean result = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> aClass = classLoader.loadClass(NOTCH_HUA_WEI);
            Method get = aClass.getMethod("hasNotchInScreen", new Class[0]);
            result = (Boolean)get.invoke(aClass, new Object[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean hasNotchAtVIVO(Context context) {
        boolean result = false;
        try {
            ClassLoader classLoader = context.getClassLoader();
            Class<?> aClass = classLoader.loadClass(NOTCH_VIVO);
            Method method = aClass.getMethod("isFeatureSupport", Integer.TYPE);
            result = (Boolean)method.invoke(aClass, 32);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private static boolean hasNotchAtOPPO(Context context) {
        try {
            return context.getPackageManager().hasSystemFeature(NOTCH_OPPO);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static int getNotchHeight(Activity activity) {
        int notchHeight = 0;
        int statusBarHeight = ImmersionBar.getStatusBarHeight(activity);
        DisplayCutout displayCutout = NotchUtils.getDisplayCutout(activity);
        if (Build.VERSION.SDK_INT >= 28 && displayCutout != null) {
            notchHeight = activity.getResources().getConfiguration().orientation == 1 ? displayCutout.getSafeInsetTop() : (displayCutout.getSafeInsetLeft() == 0 ? displayCutout.getSafeInsetRight() : displayCutout.getSafeInsetLeft());
        } else {
            if (NotchUtils.hasNotchAtXiaoMi((Context)activity)) {
                notchHeight = NotchUtils.getXiaoMiNotchHeight((Context)activity);
            }
            if (NotchUtils.hasNotchAtHuaWei((Context)activity)) {
                notchHeight = NotchUtils.getHuaWeiNotchSize((Context)activity)[1];
            }
            if (NotchUtils.hasNotchAtVIVO((Context)activity) && (notchHeight = NotchUtils.dp2px((Context)activity, 32)) < statusBarHeight) {
                notchHeight = statusBarHeight;
            }
            if (NotchUtils.hasNotchAtOPPO((Context)activity) && (notchHeight = 80) < statusBarHeight) {
                notchHeight = statusBarHeight;
            }
        }
        return notchHeight;
    }

    private static int getXiaoMiNotchHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("notch_height", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    private static int[] getHuaWeiNotchSize(Context context) {
        int[] ret = new int[]{0, 0};
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> aClass = cl.loadClass(NOTCH_HUA_WEI);
            Method get = aClass.getMethod("getNotchSize", new Class[0]);
            return (int[])get.invoke(aClass, new Object[0]);
        }
        catch (ClassNotFoundException ignored) {
            return ret;
        }
        catch (NoSuchMethodException ignored) {
            return ret;
        }
        catch (Exception ignored) {
            return ret;
        }
    }

    private static int dp2px(Context context, int dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

