/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.utils.immersionbar;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.fragment.app.DialogFragment;
import com.maning.imagebrowserlibrary.R;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarConfig;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarHide;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarParams;
import com.maning.imagebrowserlibrary.utils.immersionbar.Constants;
import com.maning.imagebrowserlibrary.utils.immersionbar.EMUI3NavigationBarObserver;
import com.maning.imagebrowserlibrary.utils.immersionbar.FitsKeyboard;
import com.maning.imagebrowserlibrary.utils.immersionbar.FlymeOSStatusBarFontUtils;
import com.maning.imagebrowserlibrary.utils.immersionbar.ImmersionCallback;
import com.maning.imagebrowserlibrary.utils.immersionbar.NavigationBarObserver;
import com.maning.imagebrowserlibrary.utils.immersionbar.NotchUtils;
import com.maning.imagebrowserlibrary.utils.immersionbar.OSUtils;
import com.maning.imagebrowserlibrary.utils.immersionbar.OnBarListener;
import com.maning.imagebrowserlibrary.utils.immersionbar.OnKeyboardListener;
import com.maning.imagebrowserlibrary.utils.immersionbar.OnNavigationBarListener;
import com.maning.imagebrowserlibrary.utils.immersionbar.RequestManagerRetriever;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@TargetApi(value=19)
public final class ImmersionBar
implements ImmersionCallback {
    private Activity mActivity;
    private androidx.fragment.app.Fragment mSupportFragment;
    private Fragment mFragment;
    private Dialog mDialog;
    private Window mWindow;
    private ViewGroup mDecorView;
    private ViewGroup mContentView;
    private boolean mIsActivity = false;
    private boolean mIsFragment = false;
    private boolean mIsDialog = false;
    private BarParams mBarParams;
    private BarConfig mBarConfig;
    private int mNavigationBarHeight = 0;
    private int mNavigationBarWidth = 0;
    private int mActionBarHeight = 0;
    private FitsKeyboard mFitsKeyboard = null;
    private Map<String, BarParams> mTagMap = new HashMap<String, BarParams>();
    private int mFitsStatusBarType = 0;
    private boolean mInitialized = false;
    private boolean mIsActionBarBelowLOLLIPOP = false;
    private boolean mKeyboardTempEnable = false;
    private int mPaddingLeft = 0;
    private int mPaddingTop = 0;
    private int mPaddingRight = 0;
    private int mPaddingBottom = 0;

    public static ImmersionBar with(@NonNull Activity activity) {
        return ImmersionBar.getRetriever().get(activity);
    }

    public static ImmersionBar with(@NonNull androidx.fragment.app.Fragment fragment) {
        return ImmersionBar.getRetriever().get(fragment);
    }

    public static ImmersionBar with(@NonNull Fragment fragment) {
        return ImmersionBar.getRetriever().get(fragment);
    }

    public static ImmersionBar with(@NonNull DialogFragment dialogFragment) {
        return ImmersionBar.getRetriever().get((androidx.fragment.app.Fragment)dialogFragment);
    }

    public static ImmersionBar with(@NonNull android.app.DialogFragment dialogFragment) {
        return ImmersionBar.getRetriever().get((Fragment)dialogFragment);
    }

    public static ImmersionBar with(@NonNull Activity activity, @NonNull Dialog dialog) {
        return ImmersionBar.getRetriever().get(activity, dialog);
    }

    public static void destroy(@NonNull Activity activity, @NonNull Dialog dialog) {
        ImmersionBar.getRetriever().destroy(activity, dialog);
    }

    ImmersionBar(Activity activity) {
        this.mIsActivity = true;
        this.mActivity = activity;
        this.initCommonParameter(this.mActivity.getWindow());
    }

    ImmersionBar(androidx.fragment.app.Fragment fragment) {
        this.mIsFragment = true;
        this.mActivity = fragment.getActivity();
        this.mSupportFragment = fragment;
        this.checkInitWithActivity();
        this.initCommonParameter(this.mActivity.getWindow());
    }

    ImmersionBar(Fragment fragment) {
        this.mIsFragment = true;
        this.mActivity = fragment.getActivity();
        this.mFragment = fragment;
        this.checkInitWithActivity();
        this.initCommonParameter(this.mActivity.getWindow());
    }

    ImmersionBar(DialogFragment dialogFragment) {
        this.mIsDialog = true;
        this.mActivity = dialogFragment.getActivity();
        this.mSupportFragment = dialogFragment;
        this.mDialog = dialogFragment.getDialog();
        this.checkInitWithActivity();
        this.initCommonParameter(this.mDialog.getWindow());
    }

    ImmersionBar(android.app.DialogFragment dialogFragment) {
        this.mIsDialog = true;
        this.mActivity = dialogFragment.getActivity();
        this.mFragment = dialogFragment;
        this.mDialog = dialogFragment.getDialog();
        this.checkInitWithActivity();
        this.initCommonParameter(this.mDialog.getWindow());
    }

    ImmersionBar(Activity activity, Dialog dialog) {
        this.mIsDialog = true;
        this.mActivity = activity;
        this.mDialog = dialog;
        this.checkInitWithActivity();
        this.initCommonParameter(this.mDialog.getWindow());
    }

    private void checkInitWithActivity() {
        if (!ImmersionBar.with(this.mActivity).initialized()) {
            ImmersionBar.with(this.mActivity).init();
        }
    }

    private void initCommonParameter(Window window) {
        this.mWindow = window;
        this.mBarParams = new BarParams();
        this.mDecorView = (ViewGroup)this.mWindow.getDecorView();
        this.mContentView = (ViewGroup)this.mDecorView.findViewById(0x1020002);
    }

    public ImmersionBar transparentStatusBar() {
        this.mBarParams.statusBarColor = 0;
        return this;
    }

    public ImmersionBar transparentNavigationBar() {
        this.mBarParams.navigationBarColor = 0;
        this.mBarParams.fullScreen = true;
        return this;
    }

    public ImmersionBar transparentBar() {
        this.mBarParams.statusBarColor = 0;
        this.mBarParams.navigationBarColor = 0;
        this.mBarParams.fullScreen = true;
        return this;
    }

    public ImmersionBar statusBarColor(@ColorRes int statusBarColor) {
        return this.statusBarColorInt(ContextCompat.getColor((Context)this.mActivity, (int)statusBarColor));
    }

    public ImmersionBar statusBarColor(@ColorRes int statusBarColor, @FloatRange(from=0.0, to=1.0) float alpha) {
        return this.statusBarColorInt(ContextCompat.getColor((Context)this.mActivity, (int)statusBarColor), alpha);
    }

    public ImmersionBar statusBarColor(@ColorRes int statusBarColor, @ColorRes int statusBarColorTransform, @FloatRange(from=0.0, to=1.0) float alpha) {
        return this.statusBarColorInt(ContextCompat.getColor((Context)this.mActivity, (int)statusBarColor), ContextCompat.getColor((Context)this.mActivity, (int)statusBarColorTransform), alpha);
    }

    public ImmersionBar statusBarColor(String statusBarColor) {
        return this.statusBarColorInt(Color.parseColor((String)statusBarColor));
    }

    public ImmersionBar statusBarColor(String statusBarColor, @FloatRange(from=0.0, to=1.0) float alpha) {
        return this.statusBarColorInt(Color.parseColor((String)statusBarColor), alpha);
    }

    public ImmersionBar statusBarColor(String statusBarColor, String statusBarColorTransform, @FloatRange(from=0.0, to=1.0) float alpha) {
        return this.statusBarColorInt(Color.parseColor((String)statusBarColor), Color.parseColor((String)statusBarColorTransform), alpha);
    }

    public ImmersionBar statusBarColorInt(@ColorInt int statusBarColor) {
        this.mBarParams.statusBarColor = statusBarColor;
        return this;
    }

    public ImmersionBar statusBarColorInt(@ColorInt int statusBarColor, @FloatRange(from=0.0, to=1.0) float alpha) {
        this.mBarParams.statusBarColor = statusBarColor;
        this.mBarParams.statusBarAlpha = alpha;
        return this;
    }

    public ImmersionBar statusBarColorInt(@ColorInt int statusBarColor, @ColorInt int statusBarColorTransform, @FloatRange(from=0.0, to=1.0) float alpha) {
        this.mBarParams.statusBarColor = statusBarColor;
        this.mBarParams.statusBarColorTransform = statusBarColorTransform;
        this.mBarParams.statusBarAlpha = alpha;
        return this;
    }

    public ImmersionBar navigationBarColor(@ColorRes int navigationBarColor) {
        return this.navigationBarColorInt(ContextCompat.getColor((Context)this.mActivity, (int)navigationBarColor));
    }

    public ImmersionBar navigationBarColor(@ColorRes int navigationBarColor, @FloatRange(from=0.0, to=1.0) float navigationAlpha) {
        return this.navigationBarColorInt(ContextCompat.getColor((Context)this.mActivity, (int)navigationBarColor), navigationAlpha);
    }

    public ImmersionBar navigationBarColor(@ColorRes int navigationBarColor, @ColorRes int navigationBarColorTransform, @FloatRange(from=0.0, to=1.0) float navigationAlpha) {
        return this.navigationBarColorInt(ContextCompat.getColor((Context)this.mActivity, (int)navigationBarColor), ContextCompat.getColor((Context)this.mActivity, (int)navigationBarColorTransform), navigationAlpha);
    }

    public ImmersionBar navigationBarColor(String navigationBarColor) {
        return this.navigationBarColorInt(Color.parseColor((String)navigationBarColor));
    }

    public ImmersionBar navigationBarColor(String navigationBarColor, @FloatRange(from=0.0, to=1.0) float navigationAlpha) {
        return this.navigationBarColorInt(Color.parseColor((String)navigationBarColor), navigationAlpha);
    }

    public ImmersionBar navigationBarColor(String navigationBarColor, String navigationBarColorTransform, @FloatRange(from=0.0, to=1.0) float navigationAlpha) {
        return this.navigationBarColorInt(Color.parseColor((String)navigationBarColor), Color.parseColor((String)navigationBarColorTransform), navigationAlpha);
    }

    public ImmersionBar navigationBarColorInt(@ColorInt int navigationBarColor) {
        this.mBarParams.navigationBarColor = navigationBarColor;
        return this;
    }

    public ImmersionBar navigationBarColorInt(@ColorInt int navigationBarColor, @FloatRange(from=0.0, to=1.0) float navigationAlpha) {
        this.mBarParams.navigationBarColor = navigationBarColor;
        this.mBarParams.navigationBarAlpha = navigationAlpha;
        return this;
    }

    public ImmersionBar navigationBarColorInt(@ColorInt int navigationBarColor, @ColorInt int navigationBarColorTransform, @FloatRange(from=0.0, to=1.0) float navigationAlpha) {
        this.mBarParams.navigationBarColor = navigationBarColor;
        this.mBarParams.navigationBarColorTransform = navigationBarColorTransform;
        this.mBarParams.navigationBarAlpha = navigationAlpha;
        return this;
    }

    public ImmersionBar barColor(@ColorRes int barColor) {
        return this.barColorInt(ContextCompat.getColor((Context)this.mActivity, (int)barColor));
    }

    public ImmersionBar barColor(@ColorRes int barColor, @FloatRange(from=0.0, to=1.0) float barAlpha) {
        return this.barColorInt(ContextCompat.getColor((Context)this.mActivity, (int)barColor), barColor);
    }

    public ImmersionBar barColor(@ColorRes int barColor, @ColorRes int barColorTransform, @FloatRange(from=0.0, to=1.0) float barAlpha) {
        return this.barColorInt(ContextCompat.getColor((Context)this.mActivity, (int)barColor), ContextCompat.getColor((Context)this.mActivity, (int)barColorTransform), barAlpha);
    }

    public ImmersionBar barColor(String barColor) {
        return this.barColorInt(Color.parseColor((String)barColor));
    }

    public ImmersionBar barColor(String barColor, @FloatRange(from=0.0, to=1.0) float barAlpha) {
        return this.barColorInt(Color.parseColor((String)barColor), barAlpha);
    }

    public ImmersionBar barColor(String barColor, String barColorTransform, @FloatRange(from=0.0, to=1.0) float barAlpha) {
        return this.barColorInt(Color.parseColor((String)barColor), Color.parseColor((String)barColorTransform), barAlpha);
    }

    public ImmersionBar barColorInt(@ColorInt int barColor) {
        this.mBarParams.statusBarColor = barColor;
        this.mBarParams.navigationBarColor = barColor;
        return this;
    }

    public ImmersionBar barColorInt(@ColorInt int barColor, @FloatRange(from=0.0, to=1.0) float barAlpha) {
        this.mBarParams.statusBarColor = barColor;
        this.mBarParams.navigationBarColor = barColor;
        this.mBarParams.statusBarAlpha = barAlpha;
        this.mBarParams.navigationBarAlpha = barAlpha;
        return this;
    }

    public ImmersionBar barColorInt(@ColorInt int barColor, @ColorInt int barColorTransform, @FloatRange(from=0.0, to=1.0) float barAlpha) {
        this.mBarParams.statusBarColor = barColor;
        this.mBarParams.navigationBarColor = barColor;
        this.mBarParams.statusBarColorTransform = barColorTransform;
        this.mBarParams.navigationBarColorTransform = barColorTransform;
        this.mBarParams.statusBarAlpha = barAlpha;
        this.mBarParams.navigationBarAlpha = barAlpha;
        return this;
    }

    public ImmersionBar statusBarColorTransform(@ColorRes int statusBarColorTransform) {
        return this.statusBarColorTransformInt(ContextCompat.getColor((Context)this.mActivity, (int)statusBarColorTransform));
    }

    public ImmersionBar statusBarColorTransform(String statusBarColorTransform) {
        return this.statusBarColorTransformInt(Color.parseColor((String)statusBarColorTransform));
    }

    public ImmersionBar statusBarColorTransformInt(@ColorInt int statusBarColorTransform) {
        this.mBarParams.statusBarColorTransform = statusBarColorTransform;
        return this;
    }

    public ImmersionBar navigationBarColorTransform(@ColorRes int navigationBarColorTransform) {
        return this.navigationBarColorTransformInt(ContextCompat.getColor((Context)this.mActivity, (int)navigationBarColorTransform));
    }

    public ImmersionBar navigationBarColorTransform(String navigationBarColorTransform) {
        return this.navigationBarColorTransformInt(Color.parseColor((String)navigationBarColorTransform));
    }

    public ImmersionBar navigationBarColorTransformInt(@ColorInt int navigationBarColorTransform) {
        this.mBarParams.navigationBarColorTransform = navigationBarColorTransform;
        return this;
    }

    public ImmersionBar barColorTransform(@ColorRes int barColorTransform) {
        return this.barColorTransformInt(ContextCompat.getColor((Context)this.mActivity, (int)barColorTransform));
    }

    public ImmersionBar barColorTransform(String barColorTransform) {
        return this.barColorTransformInt(Color.parseColor((String)barColorTransform));
    }

    public ImmersionBar barColorTransformInt(@ColorInt int barColorTransform) {
        this.mBarParams.statusBarColorTransform = barColorTransform;
        this.mBarParams.navigationBarColorTransform = barColorTransform;
        return this;
    }

    public ImmersionBar addViewSupportTransformColor(View view) {
        return this.addViewSupportTransformColorInt(view, this.mBarParams.statusBarColorTransform);
    }

    public ImmersionBar addViewSupportTransformColor(View view, @ColorRes int viewColorAfterTransform) {
        return this.addViewSupportTransformColorInt(view, ContextCompat.getColor((Context)this.mActivity, (int)viewColorAfterTransform));
    }

    public ImmersionBar addViewSupportTransformColor(View view, @ColorRes int viewColorBeforeTransform, @ColorRes int viewColorAfterTransform) {
        return this.addViewSupportTransformColorInt(view, ContextCompat.getColor((Context)this.mActivity, (int)viewColorBeforeTransform), ContextCompat.getColor((Context)this.mActivity, (int)viewColorAfterTransform));
    }

    public ImmersionBar addViewSupportTransformColor(View view, String viewColorAfterTransform) {
        return this.addViewSupportTransformColorInt(view, Color.parseColor((String)viewColorAfterTransform));
    }

    public ImmersionBar addViewSupportTransformColor(View view, String viewColorBeforeTransform, String viewColorAfterTransform) {
        return this.addViewSupportTransformColorInt(view, Color.parseColor((String)viewColorBeforeTransform), Color.parseColor((String)viewColorAfterTransform));
    }

    public ImmersionBar addViewSupportTransformColorInt(View view, @ColorInt int viewColorAfterTransform) {
        if (view == null) {
            throw new IllegalArgumentException("View\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(this.mBarParams.statusBarColor, viewColorAfterTransform);
        this.mBarParams.viewMap.put(view, map);
        return this;
    }

    public ImmersionBar addViewSupportTransformColorInt(View view, @ColorInt int viewColorBeforeTransform, @ColorInt int viewColorAfterTransform) {
        if (view == null) {
            throw new IllegalArgumentException("View\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(viewColorBeforeTransform, viewColorAfterTransform);
        this.mBarParams.viewMap.put(view, map);
        return this;
    }

    public ImmersionBar viewAlpha(@FloatRange(from=0.0, to=1.0) float viewAlpha) {
        this.mBarParams.viewAlpha = viewAlpha;
        return this;
    }

    public ImmersionBar removeSupportView(View view) {
        if (view == null) {
            throw new IllegalArgumentException("View\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<Integer, Integer> map = this.mBarParams.viewMap.get(view);
        if (map != null && map.size() != 0) {
            this.mBarParams.viewMap.remove(view);
        }
        return this;
    }

    public ImmersionBar removeSupportAllView() {
        if (this.mBarParams.viewMap.size() != 0) {
            this.mBarParams.viewMap.clear();
        }
        return this;
    }

    public ImmersionBar fullScreen(boolean isFullScreen) {
        this.mBarParams.fullScreen = isFullScreen;
        return this;
    }

    public ImmersionBar statusBarAlpha(@FloatRange(from=0.0, to=1.0) float statusAlpha) {
        this.mBarParams.statusBarAlpha = statusAlpha;
        return this;
    }

    public ImmersionBar navigationBarAlpha(@FloatRange(from=0.0, to=1.0) float navigationAlpha) {
        this.mBarParams.navigationBarAlpha = navigationAlpha;
        return this;
    }

    public ImmersionBar barAlpha(@FloatRange(from=0.0, to=1.0) float barAlpha) {
        this.mBarParams.statusBarAlpha = barAlpha;
        this.mBarParams.navigationBarAlpha = barAlpha;
        return this;
    }

    public ImmersionBar autoDarkModeEnable(boolean isEnable) {
        return this.autoDarkModeEnable(isEnable, 0.0f);
    }

    public ImmersionBar autoDarkModeEnable(boolean isEnable, @FloatRange(from=0.0, to=1.0) float autoDarkModeAlpha) {
        this.mBarParams.autoStatusBarDarkModeEnable = isEnable;
        this.mBarParams.autoStatusBarDarkModeAlpha = autoDarkModeAlpha;
        this.mBarParams.autoNavigationBarDarkModeEnable = isEnable;
        this.mBarParams.autoNavigationBarDarkModeAlpha = autoDarkModeAlpha;
        return this;
    }

    public ImmersionBar autoStatusBarDarkModeEnable(boolean isEnable) {
        return this.autoStatusBarDarkModeEnable(isEnable, 0.0f);
    }

    public ImmersionBar autoStatusBarDarkModeEnable(boolean isEnable, @FloatRange(from=0.0, to=1.0) float autoDarkModeAlpha) {
        this.mBarParams.autoStatusBarDarkModeEnable = isEnable;
        this.mBarParams.autoStatusBarDarkModeAlpha = autoDarkModeAlpha;
        return this;
    }

    public ImmersionBar autoNavigationBarDarkModeEnable(boolean isEnable) {
        return this.autoNavigationBarDarkModeEnable(isEnable, 0.0f);
    }

    public ImmersionBar autoNavigationBarDarkModeEnable(boolean isEnable, @FloatRange(from=0.0, to=1.0) float autoDarkModeAlpha) {
        this.mBarParams.autoNavigationBarDarkModeEnable = isEnable;
        this.mBarParams.autoNavigationBarDarkModeAlpha = autoDarkModeAlpha;
        return this;
    }

    public ImmersionBar statusBarDarkFont(boolean isDarkFont) {
        return this.statusBarDarkFont(isDarkFont, 0.0f);
    }

    public ImmersionBar statusBarDarkFont(boolean isDarkFont, @FloatRange(from=0.0, to=1.0) float statusAlpha) {
        this.mBarParams.statusBarDarkFont = isDarkFont;
        if (isDarkFont && !ImmersionBar.isSupportStatusBarDarkFont()) {
            this.mBarParams.statusBarAlpha = statusAlpha;
        } else {
            this.mBarParams.flymeOSStatusBarFontColor = 0;
            this.mBarParams.statusBarAlpha = 0.0f;
        }
        return this;
    }

    public ImmersionBar navigationBarDarkIcon(boolean isDarkIcon) {
        return this.navigationBarDarkIcon(isDarkIcon, 0.0f);
    }

    public ImmersionBar navigationBarDarkIcon(boolean isDarkIcon, @FloatRange(from=0.0, to=1.0) float navigationAlpha) {
        this.mBarParams.navigationBarDarkIcon = isDarkIcon;
        this.mBarParams.navigationBarAlpha = isDarkIcon && !ImmersionBar.isSupportNavigationIconDark() ? navigationAlpha : 0.0f;
        return this;
    }

    public ImmersionBar flymeOSStatusBarFontColor(@ColorRes int flymeOSStatusBarFontColor) {
        this.mBarParams.flymeOSStatusBarFontColor = ContextCompat.getColor((Context)this.mActivity, (int)flymeOSStatusBarFontColor);
        return this;
    }

    public ImmersionBar flymeOSStatusBarFontColor(String flymeOSStatusBarFontColor) {
        this.mBarParams.flymeOSStatusBarFontColor = Color.parseColor((String)flymeOSStatusBarFontColor);
        return this;
    }

    public ImmersionBar flymeOSStatusBarFontColorInt(@ColorInt int flymeOSStatusBarFontColor) {
        this.mBarParams.flymeOSStatusBarFontColor = flymeOSStatusBarFontColor;
        return this;
    }

    public ImmersionBar hideBar(BarHide barHide) {
        this.mBarParams.barHide = barHide;
        if (Build.VERSION.SDK_INT == 19 || OSUtils.isEMUI3_x()) {
            this.mBarParams.hideNavigationBar = this.mBarParams.barHide == BarHide.FLAG_HIDE_NAVIGATION_BAR || this.mBarParams.barHide == BarHide.FLAG_HIDE_BAR;
        }
        return this;
    }

    public ImmersionBar fitsSystemWindows(boolean fits) {
        this.mBarParams.fits = fits;
        if (this.mBarParams.fits) {
            if (this.mFitsStatusBarType == 0) {
                this.mFitsStatusBarType = 4;
            }
        } else {
            this.mFitsStatusBarType = 0;
        }
        return this;
    }

    public ImmersionBar fitsSystemWindows(boolean fits, @ColorRes int contentColor) {
        return this.fitsSystemWindowsInt(fits, ContextCompat.getColor((Context)this.mActivity, (int)contentColor));
    }

    public ImmersionBar fitsSystemWindows(boolean fits, @ColorRes int contentColor, @ColorRes int contentColorTransform, @FloatRange(from=0.0, to=1.0) float contentAlpha) {
        return this.fitsSystemWindowsInt(fits, ContextCompat.getColor((Context)this.mActivity, (int)contentColor), ContextCompat.getColor((Context)this.mActivity, (int)contentColorTransform), contentAlpha);
    }

    public ImmersionBar fitsSystemWindowsInt(boolean fits, @ColorInt int contentColor) {
        return this.fitsSystemWindowsInt(fits, contentColor, -16777216, 0.0f);
    }

    public ImmersionBar fitsSystemWindowsInt(boolean fits, @ColorInt int contentColor, @ColorInt int contentColorTransform, @FloatRange(from=0.0, to=1.0) float contentAlpha) {
        this.mBarParams.fits = fits;
        this.mBarParams.contentColor = contentColor;
        this.mBarParams.contentColorTransform = contentColorTransform;
        this.mBarParams.contentAlpha = contentAlpha;
        if (this.mBarParams.fits) {
            if (this.mFitsStatusBarType == 0) {
                this.mFitsStatusBarType = 4;
            }
        } else {
            this.mFitsStatusBarType = 0;
        }
        this.mContentView.setBackgroundColor(ColorUtils.blendARGB((int)this.mBarParams.contentColor, (int)this.mBarParams.contentColorTransform, (float)this.mBarParams.contentAlpha));
        return this;
    }

    public ImmersionBar statusBarView(View view) {
        if (view == null) {
            return this;
        }
        this.mBarParams.statusBarView = view;
        if (this.mFitsStatusBarType == 0) {
            this.mFitsStatusBarType = 3;
        }
        return this;
    }

    public ImmersionBar statusBarView(@IdRes int viewId) {
        return this.statusBarView(this.mActivity.findViewById(viewId));
    }

    public ImmersionBar statusBarView(@IdRes int viewId, View rootView) {
        return this.statusBarView(rootView.findViewById(viewId));
    }

    public ImmersionBar titleBar(View view) {
        if (view == null) {
            return this;
        }
        return this.titleBar(view, true);
    }

    public ImmersionBar titleBar(View view, boolean statusBarColorTransformEnable) {
        if (view == null) {
            return this;
        }
        if (this.mFitsStatusBarType == 0) {
            this.mFitsStatusBarType = 1;
        }
        this.mBarParams.titleBarView = view;
        this.mBarParams.statusBarColorEnabled = statusBarColorTransformEnable;
        return this;
    }

    public ImmersionBar titleBar(@IdRes int viewId) {
        return this.titleBar(viewId, true);
    }

    public ImmersionBar titleBar(@IdRes int viewId, boolean statusBarColorTransformEnable) {
        if (this.mSupportFragment != null && this.mSupportFragment.getView() != null) {
            return this.titleBar(this.mSupportFragment.getView().findViewById(viewId), statusBarColorTransformEnable);
        }
        if (this.mFragment != null && this.mFragment.getView() != null) {
            return this.titleBar(this.mFragment.getView().findViewById(viewId), statusBarColorTransformEnable);
        }
        return this.titleBar(this.mActivity.findViewById(viewId), statusBarColorTransformEnable);
    }

    public ImmersionBar titleBar(@IdRes int viewId, View rootView) {
        return this.titleBar(rootView.findViewById(viewId), true);
    }

    public ImmersionBar titleBar(@IdRes int viewId, View rootView, boolean statusBarColorTransformEnable) {
        return this.titleBar(rootView.findViewById(viewId), statusBarColorTransformEnable);
    }

    public ImmersionBar titleBarMarginTop(@IdRes int viewId) {
        if (this.mSupportFragment != null && this.mSupportFragment.getView() != null) {
            return this.titleBarMarginTop(this.mSupportFragment.getView().findViewById(viewId));
        }
        if (this.mFragment != null && this.mFragment.getView() != null) {
            return this.titleBarMarginTop(this.mFragment.getView().findViewById(viewId));
        }
        return this.titleBarMarginTop(this.mActivity.findViewById(viewId));
    }

    public ImmersionBar titleBarMarginTop(@IdRes int viewId, View rootView) {
        return this.titleBarMarginTop(rootView.findViewById(viewId));
    }

    public ImmersionBar titleBarMarginTop(View view) {
        if (view == null) {
            return this;
        }
        if (this.mFitsStatusBarType == 0) {
            this.mFitsStatusBarType = 2;
        }
        this.mBarParams.titleBarView = view;
        return this;
    }

    public ImmersionBar supportActionBar(boolean isSupportActionBar) {
        this.mBarParams.isSupportActionBar = isSupportActionBar;
        return this;
    }

    public ImmersionBar statusBarColorTransformEnable(boolean statusBarColorTransformEnable) {
        this.mBarParams.statusBarColorEnabled = statusBarColorTransformEnable;
        return this;
    }

    public ImmersionBar reset() {
        this.mBarParams = new BarParams();
        this.mFitsStatusBarType = 0;
        return this;
    }

    public ImmersionBar addTag(String tag) {
        if (ImmersionBar.isEmpty(tag)) {
            throw new IllegalArgumentException("tag\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BarParams barParams = this.mBarParams.clone();
        this.mTagMap.put(tag, barParams);
        return this;
    }

    public ImmersionBar getTag(String tag) {
        if (ImmersionBar.isEmpty(tag)) {
            throw new IllegalArgumentException("tag\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BarParams barParams = this.mTagMap.get(tag);
        if (barParams != null) {
            this.mBarParams = barParams.clone();
        }
        return this;
    }

    public ImmersionBar keyboardEnable(boolean enable) {
        return this.keyboardEnable(enable, this.mBarParams.keyboardMode);
    }

    public ImmersionBar keyboardEnable(boolean enable, int keyboardMode) {
        this.mBarParams.keyboardEnable = enable;
        this.mBarParams.keyboardMode = keyboardMode;
        this.mKeyboardTempEnable = enable;
        return this;
    }

    public ImmersionBar keyboardMode(int keyboardMode) {
        this.mBarParams.keyboardMode = keyboardMode;
        return this;
    }

    public ImmersionBar setOnKeyboardListener(@Nullable OnKeyboardListener onKeyboardListener) {
        if (this.mBarParams.onKeyboardListener == null) {
            this.mBarParams.onKeyboardListener = onKeyboardListener;
        }
        return this;
    }

    public ImmersionBar setOnNavigationBarListener(OnNavigationBarListener onNavigationBarListener) {
        if (onNavigationBarListener != null) {
            if (this.mBarParams.onNavigationBarListener == null) {
                this.mBarParams.onNavigationBarListener = onNavigationBarListener;
                NavigationBarObserver.getInstance().addOnNavigationBarListener(this.mBarParams.onNavigationBarListener);
            }
        } else if (this.mBarParams.onNavigationBarListener != null) {
            NavigationBarObserver.getInstance().removeOnNavigationBarListener(this.mBarParams.onNavigationBarListener);
            this.mBarParams.onNavigationBarListener = null;
        }
        return this;
    }

    public ImmersionBar setOnBarListener(OnBarListener onBarListener) {
        if (onBarListener != null) {
            if (this.mBarParams.onBarListener == null) {
                this.mBarParams.onBarListener = onBarListener;
            }
        } else if (this.mBarParams.onBarListener != null) {
            this.mBarParams.onBarListener = null;
        }
        return this;
    }

    public ImmersionBar navigationBarEnable(boolean navigationBarEnable) {
        this.mBarParams.navigationBarEnable = navigationBarEnable;
        return this;
    }

    public ImmersionBar navigationBarWithKitkatEnable(boolean navigationBarWithKitkatEnable) {
        this.mBarParams.navigationBarWithKitkatEnable = navigationBarWithKitkatEnable;
        if (OSUtils.isEMUI3_x()) {
            if (this.mBarParams.navigationBarWithEMUI3Enable) {
                this.mBarParams.navigationBarWithKitkatEnable = true;
            } else if (this.mBarParams.navigationBarWithKitkatEnable) {
                this.mBarParams.navigationBarWithKitkatEnable = false;
            }
        }
        return this;
    }

    public ImmersionBar navigationBarWithEMUI3Enable(boolean navigationBarWithEMUI3Enable) {
        if (OSUtils.isEMUI3_x()) {
            this.mBarParams.navigationBarWithEMUI3Enable = navigationBarWithEMUI3Enable;
            this.mBarParams.navigationBarWithKitkatEnable = navigationBarWithEMUI3Enable;
        }
        return this;
    }

    public ImmersionBar barEnable(boolean barEnable) {
        this.mBarParams.barEnable = barEnable;
        return this;
    }

    public void init() {
        if (this.mBarParams.barEnable) {
            this.updateBarParams();
            this.setBar();
            this.fitsWindows();
            this.fitsKeyboard();
            this.transformView();
            this.mInitialized = true;
        }
    }

    void destroy() {
        ImmersionBar immersionBar;
        this.cancelListener();
        if (this.mIsDialog && (immersionBar = ImmersionBar.with(this.mActivity)) != null) {
            immersionBar.mBarParams.keyboardEnable = immersionBar.mKeyboardTempEnable;
            if (immersionBar.mBarParams.barHide != BarHide.FLAG_SHOW_BAR) {
                immersionBar.setBar();
            }
        }
        this.mInitialized = false;
    }

    private void updateBarParams() {
        this.adjustDarkModeParams();
        if (Build.VERSION.SDK_INT >= 19) {
            ImmersionBar immersionBar;
            this.updateBarConfig();
            if (this.mIsFragment && (immersionBar = ImmersionBar.with(this.mActivity)) != null) {
                immersionBar.mBarParams = this.mBarParams;
            }
            if (this.mIsDialog && (immersionBar = ImmersionBar.with(this.mActivity)) != null && immersionBar.mKeyboardTempEnable) {
                immersionBar.mBarParams.keyboardEnable = false;
            }
        }
    }

    void setBar() {
        if (Build.VERSION.SDK_INT >= 19) {
            int uiFlags = 256;
            if (Build.VERSION.SDK_INT >= 21 && !OSUtils.isEMUI3_x()) {
                this.fitsNotchScreen();
                uiFlags = this.initBarAboveLOLLIPOP(uiFlags);
                uiFlags = this.setStatusBarDarkFont(uiFlags);
                uiFlags = this.setNavigationIconDark(uiFlags);
            } else {
                this.initBarBelowLOLLIPOP();
            }
            uiFlags = this.hideBar(uiFlags);
            this.mDecorView.setSystemUiVisibility(uiFlags);
        }
        if (OSUtils.isMIUI6Later()) {
            this.setMIUIBarDark(this.mWindow, "EXTRA_FLAG_STATUS_BAR_DARK_MODE", this.mBarParams.statusBarDarkFont);
            if (this.mBarParams.navigationBarEnable) {
                this.setMIUIBarDark(this.mWindow, "EXTRA_FLAG_NAVIGATION_BAR_DARK_MODE", this.mBarParams.navigationBarDarkIcon);
            }
        }
        if (OSUtils.isFlymeOS4Later()) {
            if (this.mBarParams.flymeOSStatusBarFontColor != 0) {
                FlymeOSStatusBarFontUtils.setStatusBarDarkIcon(this.mActivity, this.mBarParams.flymeOSStatusBarFontColor);
            } else {
                FlymeOSStatusBarFontUtils.setStatusBarDarkIcon(this.mActivity, this.mBarParams.statusBarDarkFont);
            }
        }
        if (this.mBarParams.onNavigationBarListener != null) {
            NavigationBarObserver.getInstance().register(this.mActivity.getApplication());
        }
    }

    private void fitsNotchScreen() {
        if (Build.VERSION.SDK_INT >= 28 && !this.initialized()) {
            WindowManager.LayoutParams lp = this.mWindow.getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            this.mWindow.setAttributes(lp);
        }
    }

    @RequiresApi(api=21)
    private int initBarAboveLOLLIPOP(int uiFlags) {
        if (!this.initialized()) {
            this.mBarParams.defaultNavigationBarColor = this.mWindow.getNavigationBarColor();
        }
        uiFlags |= 0x400;
        if (this.mBarParams.fullScreen && this.mBarParams.navigationBarEnable) {
            uiFlags |= 0x200;
        }
        this.mWindow.clearFlags(0x4000000);
        if (this.mBarConfig.hasNavigationBar()) {
            this.mWindow.clearFlags(0x8000000);
        }
        this.mWindow.addFlags(Integer.MIN_VALUE);
        if (this.mBarParams.statusBarColorEnabled) {
            this.mWindow.setStatusBarColor(ColorUtils.blendARGB((int)this.mBarParams.statusBarColor, (int)this.mBarParams.statusBarColorTransform, (float)this.mBarParams.statusBarAlpha));
        } else {
            this.mWindow.setStatusBarColor(ColorUtils.blendARGB((int)this.mBarParams.statusBarColor, (int)0, (float)this.mBarParams.statusBarAlpha));
        }
        if (this.mBarParams.navigationBarEnable) {
            this.mWindow.setNavigationBarColor(ColorUtils.blendARGB((int)this.mBarParams.navigationBarColor, (int)this.mBarParams.navigationBarColorTransform, (float)this.mBarParams.navigationBarAlpha));
        } else {
            this.mWindow.setNavigationBarColor(this.mBarParams.defaultNavigationBarColor);
        }
        return uiFlags;
    }

    private void initBarBelowLOLLIPOP() {
        this.mWindow.addFlags(0x4000000);
        this.setupStatusBarView();
        if (this.mBarConfig.hasNavigationBar() || OSUtils.isEMUI3_x()) {
            if (this.mBarParams.navigationBarEnable && this.mBarParams.navigationBarWithKitkatEnable) {
                this.mWindow.addFlags(0x8000000);
            } else {
                this.mWindow.clearFlags(0x8000000);
            }
            if (this.mNavigationBarHeight == 0) {
                this.mNavigationBarHeight = this.mBarConfig.getNavigationBarHeight();
            }
            if (this.mNavigationBarWidth == 0) {
                this.mNavigationBarWidth = this.mBarConfig.getNavigationBarWidth();
            }
            this.setupNavBarView();
        }
    }

    private void setupStatusBarView() {
        View statusBarView = this.mDecorView.findViewById(Constants.IMMERSION_ID_STATUS_BAR_VIEW);
        if (statusBarView == null) {
            statusBarView = new View((Context)this.mActivity);
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, this.mBarConfig.getStatusBarHeight());
            params.gravity = 48;
            statusBarView.setLayoutParams((ViewGroup.LayoutParams)params);
            statusBarView.setVisibility(0);
            statusBarView.setId(Constants.IMMERSION_ID_STATUS_BAR_VIEW);
            this.mDecorView.addView(statusBarView);
        }
        if (this.mBarParams.statusBarColorEnabled) {
            statusBarView.setBackgroundColor(ColorUtils.blendARGB((int)this.mBarParams.statusBarColor, (int)this.mBarParams.statusBarColorTransform, (float)this.mBarParams.statusBarAlpha));
        } else {
            statusBarView.setBackgroundColor(ColorUtils.blendARGB((int)this.mBarParams.statusBarColor, (int)0, (float)this.mBarParams.statusBarAlpha));
        }
    }

    private void setupNavBarView() {
        FrameLayout.LayoutParams params;
        View navigationBarView = this.mDecorView.findViewById(Constants.IMMERSION_ID_NAVIGATION_BAR_VIEW);
        if (navigationBarView == null) {
            navigationBarView = new View((Context)this.mActivity);
            navigationBarView.setId(Constants.IMMERSION_ID_NAVIGATION_BAR_VIEW);
            this.mDecorView.addView(navigationBarView);
        }
        if (this.mBarConfig.isNavigationAtBottom()) {
            params = new FrameLayout.LayoutParams(-1, this.mBarConfig.getNavigationBarHeight());
            params.gravity = 80;
        } else {
            params = new FrameLayout.LayoutParams(this.mBarConfig.getNavigationBarWidth(), -1);
            params.gravity = 0x800005;
        }
        navigationBarView.setLayoutParams((ViewGroup.LayoutParams)params);
        navigationBarView.setBackgroundColor(ColorUtils.blendARGB((int)this.mBarParams.navigationBarColor, (int)this.mBarParams.navigationBarColorTransform, (float)this.mBarParams.navigationBarAlpha));
        if (this.mBarParams.navigationBarEnable && this.mBarParams.navigationBarWithKitkatEnable && !this.mBarParams.hideNavigationBar) {
            navigationBarView.setVisibility(0);
        } else {
            navigationBarView.setVisibility(8);
        }
    }

    private void adjustDarkModeParams() {
        if (this.mBarParams.autoStatusBarDarkModeEnable && this.mBarParams.statusBarColor != 0) {
            boolean statusBarDarkFont = this.mBarParams.statusBarColor > -4539718;
            this.statusBarDarkFont(statusBarDarkFont, this.mBarParams.autoStatusBarDarkModeAlpha);
        }
        if (this.mBarParams.autoNavigationBarDarkModeEnable && this.mBarParams.navigationBarColor != 0) {
            boolean navigationBarDarkIcon = this.mBarParams.navigationBarColor > -4539718;
            this.navigationBarDarkIcon(navigationBarDarkIcon, this.mBarParams.autoNavigationBarDarkModeAlpha);
        }
    }

    private int hideBar(int uiFlags) {
        if (Build.VERSION.SDK_INT >= 16) {
            switch (this.mBarParams.barHide) {
                case FLAG_HIDE_BAR: {
                    uiFlags |= 0x206;
                    break;
                }
                case FLAG_HIDE_STATUS_BAR: {
                    uiFlags |= 0x404;
                    break;
                }
                case FLAG_HIDE_NAVIGATION_BAR: {
                    uiFlags |= 0x202;
                    break;
                }
                case FLAG_SHOW_BAR: {
                    uiFlags |= 0;
                    break;
                }
            }
        }
        return uiFlags | 0x1000;
    }

    void fitsWindows() {
        if (Build.VERSION.SDK_INT >= 19) {
            if (Build.VERSION.SDK_INT >= 21 && !OSUtils.isEMUI3_x()) {
                this.fitsWindowsAboveLOLLIPOP();
            } else {
                this.fitsWindowsBelowLOLLIPOP();
            }
            this.fitsLayoutOverlap();
        }
    }

    private void fitsWindowsBelowLOLLIPOP() {
        if (this.mBarParams.isSupportActionBar) {
            this.mIsActionBarBelowLOLLIPOP = true;
            this.mContentView.post((Runnable)this);
        } else {
            this.mIsActionBarBelowLOLLIPOP = false;
            this.postFitsWindowsBelowLOLLIPOP();
        }
    }

    @Override
    public void run() {
        this.postFitsWindowsBelowLOLLIPOP();
    }

    private void postFitsWindowsBelowLOLLIPOP() {
        this.updateBarConfig();
        this.fitsWindowsKITKAT();
        if (!this.mIsFragment && OSUtils.isEMUI3_x()) {
            this.fitsWindowsEMUI();
        }
    }

    private void fitsWindowsAboveLOLLIPOP() {
        this.updateBarConfig();
        if (ImmersionBar.checkFitsSystemWindows(this.mDecorView.findViewById(0x1020002))) {
            if (this.mBarParams.isSupportActionBar) {
                this.setPadding(0, this.mActionBarHeight, 0, 0);
            }
            return;
        }
        int top = 0;
        if (this.mBarParams.fits && this.mFitsStatusBarType == 4) {
            top = this.mBarConfig.getStatusBarHeight();
        }
        if (this.mBarParams.isSupportActionBar) {
            top = this.mBarConfig.getStatusBarHeight() + this.mActionBarHeight;
        }
        this.setPadding(0, top, 0, 0);
    }

    private void fitsWindowsKITKAT() {
        if (ImmersionBar.checkFitsSystemWindows(this.mDecorView.findViewById(0x1020002))) {
            if (this.mBarParams.isSupportActionBar) {
                this.setPadding(0, this.mActionBarHeight, 0, 0);
            }
            return;
        }
        int top = 0;
        int right = 0;
        int bottom = 0;
        if (this.mBarParams.fits && this.mFitsStatusBarType == 4) {
            top = this.mBarConfig.getStatusBarHeight();
        }
        if (this.mBarParams.isSupportActionBar) {
            top = this.mBarConfig.getStatusBarHeight() + this.mActionBarHeight;
        }
        if (this.mBarConfig.hasNavigationBar() && this.mBarParams.navigationBarEnable && this.mBarParams.navigationBarWithKitkatEnable) {
            if (!this.mBarParams.fullScreen) {
                if (this.mBarConfig.isNavigationAtBottom()) {
                    bottom = this.mBarConfig.getNavigationBarHeight();
                } else {
                    right = this.mBarConfig.getNavigationBarWidth();
                }
            }
            if (this.mBarParams.hideNavigationBar) {
                if (this.mBarConfig.isNavigationAtBottom()) {
                    bottom = 0;
                } else {
                    right = 0;
                }
            } else if (!this.mBarConfig.isNavigationAtBottom()) {
                right = this.mBarConfig.getNavigationBarWidth();
            }
        }
        this.setPadding(0, top, right, bottom);
    }

    private void fitsWindowsEMUI() {
        View navigationBarView = this.mDecorView.findViewById(Constants.IMMERSION_ID_NAVIGATION_BAR_VIEW);
        if (this.mBarParams.navigationBarEnable && this.mBarParams.navigationBarWithKitkatEnable) {
            if (navigationBarView != null) {
                EMUI3NavigationBarObserver.getInstance().addOnNavigationBarListener(this);
                EMUI3NavigationBarObserver.getInstance().register(this.mActivity.getApplication());
            }
        } else {
            EMUI3NavigationBarObserver.getInstance().removeOnNavigationBarListener(this);
            navigationBarView.setVisibility(8);
        }
    }

    private void updateBarConfig() {
        this.mBarConfig = new BarConfig(this.mActivity);
        if (!this.initialized() || this.mIsActionBarBelowLOLLIPOP) {
            this.mActionBarHeight = this.mBarConfig.getActionBarHeight();
        }
        if (this.mFitsKeyboard != null) {
            this.mFitsKeyboard.updateBarConfig(this.mBarConfig);
        }
    }

    @Override
    public void onNavigationBarChange(boolean show) {
        View navigationBarView = this.mDecorView.findViewById(Constants.IMMERSION_ID_NAVIGATION_BAR_VIEW);
        if (navigationBarView != null) {
            this.mBarConfig = new BarConfig(this.mActivity);
            int bottom = this.mContentView.getPaddingBottom();
            int right = this.mContentView.getPaddingRight();
            if (!show) {
                navigationBarView.setVisibility(8);
                bottom = 0;
                right = 0;
            } else {
                navigationBarView.setVisibility(0);
                if (ImmersionBar.checkFitsSystemWindows(this.mDecorView.findViewById(0x1020002))) {
                    bottom = 0;
                    right = 0;
                } else {
                    if (this.mNavigationBarHeight == 0) {
                        this.mNavigationBarHeight = this.mBarConfig.getNavigationBarHeight();
                    }
                    if (this.mNavigationBarWidth == 0) {
                        this.mNavigationBarWidth = this.mBarConfig.getNavigationBarWidth();
                    }
                    if (!this.mBarParams.hideNavigationBar) {
                        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)navigationBarView.getLayoutParams();
                        if (this.mBarConfig.isNavigationAtBottom()) {
                            params.gravity = 80;
                            params.height = this.mNavigationBarHeight;
                            bottom = !this.mBarParams.fullScreen ? this.mNavigationBarHeight : 0;
                            right = 0;
                        } else {
                            params.gravity = 0x800005;
                            params.width = this.mNavigationBarWidth;
                            bottom = 0;
                            right = !this.mBarParams.fullScreen ? this.mNavigationBarWidth : 0;
                        }
                        navigationBarView.setLayoutParams((ViewGroup.LayoutParams)params);
                    }
                }
            }
            this.setPadding(0, this.mContentView.getPaddingTop(), right, bottom);
        }
    }

    private int setStatusBarDarkFont(int uiFlags) {
        if (Build.VERSION.SDK_INT >= 23 && this.mBarParams.statusBarDarkFont) {
            return uiFlags | 0x2000;
        }
        return uiFlags;
    }

    private int setNavigationIconDark(int uiFlags) {
        if (Build.VERSION.SDK_INT >= 26 && this.mBarParams.navigationBarDarkIcon) {
            return uiFlags | 0x10;
        }
        return uiFlags;
    }

    @SuppressLint(value={"PrivateApi"})
    private void setMIUIBarDark(Window window, String key, boolean dark) {
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField(key);
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (dark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void fitsLayoutOverlap() {
        switch (this.mFitsStatusBarType) {
            case 1: {
                ImmersionBar.setTitleBar(this.mActivity, this.mBarParams.titleBarView);
                break;
            }
            case 2: {
                ImmersionBar.setTitleBarMarginTop(this.mActivity, this.mBarParams.titleBarView);
                break;
            }
            case 3: {
                ImmersionBar.setStatusBarView(this.mActivity, this.mBarParams.statusBarView);
                break;
            }
        }
    }

    private void transformView() {
        if (this.mBarParams.viewMap.size() != 0) {
            Set<Map.Entry<View, Map<Integer, Integer>>> entrySet = this.mBarParams.viewMap.entrySet();
            for (Map.Entry<View, Map<Integer, Integer>> entry : entrySet) {
                View view = entry.getKey();
                Map<Integer, Integer> map = entry.getValue();
                Integer colorBefore = this.mBarParams.statusBarColor;
                Integer colorAfter = this.mBarParams.statusBarColorTransform;
                for (Map.Entry<Integer, Integer> integerEntry : map.entrySet()) {
                    colorBefore = integerEntry.getKey();
                    colorAfter = integerEntry.getValue();
                }
                if (view == null) continue;
                if (Math.abs(this.mBarParams.viewAlpha - 0.0f) == 0.0f) {
                    view.setBackgroundColor(ColorUtils.blendARGB((int)colorBefore, (int)colorAfter, (float)this.mBarParams.statusBarAlpha));
                    continue;
                }
                view.setBackgroundColor(ColorUtils.blendARGB((int)colorBefore, (int)colorAfter, (float)this.mBarParams.viewAlpha));
            }
        }
    }

    private void cancelListener() {
        if (this.mActivity != null) {
            if (this.mFitsKeyboard != null) {
                this.mFitsKeyboard.cancel();
                this.mFitsKeyboard = null;
            }
            EMUI3NavigationBarObserver.getInstance().removeOnNavigationBarListener(this);
            NavigationBarObserver.getInstance().removeOnNavigationBarListener(this.mBarParams.onNavigationBarListener);
        }
    }

    private void fitsKeyboard() {
        if (Build.VERSION.SDK_INT >= 19) {
            if (!this.mIsFragment) {
                if (this.mBarParams.keyboardEnable) {
                    if (this.mFitsKeyboard == null) {
                        this.mFitsKeyboard = new FitsKeyboard(this, this.mActivity, this.mWindow);
                    }
                    this.mFitsKeyboard.enable(this.mBarParams.keyboardMode);
                } else if (this.mFitsKeyboard != null) {
                    this.mFitsKeyboard.disable();
                }
            } else {
                ImmersionBar immersionBar = ImmersionBar.with(this.mActivity);
                if (immersionBar != null) {
                    if (immersionBar.mBarParams.keyboardEnable) {
                        if (immersionBar.mFitsKeyboard == null) {
                            immersionBar.mFitsKeyboard = new FitsKeyboard(immersionBar, immersionBar.mActivity, immersionBar.mWindow);
                        }
                        immersionBar.mFitsKeyboard.enable(immersionBar.mBarParams.keyboardMode);
                    } else if (immersionBar.mFitsKeyboard != null) {
                        immersionBar.mFitsKeyboard.disable();
                    }
                }
            }
        }
    }

    boolean isFragment() {
        return this.mIsFragment;
    }

    boolean initialized() {
        return this.mInitialized;
    }

    boolean isActionBarBelowLOLLIPOP() {
        return this.mIsActionBarBelowLOLLIPOP;
    }

    public BarParams getBarParams() {
        return this.mBarParams;
    }

    private void setPadding(int left, int top, int right, int bottom) {
        if (this.mContentView != null) {
            this.mContentView.setPadding(left, top, right, bottom);
        }
        this.mPaddingLeft = left;
        this.mPaddingTop = top;
        this.mPaddingRight = right;
        this.mPaddingBottom = bottom;
    }

    int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    int getPaddingTop() {
        return this.mPaddingTop;
    }

    int getPaddingRight() {
        return this.mPaddingRight;
    }

    int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    Activity getActivity() {
        return this.mActivity;
    }

    public static boolean isSupportStatusBarDarkFont() {
        return OSUtils.isMIUI6Later() || OSUtils.isFlymeOS4Later() || Build.VERSION.SDK_INT >= 23;
    }

    public static boolean isSupportNavigationIconDark() {
        return OSUtils.isMIUI6Later() || Build.VERSION.SDK_INT >= 26;
    }

    public static synchronized void setTitleBar(Activity activity, View ... view) {
        if (activity == null) {
            return;
        }
        for (final View v : view) {
            if (v == null || Build.VERSION.SDK_INT < 19) continue;
            final int statusBarHeight = ImmersionBar.getStatusBarHeight(activity);
            Integer fitsHeight = (Integer)v.getTag(R.id.mn_ib_fits_layout_overlap);
            if (fitsHeight == null) {
                fitsHeight = 0;
            }
            if (fitsHeight == statusBarHeight) continue;
            v.setTag(R.id.mn_ib_fits_layout_overlap, (Object)statusBarHeight);
            ViewGroup.LayoutParams layoutParams = v.getLayoutParams();
            if (layoutParams == null) {
                layoutParams = new ViewGroup.LayoutParams(-1, -2);
            }
            if (layoutParams.height == -2 || layoutParams.height == -1) {
                final ViewGroup.LayoutParams finalLayoutParams = layoutParams;
                final Integer finalFitsHeight = fitsHeight;
                v.post(new Runnable(){

                    @Override
                    public void run() {
                        finalLayoutParams.height = v.getHeight() + statusBarHeight - finalFitsHeight;
                        v.setPadding(v.getPaddingLeft(), v.getPaddingTop() + statusBarHeight - finalFitsHeight, v.getPaddingRight(), v.getPaddingBottom());
                        v.setLayoutParams(finalLayoutParams);
                    }
                });
                continue;
            }
            layoutParams.height += statusBarHeight - fitsHeight;
            v.setPadding(v.getPaddingLeft(), v.getPaddingTop() + statusBarHeight - fitsHeight, v.getPaddingRight(), v.getPaddingBottom());
            v.setLayoutParams(layoutParams);
        }
    }

    public static void setTitleBar(androidx.fragment.app.Fragment fragment, View ... view) {
        if (fragment == null) {
            return;
        }
        ImmersionBar.setTitleBar((Activity)fragment.getActivity(), view);
    }

    public static void setTitleBar(Fragment fragment, View ... view) {
        if (fragment == null) {
            return;
        }
        ImmersionBar.setTitleBar(fragment.getActivity(), view);
    }

    public static void setTitleBarMarginTop(Activity activity, View ... view) {
        if (activity == null) {
            return;
        }
        for (View v : view) {
            if (v == null || Build.VERSION.SDK_INT < 19) continue;
            int statusBarHeight = ImmersionBar.getStatusBarHeight(activity);
            Integer fitsHeight = (Integer)v.getTag(R.id.mn_ib_fits_layout_overlap);
            if (fitsHeight == null) {
                fitsHeight = 0;
            }
            if (fitsHeight == statusBarHeight) continue;
            v.setTag(R.id.mn_ib_fits_layout_overlap, (Object)statusBarHeight);
            ViewGroup.LayoutParams lp = v.getLayoutParams();
            if (lp == null) {
                lp = new ViewGroup.MarginLayoutParams(-1, -2);
            }
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)lp;
            layoutParams.setMargins(layoutParams.leftMargin, layoutParams.topMargin + statusBarHeight - fitsHeight, layoutParams.rightMargin, layoutParams.bottomMargin);
            v.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    public static void setTitleBarMarginTop(androidx.fragment.app.Fragment fragment, View ... view) {
        if (fragment == null) {
            return;
        }
        ImmersionBar.setTitleBarMarginTop((Activity)fragment.getActivity(), view);
    }

    public static void setTitleBarMarginTop(Fragment fragment, View ... view) {
        if (fragment == null) {
            return;
        }
        ImmersionBar.setTitleBarMarginTop(fragment.getActivity(), view);
    }

    public static void setStatusBarView(Activity activity, View view) {
        if (activity == null) {
            return;
        }
        if (view == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            int statusBarHeight = ImmersionBar.getStatusBarHeight(activity);
            Integer fitsHeight = (Integer)view.getTag(R.id.mn_ib_fits_layout_overlap);
            if (fitsHeight == null) {
                fitsHeight = 0;
            }
            if (fitsHeight != statusBarHeight) {
                view.setTag(R.id.mn_ib_fits_layout_overlap, (Object)statusBarHeight);
                ViewGroup.LayoutParams lp = view.getLayoutParams();
                if (lp == null) {
                    lp = new ViewGroup.LayoutParams(-1, 0);
                }
                lp.height = statusBarHeight;
                view.setLayoutParams(lp);
            }
        }
    }

    public static void setStatusBarView(androidx.fragment.app.Fragment fragment, View view) {
        if (fragment == null) {
            return;
        }
        ImmersionBar.setStatusBarView((Activity)fragment.getActivity(), view);
    }

    public static void setStatusBarView(Fragment fragment, View view) {
        if (fragment == null) {
            return;
        }
        ImmersionBar.setStatusBarView(fragment.getActivity(), view);
    }

    public static void setFitsSystemWindows(Activity activity) {
        if (activity == null) {
            return;
        }
        ViewGroup parent = (ViewGroup)activity.findViewById(0x1020002);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View childView = parent.getChildAt(i);
            if (!(childView instanceof ViewGroup) || childView instanceof DrawerLayout) continue;
            childView.setFitsSystemWindows(true);
            ((ViewGroup)childView).setClipToPadding(true);
        }
    }

    public static void setFitsSystemWindows(androidx.fragment.app.Fragment fragment) {
        if (fragment == null) {
            return;
        }
        ImmersionBar.setFitsSystemWindows((Activity)fragment.getActivity());
    }

    public static void setFitsSystemWindows(Fragment fragment) {
        if (fragment == null) {
            return;
        }
        ImmersionBar.setFitsSystemWindows(fragment.getActivity());
    }

    public static boolean checkFitsSystemWindows(View view) {
        if (view == null) {
            return false;
        }
        if (view.getFitsSystemWindows()) {
            return true;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int count = viewGroup.getChildCount();
            for (int i = 0; i < count; ++i) {
                View childView = viewGroup.getChildAt(i);
                if (childView instanceof DrawerLayout && ImmersionBar.checkFitsSystemWindows(childView)) {
                    return true;
                }
                if (!childView.getFitsSystemWindows()) continue;
                return true;
            }
        }
        return false;
    }

    @TargetApi(value=14)
    public static boolean hasNavigationBar(@NonNull Activity activity) {
        BarConfig config = new BarConfig(activity);
        return config.hasNavigationBar();
    }

    @TargetApi(value=14)
    public static boolean hasNavigationBar(@NonNull androidx.fragment.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            return false;
        }
        return ImmersionBar.hasNavigationBar((Activity)fragment.getActivity());
    }

    @TargetApi(value=14)
    public static boolean hasNavigationBar(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            return false;
        }
        return ImmersionBar.hasNavigationBar(fragment.getActivity());
    }

    @TargetApi(value=14)
    public static int getNavigationBarHeight(@NonNull Activity activity) {
        BarConfig config = new BarConfig(activity);
        return config.getNavigationBarHeight();
    }

    @TargetApi(value=14)
    public static int getNavigationBarHeight(@NonNull androidx.fragment.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getNavigationBarHeight((Activity)fragment.getActivity());
    }

    @TargetApi(value=14)
    public static int getNavigationBarHeight(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getNavigationBarHeight(fragment.getActivity());
    }

    @TargetApi(value=14)
    public static int getNavigationBarWidth(@NonNull Activity activity) {
        BarConfig config = new BarConfig(activity);
        return config.getNavigationBarWidth();
    }

    @TargetApi(value=14)
    public static int getNavigationBarWidth(@NonNull androidx.fragment.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getNavigationBarWidth((Activity)fragment.getActivity());
    }

    @TargetApi(value=14)
    public static int getNavigationBarWidth(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getNavigationBarWidth(fragment.getActivity());
    }

    @TargetApi(value=14)
    public static boolean isNavigationAtBottom(@NonNull Activity activity) {
        BarConfig config = new BarConfig(activity);
        return config.isNavigationAtBottom();
    }

    @TargetApi(value=14)
    public static boolean isNavigationAtBottom(@NonNull androidx.fragment.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            return false;
        }
        return ImmersionBar.isNavigationAtBottom((Activity)fragment.getActivity());
    }

    @TargetApi(value=14)
    public static boolean isNavigationAtBottom(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            return false;
        }
        return ImmersionBar.isNavigationAtBottom(fragment.getActivity());
    }

    @TargetApi(value=14)
    public static int getStatusBarHeight(@NonNull Activity activity) {
        BarConfig config = new BarConfig(activity);
        return config.getStatusBarHeight();
    }

    @TargetApi(value=14)
    public static int getStatusBarHeight(@NonNull androidx.fragment.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getStatusBarHeight((Activity)fragment.getActivity());
    }

    @TargetApi(value=14)
    public static int getStatusBarHeight(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getStatusBarHeight(fragment.getActivity());
    }

    @TargetApi(value=14)
    public static int getActionBarHeight(@NonNull Activity activity) {
        BarConfig config = new BarConfig(activity);
        return config.getActionBarHeight();
    }

    @TargetApi(value=14)
    public static int getActionBarHeight(@NonNull androidx.fragment.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getActionBarHeight((Activity)fragment.getActivity());
    }

    @TargetApi(value=14)
    public static int getActionBarHeight(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getActionBarHeight(fragment.getActivity());
    }

    public static boolean hasNotchScreen(@NonNull Activity activity) {
        return NotchUtils.hasNotchScreen(activity);
    }

    public static boolean hasNotchScreen(@NonNull androidx.fragment.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            return false;
        }
        return ImmersionBar.hasNotchScreen((Activity)fragment.getActivity());
    }

    public static boolean hasNotchScreen(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            return false;
        }
        return ImmersionBar.hasNotchScreen(fragment.getActivity());
    }

    public static boolean hasNotchScreen(@NonNull View view) {
        return NotchUtils.hasNotchScreen(view);
    }

    public static int getNotchHeight(@NonNull Activity activity) {
        if (ImmersionBar.hasNotchScreen(activity)) {
            return NotchUtils.getNotchHeight(activity);
        }
        return 0;
    }

    public static int getNotchHeight(@NonNull androidx.fragment.app.Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getNotchHeight((Activity)fragment.getActivity());
    }

    public static int getNotchHeight(@NonNull Fragment fragment) {
        if (fragment.getActivity() == null) {
            return 0;
        }
        return ImmersionBar.getNotchHeight(fragment.getActivity());
    }

    public static void hideStatusBar(@NonNull Window window) {
        window.setFlags(1024, 1024);
    }

    public static void showStatusBar(@NonNull Window window) {
        window.clearFlags(1024);
    }

    private static RequestManagerRetriever getRetriever() {
        return RequestManagerRetriever.getInstance();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }
}

