/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.transforms;

import android.view.View;
import com.maning.imagebrowserlibrary.transforms.ABaseTransformer;

public class ZoomOutSlideTransformer
extends ABaseTransformer {
    private static final float MIN_SCALE = 0.85f;
    private static final float MIN_ALPHA = 0.5f;

    @Override
    protected void onTransform(View view, float position) {
        if (position >= -1.0f || position <= 1.0f) {
            float height = view.getHeight();
            float width = view.getWidth();
            float scaleFactor = Math.max(0.85f, 1.0f - Math.abs(position));
            float vertMargin = height * (1.0f - scaleFactor) / 2.0f;
            float horzMargin = width * (1.0f - scaleFactor) / 2.0f;
            view.setPivotY(0.5f * height);
            view.setPivotX(0.5f * width);
            if (position < 0.0f) {
                view.setTranslationX(horzMargin - vertMargin / 2.0f);
            } else {
                view.setTranslationX(-horzMargin + vertMargin / 2.0f);
            }
            view.setScaleX(scaleFactor);
            view.setScaleY(scaleFactor);
            view.setAlpha(0.5f + (scaleFactor - 0.85f) / 0.14999998f * 0.5f);
        }
    }
}

