/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.view.MotionEvent;
import com.mancj.slideup.AnimationProcessor;
import com.mancj.slideup.Internal;
import com.mancj.slideup.LoggerNotifier;
import com.mancj.slideup.SlideUpBuilder;
import com.mancj.slideup.TouchConsumer;

class VerticalTouchConsumer
extends TouchConsumer {
    VerticalTouchConsumer(SlideUpBuilder builder, LoggerNotifier notifier, AnimationProcessor animationProcessor) {
        super(builder, notifier, animationProcessor);
    }

    boolean consumeBottomToTop(MotionEvent event) {
        float touchedArea = event.getY();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewHeight = this.mBuilder.mSliderView.getHeight();
                this.mStartPositionY = event.getRawY();
                this.mViewStartPositionY = this.mBuilder.mSliderView.getTranslationY();
                this.mCanSlide = this.mBuilder.mTouchableArea >= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.mStartPositionY;
                float moveTo = this.mViewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)this.mBuilder.mSliderView.getHeight();
                if (moveTo > 0.0f && this.mCanSlide) {
                    this.mNotifier.notifyPercentChanged(percents);
                    this.mBuilder.mSliderView.setTranslationY(moveTo);
                }
                if (!(event.getRawY() > this.mMaxSlidePosition)) break;
                this.mMaxSlidePosition = event.getRawY();
                break;
            }
            case 1: {
                boolean scrollableAreaConsumed;
                float slideAnimationFrom = this.mBuilder.mSliderView.getTranslationY();
                if (slideAnimationFrom == this.mViewStartPositionY) {
                    return !Internal.isUpEventInView(this.mBuilder.mSliderView, event);
                }
                boolean mustShow = this.mMaxSlidePosition > event.getRawY();
                boolean bl = scrollableAreaConsumed = this.mBuilder.mSliderView.getTranslationY() > (float)(this.mBuilder.mSliderView.getHeight() / 5);
                if (scrollableAreaConsumed && !mustShow) {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, this.mBuilder.mSliderView.getHeight());
                } else {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, 0.0f);
                }
                this.mCanSlide = true;
                this.mMaxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    boolean consumeTopToBottom(MotionEvent event) {
        float touchedArea = event.getY();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewHeight = this.mBuilder.mSliderView.getHeight();
                this.mStartPositionY = event.getRawY();
                this.mViewStartPositionY = this.mBuilder.mSliderView.getTranslationY();
                this.mMaxSlidePosition = this.mViewHeight;
                this.mCanSlide = (float)this.getBottom() - this.mBuilder.mTouchableArea <= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.mStartPositionY;
                float moveTo = this.mViewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)(-this.mBuilder.mSliderView.getHeight());
                if (moveTo < 0.0f && this.mCanSlide) {
                    this.mNotifier.notifyPercentChanged(percents);
                    this.mBuilder.mSliderView.setTranslationY(moveTo);
                }
                if (!(event.getRawY() < this.mMaxSlidePosition)) break;
                this.mMaxSlidePosition = event.getRawY();
                break;
            }
            case 1: {
                boolean scrollableAreaConsumed;
                float slideAnimationFrom = -this.mBuilder.mSliderView.getTranslationY();
                if (slideAnimationFrom == this.mViewStartPositionY) {
                    return !Internal.isUpEventInView(this.mBuilder.mSliderView, event);
                }
                boolean mustShow = this.mMaxSlidePosition < event.getRawY();
                boolean bl = scrollableAreaConsumed = this.mBuilder.mSliderView.getTranslationY() < (float)(-this.mBuilder.mSliderView.getHeight() / 5);
                if (scrollableAreaConsumed && !mustShow) {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, this.mBuilder.mSliderView.getHeight() + this.mBuilder.mSliderView.getTop());
                } else {
                    this.mAnimationProcessor.setValuesAndStart(slideAnimationFrom, 0.0f);
                }
                this.mCanSlide = true;
                this.mMaxSlidePosition = 0.0f;
            }
        }
        return true;
    }
}

