/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import com.mancj.slideup.R;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SlideUp
implements View.OnTouchListener,
ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener {
    private static final String TAG = SlideUp.class.getSimpleName();
    private static final String KEY_START_GRAVITY = TAG + "_start_gravity";
    private static final String KEY_DEBUG = TAG + "_debug";
    private static final String KEY_TOUCHABLE_AREA = TAG + "_touchable_area";
    private static final String KEY_STATE = TAG + "_state";
    private static final String KEY_AUTO_SLIDE_DURATION = TAG + "_auto_slide_duration";
    private static final String KEY_HIDE_SOFT_INPUT = TAG + "_hide_soft_input";
    private static final String KEY_STATE_SAVED = TAG + "_state_saved";
    private State mStartState;
    private State mCurrentState;
    private View mSliderView;
    private float mTouchableArea;
    private int mAutoSlideDuration;
    private List<Listener> mListeners;
    private ValueAnimator mValueAnimator;
    private float mSlideAnimationTo;
    private float mStartPositionY;
    private float mStartPositionX;
    private float mViewStartPositionY;
    private float mViewStartPositionX;
    private boolean mCanSlide = true;
    private float mDensity;
    private float mMaxSlidePosition;
    private float mViewHeight;
    private float mViewWidth;
    private boolean mHideKeyboard;
    private TimeInterpolator mInterpolator;
    private boolean mGesturesEnabled;
    private boolean mIsRTL;
    private int mStartGravity;
    private boolean mDebug;

    public void hideSoftInput() {
        ((InputMethodManager)this.mSliderView.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.mSliderView.getWindowToken(), 2);
    }

    public void showSoftInput() {
        ((InputMethodManager)this.mSliderView.getContext().getSystemService("input_method")).showSoftInput(this.mSliderView, 0);
    }

    private SlideUp(Builder builder) {
        this.mStartGravity = builder.mStartGravity;
        this.mListeners = builder.mListeners;
        this.mSliderView = builder.mSliderView;
        this.mStartState = builder.mStartState;
        this.mDensity = builder.mDensity;
        this.mTouchableArea = builder.mTouchableArea;
        this.mAutoSlideDuration = builder.mAutoSlideDuration;
        this.mDebug = builder.mDebug;
        this.mIsRTL = builder.mIsRTL;
        this.mGesturesEnabled = builder.mGesturesEnabled;
        this.mHideKeyboard = builder.mHideKeyboard;
        this.mInterpolator = builder.mInterpolator;
        this.init();
    }

    private void init() {
        this.mSliderView.setOnTouchListener((View.OnTouchListener)this);
        this.createAnimation();
        this.mSliderView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                SlideUp.this.mViewHeight = SlideUp.this.mSliderView.getHeight();
                SlideUp.this.mViewWidth = SlideUp.this.mSliderView.getWidth();
                switch (SlideUp.this.mStartGravity) {
                    case 48: {
                        SlideUp.this.mSliderView.setPivotY(SlideUp.this.mViewHeight);
                        break;
                    }
                    case 80: {
                        SlideUp.this.mSliderView.setPivotY(0.0f);
                        break;
                    }
                    case 0x800003: {
                        SlideUp.this.mSliderView.setPivotX(0.0f);
                        break;
                    }
                    case 0x800005: {
                        SlideUp.this.mSliderView.setPivotX(SlideUp.this.mViewWidth);
                    }
                }
                SlideUp.this.updateToCurrentState();
                ViewTreeObserver observer = SlideUp.this.mSliderView.getViewTreeObserver();
                if (Build.VERSION.SDK_INT <= 16) {
                    observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.updateToCurrentState();
    }

    private void updateToCurrentState() {
        switch (this.mStartState) {
            case HIDDEN: {
                this.hideImmediately();
                break;
            }
            case SHOWED: {
                this.showImmediately();
            }
        }
    }

    public boolean isVisible() {
        return this.mSliderView.getVisibility() == 0;
    }

    public void addSlideListener(@NonNull Listener listener) {
        this.mListeners.add(listener);
    }

    public void removeSlideListener(@NonNull Listener listener) {
        this.mListeners.remove(listener);
    }

    public <T extends View> T getSliderView() {
        return (T)this.mSliderView;
    }

    public void setAutoSlideDuration(int autoSlideDuration) {
        this.mAutoSlideDuration = autoSlideDuration;
    }

    public float getAutoSlideDuration() {
        return this.mAutoSlideDuration;
    }

    public void setTouchableArea(float touchableArea) {
        this.mTouchableArea = touchableArea * this.mDensity;
    }

    public float getTouchableArea() {
        return this.mTouchableArea / this.mDensity;
    }

    public boolean isAnimationRunning() {
        return this.mValueAnimator != null && this.mValueAnimator.isRunning();
    }

    public void show() {
        this.show(false);
    }

    public void hide() {
        this.hide(false);
    }

    public void hideImmediately() {
        this.hide(true);
    }

    public void showImmediately() {
        this.show(true);
    }

    public void setLoggingEnabled(boolean enabled) {
        this.mDebug = enabled;
    }

    public boolean isLoggingEnabled() {
        return this.mDebug;
    }

    public void setGesturesEnabled(boolean enabled) {
        this.mGesturesEnabled = enabled;
    }

    public boolean isGesturesEnabled() {
        return this.mGesturesEnabled;
    }

    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    public int getStartGravity() {
        return this.mStartGravity;
    }

    public void setInterpolator(TimeInterpolator interpolator) {
        this.mInterpolator = interpolator;
        this.mValueAnimator.setInterpolator(this.mInterpolator);
    }

    public boolean isHideKeyboardWhenDisplayed() {
        return this.mHideKeyboard;
    }

    public void setHideKeyboardWhenDisplayed(boolean hide) {
        this.mHideKeyboard = hide;
    }

    public void toggle() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    public void toggleImmediately() {
        if (this.isVisible()) {
            this.hideImmediately();
        } else {
            this.showImmediately();
        }
    }

    public void onSaveInstanceState(@NonNull Bundle savedState) {
        savedState.putBoolean(KEY_STATE_SAVED, true);
        savedState.putInt(KEY_START_GRAVITY, this.mStartGravity);
        savedState.putBoolean(KEY_DEBUG, this.mDebug);
        savedState.putFloat(KEY_TOUCHABLE_AREA, this.mTouchableArea / this.mDensity);
        savedState.putSerializable(KEY_STATE, (Serializable)((Object)this.mCurrentState));
        savedState.putInt(KEY_AUTO_SLIDE_DURATION, this.mAutoSlideDuration);
        savedState.putBoolean(KEY_HIDE_SOFT_INPUT, this.mHideKeyboard);
    }

    private void endAnimation() {
        if (this.mValueAnimator != null && this.mValueAnimator.getValues() != null && this.mValueAnimator.isRunning()) {
            this.mValueAnimator.end();
        }
    }

    private void hide(boolean immediately) {
        this.endAnimation();
        switch (this.mStartGravity) {
            case 48: {
                if (immediately) {
                    if (this.mSliderView.getHeight() > 0) {
                        this.mSliderView.setTranslationY(-this.mViewHeight);
                        this.notifyVisibilityChanged(8);
                        break;
                    }
                    this.mStartState = State.HIDDEN;
                    break;
                }
                this.setValuesAndStart(this.mSliderView.getTranslationY(), this.mSliderView.getHeight());
                break;
            }
            case 80: {
                if (immediately) {
                    if (this.mSliderView.getHeight() > 0) {
                        this.mSliderView.setTranslationY(this.mViewHeight);
                        this.notifyVisibilityChanged(8);
                        break;
                    }
                    this.mStartState = State.HIDDEN;
                    break;
                }
                this.setValuesAndStart(this.mSliderView.getTranslationY(), this.mSliderView.getHeight());
                break;
            }
            case 0x800003: {
                if (immediately) {
                    if (this.mSliderView.getWidth() > 0) {
                        this.mSliderView.setTranslationX(-this.mViewWidth);
                        this.notifyVisibilityChanged(8);
                        break;
                    }
                    this.mStartState = State.HIDDEN;
                    break;
                }
                this.setValuesAndStart(this.mSliderView.getTranslationX(), this.mSliderView.getHeight());
                break;
            }
            case 0x800005: {
                if (immediately) {
                    if (this.mSliderView.getWidth() > 0) {
                        this.mSliderView.setTranslationX(this.mViewWidth);
                        this.notifyVisibilityChanged(8);
                        break;
                    }
                    this.mStartState = State.HIDDEN;
                    break;
                }
                this.setValuesAndStart(this.mSliderView.getTranslationX(), this.mSliderView.getHeight());
            }
        }
    }

    private void show(boolean immediately) {
        this.endAnimation();
        switch (this.mStartGravity) {
            case 48: {
                if (immediately) {
                    if (this.mSliderView.getHeight() > 0) {
                        this.mSliderView.setTranslationY(0.0f);
                        this.notifyVisibilityChanged(0);
                    } else {
                        this.mStartState = State.SHOWED;
                    }
                } else {
                    this.setValuesAndStart(this.mSliderView.getTranslationY(), 0.0f);
                }
            }
            case 80: {
                if (immediately) {
                    if (this.mSliderView.getHeight() > 0) {
                        this.mSliderView.setTranslationY(0.0f);
                        this.notifyVisibilityChanged(0);
                        break;
                    }
                    this.mStartState = State.SHOWED;
                    break;
                }
                this.setValuesAndStart(this.mSliderView.getTranslationY(), 0.0f);
                break;
            }
            case 0x800003: {
                if (immediately) {
                    if (this.mSliderView.getWidth() > 0) {
                        this.mSliderView.setTranslationX(0.0f);
                        this.notifyVisibilityChanged(0);
                    } else {
                        this.mStartState = State.SHOWED;
                    }
                } else {
                    this.setValuesAndStart(this.mSliderView.getTranslationX(), 0.0f);
                }
            }
            case 0x800005: {
                if (immediately) {
                    if (this.mSliderView.getWidth() > 0) {
                        this.mSliderView.setTranslationX(0.0f);
                        this.notifyVisibilityChanged(0);
                        break;
                    }
                    this.mStartState = State.SHOWED;
                    break;
                }
                this.setValuesAndStart(this.mSliderView.getTranslationX(), 0.0f);
            }
        }
    }

    private void setValuesAndStart(float from, float to) {
        this.mSlideAnimationTo = to;
        this.mValueAnimator.setFloatValues(new float[]{from, to});
        this.mValueAnimator.start();
    }

    private void createAnimation() {
        this.mValueAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        this.mValueAnimator.setDuration((long)this.mAutoSlideDuration);
        this.mValueAnimator.setInterpolator(this.mInterpolator);
        this.mValueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.mValueAnimator.addListener((Animator.AnimatorListener)this);
    }

    public final boolean onTouch(View v, MotionEvent event) {
        if (!this.mGesturesEnabled) {
            return false;
        }
        if (this.isAnimationRunning()) {
            return false;
        }
        switch (this.mStartGravity) {
            case 48: {
                return this.onTouchUpToDown(event);
            }
            case 80: {
                return this.onTouchDownToUp(event);
            }
            case 0x800003: {
                return this.onTouchStartToEnd(event);
            }
            case 0x800005: {
                return this.onTouchEndToStart(event);
            }
        }
        this.e("onTouchListener", "(onTouch)", "You are using not supportable gravity");
        return false;
    }

    private boolean onTouchEndToStart(MotionEvent event) {
        float touchedArea = event.getRawX() - (float)this.getEnd();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewWidth = this.mSliderView.getWidth();
                this.mStartPositionX = event.getRawX();
                this.mViewStartPositionX = this.mSliderView.getTranslationX();
                if (!(this.mTouchableArea < touchedArea)) break;
                this.mCanSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawX() - this.mStartPositionX;
                float moveTo = this.mViewStartPositionX + difference;
                float percents = moveTo * 100.0f / (float)this.mSliderView.getWidth();
                if (moveTo > 0.0f && this.mCanSlide) {
                    this.notifyPercentChanged(percents);
                    this.mSliderView.setTranslationX(moveTo);
                }
                if (!(event.getRawX() > this.mMaxSlidePosition)) break;
                this.mMaxSlidePosition = event.getRawX();
                break;
            }
            case 1: {
                float slideAnimationFrom = this.mSliderView.getTranslationX();
                if (slideAnimationFrom == this.mViewStartPositionX) {
                    return false;
                }
                boolean mustShow = this.mMaxSlidePosition > event.getRawX();
                boolean scrollableAreaConsumed = this.mSliderView.getTranslationX() > (float)(this.mSliderView.getWidth() / 5);
                this.mSlideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)this.mSliderView.getWidth() : 0.0f;
                this.mValueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.mSlideAnimationTo});
                this.mValueAnimator.start();
                this.mCanSlide = true;
                this.mMaxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    private boolean onTouchStartToEnd(MotionEvent event) {
        float touchedArea = (float)this.getEnd() - event.getRawX();
        switch (event.getActionMasked()) {
            case 0: {
                this.mMaxSlidePosition = this.mViewWidth;
                this.mViewWidth = this.mSliderView.getWidth();
                this.mStartPositionX = event.getRawX();
                this.mViewStartPositionX = this.mSliderView.getTranslationX();
                if (!(this.mTouchableArea < touchedArea)) break;
                this.mCanSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawX() - this.mStartPositionX;
                float moveTo = this.mViewStartPositionX + difference;
                float percents = moveTo * 100.0f / (float)(-this.mSliderView.getWidth());
                if (moveTo < 0.0f && this.mCanSlide) {
                    this.notifyPercentChanged(percents);
                    this.mSliderView.setTranslationX(moveTo);
                }
                if (!(event.getRawX() < this.mMaxSlidePosition)) break;
                this.mMaxSlidePosition = event.getRawX();
                break;
            }
            case 1: {
                float slideAnimationFrom = -this.mSliderView.getTranslationX();
                if (slideAnimationFrom == this.mViewStartPositionX) {
                    return false;
                }
                boolean mustShow = this.mMaxSlidePosition < event.getRawX();
                boolean scrollableAreaConsumed = this.mSliderView.getTranslationX() < (float)(-this.mSliderView.getHeight() / 5);
                this.mSlideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)this.mSliderView.getWidth() : 0.0f;
                this.mValueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.mSlideAnimationTo});
                this.mValueAnimator.start();
                this.mCanSlide = true;
                this.mMaxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    private boolean onTouchDownToUp(MotionEvent event) {
        float touchedArea = event.getRawY() - (float)this.mSliderView.getTop();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewHeight = this.mSliderView.getHeight();
                this.mStartPositionY = event.getRawY();
                this.mViewStartPositionY = this.mSliderView.getTranslationY();
                this.mCanSlide = this.mTouchableArea >= touchedArea;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.mStartPositionY;
                float moveTo = this.mViewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)this.mSliderView.getHeight();
                if (moveTo > 0.0f && this.mCanSlide) {
                    this.notifyPercentChanged(percents);
                    this.mSliderView.setTranslationY(moveTo);
                }
                if (!(event.getRawY() > this.mMaxSlidePosition)) break;
                this.mMaxSlidePosition = event.getRawY();
                break;
            }
            case 1: {
                float slideAnimationFrom = this.mSliderView.getTranslationY();
                if (slideAnimationFrom == this.mViewStartPositionY) {
                    return false;
                }
                boolean mustShow = this.mMaxSlidePosition > event.getRawY();
                boolean scrollableAreaConsumed = this.mSliderView.getTranslationY() > (float)(this.mSliderView.getHeight() / 5);
                this.mSlideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)this.mSliderView.getHeight() : 0.0f;
                this.mValueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.mSlideAnimationTo});
                this.mValueAnimator.start();
                this.mCanSlide = true;
                this.mMaxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    private boolean onTouchUpToDown(MotionEvent event) {
        float touchedArea = event.getRawY() - (float)this.mSliderView.getBottom();
        switch (event.getActionMasked()) {
            case 0: {
                this.mViewHeight = this.mSliderView.getHeight();
                this.mStartPositionY = event.getRawY();
                this.mViewStartPositionY = this.mSliderView.getTranslationY();
                this.mMaxSlidePosition = this.mViewHeight;
                if (!(this.mTouchableArea < touchedArea)) break;
                this.mCanSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.mStartPositionY;
                float moveTo = this.mViewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)(-this.mSliderView.getHeight());
                if (moveTo < 0.0f && this.mCanSlide) {
                    this.notifyPercentChanged(percents);
                    this.mSliderView.setTranslationY(moveTo);
                }
                if (!(event.getRawY() < this.mMaxSlidePosition)) break;
                this.mMaxSlidePosition = event.getRawY();
                break;
            }
            case 1: {
                float slideAnimationFrom = -this.mSliderView.getTranslationY();
                if (slideAnimationFrom == this.mViewStartPositionY) {
                    return false;
                }
                boolean mustShow = this.mMaxSlidePosition < event.getRawY();
                boolean scrollableAreaConsumed = this.mSliderView.getTranslationY() < (float)(-this.mSliderView.getHeight() / 5);
                this.mSlideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)(this.mSliderView.getHeight() + this.mSliderView.getTop()) : 0.0f;
                this.mValueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.mSlideAnimationTo});
                this.mValueAnimator.start();
                this.mCanSlide = true;
                this.mMaxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    public final void onAnimationUpdate(ValueAnimator animation) {
        float value = ((Float)animation.getAnimatedValue()).floatValue();
        switch (this.mStartGravity) {
            case 48: {
                this.onAnimationUpdateUpToDown(value);
                break;
            }
            case 80: {
                this.onAnimationUpdateDownToUp(value);
                break;
            }
            case 0x800003: {
                this.onAnimationUpdateStartToEnd(value);
                break;
            }
            case 0x800005: {
                this.onAnimationUpdateEndToStart(value);
            }
        }
    }

    private void onAnimationUpdateUpToDown(float value) {
        this.mSliderView.setTranslationY(-value);
        float visibleDistance = (float)this.mSliderView.getTop() - this.mSliderView.getY();
        float percents = visibleDistance * 100.0f / this.mViewHeight;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateDownToUp(float value) {
        this.mSliderView.setTranslationY(value);
        float visibleDistance = this.mSliderView.getY() - (float)this.mSliderView.getTop();
        float percents = visibleDistance * 100.0f / this.mViewHeight;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateStartToEnd(float value) {
        this.mSliderView.setTranslationX(-value);
        float visibleDistance = this.mSliderView.getX() - (float)this.getStart();
        float percents = visibleDistance * 100.0f / -this.mViewWidth;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateEndToStart(float value) {
        this.mSliderView.setTranslationX(value);
        float visibleDistance = this.mSliderView.getX() - (float)this.getStart();
        float percents = visibleDistance * 100.0f / this.mViewWidth;
        this.notifyPercentChanged(percents);
    }

    private int getStart() {
        if (this.mIsRTL) {
            return this.mSliderView.getRight();
        }
        return this.mSliderView.getLeft();
    }

    private int getEnd() {
        if (this.mIsRTL) {
            return this.mSliderView.getLeft();
        }
        return this.mSliderView.getRight();
    }

    private void notifyPercentChanged(float percent) {
        percent = percent > 100.0f ? 100.0f : percent;
        float f = percent = percent < 0.0f ? 0.0f : percent;
        if (this.mSlideAnimationTo == 0.0f && this.mHideKeyboard) {
            this.hideSoftInput();
        }
        if (this.mListeners != null && !this.mListeners.isEmpty()) {
            for (int i = 0; i < this.mListeners.size(); ++i) {
                Listener l = this.mListeners.get(i);
                if (l != null) {
                    if (!(l instanceof Listener.Slide)) continue;
                    Listener.Slide slide = (Listener.Slide)l;
                    slide.onSlide(percent);
                    this.d("Listener(" + i + ")", "(onSlide)", "value = " + percent);
                    continue;
                }
                this.e("Listener(" + i + ")", "(onSlide)", "Listener is null, skip notification...");
            }
        }
    }

    private void notifyVisibilityChanged(int visibility) {
        this.mSliderView.setVisibility(visibility);
        if (this.mListeners != null && !this.mListeners.isEmpty()) {
            for (int i = 0; i < this.mListeners.size(); ++i) {
                Listener l = this.mListeners.get(i);
                if (l != null) {
                    if (!(l instanceof Listener.Visibility)) continue;
                    Listener.Visibility vis = (Listener.Visibility)l;
                    vis.onVisibilityChanged(visibility);
                    this.d("Listener(" + i + ")", "(onVisibilityChanged)", "value = " + (visibility == 0 ? "VISIBLE" : (visibility == 8 ? "GONE" : Integer.valueOf(visibility))));
                    continue;
                }
                this.e("Listener(" + i + ")", "(onVisibilityChanged)", "Listener is null, skip notify for him...");
            }
        }
        switch (visibility) {
            case 0: {
                this.mCurrentState = State.SHOWED;
                break;
            }
            case 8: {
                this.mCurrentState = State.HIDDEN;
            }
        }
    }

    public final void onAnimationStart(Animator animator) {
        if (this.mSliderView.getVisibility() != 0) {
            this.notifyVisibilityChanged(0);
        }
    }

    public final void onAnimationEnd(Animator animator) {
        if (this.mSlideAnimationTo != 0.0f && this.mSliderView.getVisibility() != 8) {
            this.notifyVisibilityChanged(8);
        }
    }

    public final void onAnimationCancel(Animator animator) {
    }

    public final void onAnimationRepeat(Animator animator) {
    }

    private void e(String listener, String method, String message) {
        if (this.mDebug) {
            Log.e((String)TAG, (String)String.format("%1$-15s %2$-23s %3$s", listener, method, message));
        }
    }

    private void d(String listener, String method, String value) {
        if (this.mDebug) {
            Log.d((String)TAG, (String)String.format("%1$-15s %2$-23s %3$s", listener, method, value));
        }
    }

    public static final class Builder {
        private boolean mStateRestored = false;
        private View mSliderView;
        private float mDensity;
        private float mTouchableArea;
        private boolean mIsRTL;
        private State mStartState = State.HIDDEN;
        private List<Listener> mListeners = new ArrayList<Listener>();
        private boolean mDebug = false;
        private int mAutoSlideDuration = 300;
        private int mStartGravity = 80;
        private boolean mGesturesEnabled = true;
        private boolean mHideKeyboard = false;
        private TimeInterpolator mInterpolator = new DecelerateInterpolator();

        public Builder(@NonNull View sliderView) {
            this.mSliderView = sliderView;
            this.mDensity = sliderView.getResources().getDisplayMetrics().density;
            this.mIsRTL = sliderView.getResources().getBoolean(R.bool.is_right_to_left);
            this.mTouchableArea = 300.0f * this.mDensity;
        }

        public Builder withStartState(@NonNull State startState) {
            if (!this.mStateRestored) {
                this.mStartState = startState;
            }
            return this;
        }

        public Builder withStartGravity(int gravity) {
            if (!this.mStateRestored) {
                this.mStartGravity = gravity;
            }
            return this;
        }

        public Builder withListeners(@NonNull List<Listener> listeners) {
            this.mListeners = listeners;
            return this;
        }

        public Builder withListeners(Listener ... listeners) {
            ArrayList<Listener> listeners_list = new ArrayList<Listener>();
            Collections.addAll(listeners_list, listeners);
            return this.withListeners(listeners_list);
        }

        public Builder withLoggingEnabled(boolean enabled) {
            if (!this.mStateRestored) {
                this.mDebug = enabled;
            }
            return this;
        }

        public Builder withAutoSlideDuration(int duration) {
            if (!this.mStateRestored) {
                this.mAutoSlideDuration = duration;
            }
            return this;
        }

        public Builder withTouchableArea(float area) {
            if (!this.mStateRestored) {
                this.mTouchableArea = area * this.mDensity;
            }
            return this;
        }

        public Builder withGesturesEnabled(boolean enabled) {
            this.mGesturesEnabled = enabled;
            return this;
        }

        public Builder withHideSoftInputWhenDisplayed(boolean hide) {
            if (!this.mStateRestored) {
                this.mHideKeyboard = hide;
            }
            return this;
        }

        public Builder withInterpolator(TimeInterpolator interpolator) {
            this.mInterpolator = interpolator;
            return this;
        }

        public Builder withSavedState(@Nullable Bundle savedState) {
            this.restoreParams(savedState);
            return this;
        }

        public SlideUp build() {
            return new SlideUp(this);
        }

        private void restoreParams(@Nullable Bundle savedState) {
            if (savedState == null) {
                return;
            }
            this.mStateRestored = savedState.getBoolean(KEY_STATE_SAVED, false);
            if (savedState.getSerializable(KEY_STATE) != null) {
                this.mStartState = (State)((Object)savedState.getSerializable(KEY_STATE));
            }
            this.mStartGravity = savedState.getInt(KEY_START_GRAVITY, this.mStartGravity);
            this.mDebug = savedState.getBoolean(KEY_DEBUG, this.mDebug);
            this.mTouchableArea = savedState.getFloat(KEY_TOUCHABLE_AREA, this.mTouchableArea) * this.mDensity;
            this.mAutoSlideDuration = savedState.getInt(KEY_AUTO_SLIDE_DURATION, this.mAutoSlideDuration);
            this.mHideKeyboard = savedState.getBoolean(KEY_HIDE_SOFT_INPUT, this.mHideKeyboard);
        }
    }

    public static interface Listener {

        public static interface Events
        extends Visibility,
        Slide {
        }

        public static interface Visibility
        extends Listener {
            public void onVisibilityChanged(int var1);
        }

        public static interface Slide
        extends Listener {
            public void onSlide(float var1);
        }
    }

    public static enum State {
        HIDDEN,
        SHOWED;

    }
}

