/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;

public class SlideUp
implements View.OnTouchListener,
ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener {
    private View view;
    private float touchableTop;
    private int autoSlideDuration = 300;
    private SlideListener slideListener;
    private ValueAnimator valueAnimator;
    private float slideAnimationTo;
    private float startPositionY;
    private float viewStartPositionY;
    private boolean canSlide = true;
    private float density;
    private float lowerPosition;
    private float viewHeight;
    private boolean hiddenInit;

    public SlideUp(final View view) {
        this.view = view;
        this.density = view.getResources().getDisplayMetrics().density;
        this.touchableTop = 300.0f * this.density;
        view.setOnTouchListener((View.OnTouchListener)this);
        view.setPivotY(0.0f);
        this.createAnimation();
        view.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (SlideUp.this.hiddenInit) {
                    SlideUp.this.viewHeight = view.getHeight();
                    SlideUp.this.hideImmediately();
                }
                view.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    public boolean isVisible() {
        return this.view.getVisibility() == 0;
    }

    public void setSlideListener(SlideListener slideListener) {
        this.slideListener = slideListener;
    }

    public void setAutoSlideDuration(int autoSlideDuration) {
        this.autoSlideDuration = autoSlideDuration;
    }

    public float getAutoSlideDuration() {
        return this.autoSlideDuration;
    }

    public void setTouchableTop(float touchableTop) {
        this.touchableTop = touchableTop * this.density;
    }

    public float getTouchableTop() {
        return this.touchableTop / this.density;
    }

    public boolean isAnimationRunning() {
        return this.valueAnimator != null && this.valueAnimator.isRunning();
    }

    public void animateIn() {
        this.slideAnimationTo = 0.0f;
        this.valueAnimator.setFloatValues(new float[]{this.viewHeight, this.slideAnimationTo});
        this.valueAnimator.start();
    }

    public void animateOut() {
        this.slideAnimationTo = this.view.getHeight();
        this.valueAnimator.setFloatValues(new float[]{this.view.getTranslationY(), this.slideAnimationTo});
        this.valueAnimator.start();
    }

    public void hideImmediately() {
        if (this.view.getHeight() > 0) {
            this.view.setTranslationY(this.viewHeight);
            this.view.setVisibility(8);
            this.notifyVisibilityChanged(8);
        } else {
            this.hiddenInit = true;
        }
    }

    private void createAnimation() {
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        this.valueAnimator.setDuration((long)this.autoSlideDuration);
        this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.valueAnimator.addListener((Animator.AnimatorListener)this);
    }

    public boolean onTouch(View v, MotionEvent event) {
        float touchedArea = event.getRawY() - (float)this.view.getTop();
        if (this.isAnimationRunning()) {
            return false;
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.viewHeight = this.view.getHeight();
                this.startPositionY = event.getRawY();
                this.viewStartPositionY = this.view.getTranslationY();
                if (!(this.touchableTop < touchedArea)) break;
                this.canSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.startPositionY;
                float moveTo = this.viewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)this.view.getHeight();
                if (moveTo > 0.0f && this.canSlide) {
                    this.notifyPercentChanged(percents);
                    this.view.setTranslationY(moveTo);
                }
                if (!(event.getRawY() > this.lowerPosition)) break;
                this.lowerPosition = event.getRawY();
                break;
            }
            case 1: {
                float slideAnimationFrom = this.view.getTranslationY();
                boolean mustSlideUp = this.lowerPosition > event.getRawY();
                boolean scrollableAreaConsumed = this.view.getTranslationY() > (float)(this.view.getHeight() / 5);
                this.slideAnimationTo = scrollableAreaConsumed && !mustSlideUp ? (float)this.view.getHeight() : 0.0f;
                this.valueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.slideAnimationTo});
                this.valueAnimator.start();
                this.canSlide = true;
                this.lowerPosition = 0.0f;
            }
        }
        return true;
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        float val = ((Float)animation.getAnimatedValue()).floatValue();
        this.view.setTranslationY(val);
        float percents = (this.view.getY() - (float)this.view.getTop()) * 100.0f / this.viewHeight;
        this.notifyPercentChanged(percents);
    }

    private void notifyPercentChanged(float percent) {
        if (this.slideListener != null) {
            this.slideListener.onSlideDown(percent);
        }
    }

    private void notifyVisibilityChanged(int visibility) {
        if (this.slideListener != null) {
            this.slideListener.onVisibilityChanged(visibility);
        }
    }

    public void onAnimationStart(Animator animator) {
        this.view.setVisibility(0);
        this.notifyVisibilityChanged(0);
    }

    public void onAnimationEnd(Animator animator) {
        if (this.slideAnimationTo > 0.0f) {
            this.view.setVisibility(8);
            this.notifyVisibilityChanged(8);
        }
    }

    public void onAnimationCancel(Animator animator) {
    }

    public void onAnimationRepeat(Animator animator) {
    }

    public static interface SlideListener {
        public void onSlideDown(float var1);

        public void onVisibilityChanged(int var1);
    }
}

