/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.materialsearchbar;

import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.CardView;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.PopupMenu;
import android.support.v7.widget.RecyclerView;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mancj.materialsearchbar.R;
import com.mancj.materialsearchbar.adapter.DefaultSuggestionsAdapter;
import com.mancj.materialsearchbar.adapter.SuggestionsAdapter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class MaterialSearchBar
extends RelativeLayout
implements View.OnClickListener,
Animation.AnimationListener,
SuggestionsAdapter.OnItemViewClickListener,
View.OnFocusChangeListener,
TextView.OnEditorActionListener {
    public static final int BUTTON_SPEECH = 1;
    public static final int BUTTON_NAVIGATION = 2;
    public static final int BUTTON_BACK = 3;
    public static final int VIEW_VISIBLE = 1;
    public static final int VIEW_INVISIBLE = 0;
    private CardView searchBarCardView;
    private LinearLayout inputContainer;
    private ImageView navIcon;
    private ImageView menuIcon;
    private ImageView searchIcon;
    private ImageView arrowIcon;
    private ImageView clearIcon;
    private EditText searchEdit;
    private TextView placeHolder;
    private View suggestionDivider;
    private View menuDivider;
    private OnSearchActionListener onSearchActionListener;
    private boolean searchEnabled;
    private boolean suggestionsVisible;
    private SuggestionsAdapter adapter;
    private float destiny;
    private PopupMenu popupMenu;
    private int navIconResId;
    private int menuIconRes;
    private int searchIconRes;
    private int speechIconRes;
    private int arrowIconRes;
    private int clearIconRes;
    private boolean speechMode;
    private int maxSuggestionCount;
    private boolean navButtonEnabled;
    private boolean roundedSearchBarEnabled;
    private boolean menuDividerEnabled;
    private int dividerColor;
    private int searchBarColor;
    private CharSequence hintText;
    private CharSequence placeholderText;
    private int textColor;
    private int hintColor;
    private int placeholderColor;
    private int navIconTint;
    private int menuIconTint;
    private int searchIconTint;
    private int arrowIconTint;
    private int clearIconTint;
    private boolean navIconTintEnabled;
    private boolean menuIconTintEnabled;
    private boolean searchIconTintEnabled;
    private boolean arrowIconTintEnabled;
    private boolean clearIconTintEnabled;
    private boolean borderlessRippleEnabled = false;
    private int textCursorColor;
    private int highlightedTextColor;
    private boolean navIconShown = true;

    public MaterialSearchBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MaterialSearchBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public MaterialSearchBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        MaterialSearchBar.inflate((Context)this.getContext(), (int)R.layout.searchbar, (ViewGroup)this);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.MaterialSearchBar);
        this.speechMode = array.getBoolean(R.styleable.MaterialSearchBar_mt_speechMode, false);
        this.maxSuggestionCount = array.getInt(R.styleable.MaterialSearchBar_mt_maxSuggestionsCount, 3);
        this.navButtonEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_navIconEnabled, false);
        this.roundedSearchBarEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_roundedSearchBarEnabled, false);
        this.menuDividerEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_menuDividerEnabled, false);
        this.dividerColor = array.getColor(R.styleable.MaterialSearchBar_mt_dividerColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarDividerColor));
        this.searchBarColor = array.getColor(R.styleable.MaterialSearchBar_mt_searchBarColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarPrimaryColor));
        this.menuIconRes = array.getResourceId(R.styleable.MaterialSearchBar_mt_menuIconDrawable, R.drawable.ic_dots_vertical_black_48dp);
        this.searchIconRes = array.getResourceId(R.styleable.MaterialSearchBar_mt_searchIconDrawable, R.drawable.ic_magnify_black_48dp);
        this.speechIconRes = array.getResourceId(R.styleable.MaterialSearchBar_mt_speechIconDrawable, R.drawable.ic_microphone_black_48dp);
        this.arrowIconRes = array.getResourceId(R.styleable.MaterialSearchBar_mt_backIconDrawable, R.drawable.ic_arrow_left_black_48dp);
        this.clearIconRes = array.getResourceId(R.styleable.MaterialSearchBar_mt_clearIconDrawable, R.drawable.ic_close_black_48dp);
        this.navIconTint = array.getColor(R.styleable.MaterialSearchBar_mt_navIconTint, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarNavIconTintColor));
        this.menuIconTint = array.getColor(R.styleable.MaterialSearchBar_mt_menuIconTint, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarMenuIconTintColor));
        this.searchIconTint = array.getColor(R.styleable.MaterialSearchBar_mt_searchIconTint, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarSearchIconTintColor));
        this.arrowIconTint = array.getColor(R.styleable.MaterialSearchBar_mt_backIconTint, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarBackIconTintColor));
        this.clearIconTint = array.getColor(R.styleable.MaterialSearchBar_mt_clearIconTint, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarClearIconTintColor));
        this.navIconTintEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_navIconUseTint, true);
        this.menuIconTintEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_menuIconUseTint, true);
        this.searchIconTintEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_searchIconUseTint, true);
        this.arrowIconTintEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_backIconUseTint, true);
        this.clearIconTintEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_clearIconUseTint, true);
        this.borderlessRippleEnabled = array.getBoolean(R.styleable.MaterialSearchBar_mt_borderlessRippleEnabled, false);
        this.hintText = array.getString(R.styleable.MaterialSearchBar_mt_hint);
        this.placeholderText = array.getString(R.styleable.MaterialSearchBar_mt_placeholder);
        this.textColor = array.getColor(R.styleable.MaterialSearchBar_mt_textColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarTextColor));
        this.hintColor = array.getColor(R.styleable.MaterialSearchBar_mt_hintColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarHintColor));
        this.placeholderColor = array.getColor(R.styleable.MaterialSearchBar_mt_placeholderColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarPlaceholderColor));
        this.textCursorColor = array.getColor(R.styleable.MaterialSearchBar_mt_textCursorTint, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarCursorColor));
        this.highlightedTextColor = array.getColor(R.styleable.MaterialSearchBar_mt_highlightedTextColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.searchBarTextHighlightColor));
        this.destiny = this.getResources().getDisplayMetrics().density;
        if (this.adapter == null) {
            this.adapter = new DefaultSuggestionsAdapter(LayoutInflater.from((Context)this.getContext()));
        }
        if (this.adapter instanceof DefaultSuggestionsAdapter) {
            ((DefaultSuggestionsAdapter)this.adapter).setListener(this);
        }
        this.adapter.setMaxSuggestionsCount(this.maxSuggestionCount);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.mt_recycler);
        recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        array.recycle();
        this.searchBarCardView = (CardView)this.findViewById(R.id.mt_container);
        this.suggestionDivider = this.findViewById(R.id.mt_divider);
        this.menuDivider = this.findViewById(R.id.mt_menu_divider);
        this.menuIcon = (ImageView)this.findViewById(R.id.mt_menu);
        this.clearIcon = (ImageView)this.findViewById(R.id.mt_clear);
        this.searchIcon = (ImageView)this.findViewById(R.id.mt_search);
        this.arrowIcon = (ImageView)this.findViewById(R.id.mt_arrow);
        this.searchEdit = (EditText)this.findViewById(R.id.mt_editText);
        this.placeHolder = (TextView)this.findViewById(R.id.mt_placeholder);
        this.inputContainer = (LinearLayout)this.findViewById(R.id.inputContainer);
        this.navIcon = (ImageView)this.findViewById(R.id.mt_nav);
        this.findViewById(R.id.mt_clear).setOnClickListener((View.OnClickListener)this);
        this.setOnClickListener(this);
        this.arrowIcon.setOnClickListener((View.OnClickListener)this);
        this.searchIcon.setOnClickListener((View.OnClickListener)this);
        this.searchEdit.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.searchEdit.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.navIcon.setOnClickListener((View.OnClickListener)this);
        this.postSetup();
    }

    public void inflateMenu(int menuResource) {
        this.inflateMenuRequest(menuResource, -1);
    }

    public void inflateMenu(int menuResource, int icon) {
        this.inflateMenuRequest(menuResource, icon);
    }

    private void inflateMenuRequest(int menuResource, int iconResId) {
        int menuResource1 = menuResource;
        if (menuResource1 > 0) {
            ImageView menuIcon = (ImageView)this.findViewById(R.id.mt_menu);
            if (iconResId != -1) {
                this.menuIconRes = iconResId;
                menuIcon.setImageResource(this.menuIconRes);
            }
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.searchIcon.getLayoutParams();
            params.rightMargin = (int)(48.0f * this.destiny);
            this.searchIcon.setLayoutParams((ViewGroup.LayoutParams)params);
            menuIcon.setVisibility(0);
            menuIcon.setOnClickListener((View.OnClickListener)this);
            this.popupMenu = new PopupMenu(this.getContext(), (View)menuIcon);
            this.popupMenu.inflate(menuResource);
            this.popupMenu.setGravity(5);
        }
    }

    public PopupMenu getMenu() {
        return this.popupMenu;
    }

    private void postSetup() {
        this.setupTextColors();
        this.setupRoundedSearchBarEnabled();
        this.setupSearchBarColor();
        this.setupIcons();
        this.setupMenuDividerEnabled();
        this.setupSearchEditText();
    }

    private void setupRoundedSearchBarEnabled() {
        if (this.roundedSearchBarEnabled && Build.VERSION.SDK_INT >= 21) {
            this.searchBarCardView.setRadius(this.getResources().getDimension(R.dimen.corner_radius_rounded));
        } else {
            this.searchBarCardView.setRadius(this.getResources().getDimension(R.dimen.corner_radius_default));
        }
    }

    private void setupSearchBarColor() {
        this.searchBarCardView.setCardBackgroundColor(this.searchBarColor);
        this.setupDividerColor();
    }

    private void setupDividerColor() {
        this.suggestionDivider.setBackgroundColor(this.dividerColor);
        this.menuDivider.setBackgroundColor(this.dividerColor);
    }

    private void setupTextColors() {
        this.searchEdit.setHintTextColor(this.hintColor);
        this.searchEdit.setTextColor(this.textColor);
        this.placeHolder.setTextColor(this.placeholderColor);
    }

    private void setupSearchEditText() {
        this.setupCursorColor();
        this.searchEdit.setHighlightColor(this.highlightedTextColor);
        if (this.hintText != null) {
            this.searchEdit.setHint(this.hintText);
        }
        if (this.placeholderText != null) {
            this.arrowIcon.setBackground(null);
            this.placeHolder.setText(this.placeholderText);
        }
    }

    private void setupCursorColor() {
        try {
            Field field = TextView.class.getDeclaredField("mEditor");
            field.setAccessible(true);
            Object editor = field.get(this.searchEdit);
            field = TextView.class.getDeclaredField("mCursorDrawableRes");
            field.setAccessible(true);
            int cursorDrawableRes = field.getInt(this.searchEdit);
            Drawable cursorDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)cursorDrawableRes).mutate();
            cursorDrawable.setColorFilter(this.textCursorColor, PorterDuff.Mode.SRC_IN);
            Drawable[] drawables = new Drawable[]{cursorDrawable, cursorDrawable};
            field = editor.getClass().getDeclaredField("mCursorDrawable");
            field.setAccessible(true);
            field.set(editor, drawables);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void setupIcons() {
        this.navIconResId = R.drawable.ic_menu_animated;
        this.navIcon.setImageResource(this.navIconResId);
        this.setNavButtonEnabled(this.navButtonEnabled);
        if (this.popupMenu == null) {
            this.findViewById(R.id.mt_menu).setVisibility(8);
        }
        this.setSpeechMode(this.speechMode);
        this.arrowIcon.setImageResource(this.arrowIconRes);
        this.clearIcon.setImageResource(this.clearIconRes);
        this.setupNavIconTint();
        this.setupMenuIconTint();
        this.setupSearchIconTint();
        this.setupArrowIconTint();
        this.setupClearIconTint();
        this.setupIconRippleStyle();
    }

    private void setupNavIconTint() {
        if (this.navIconTintEnabled) {
            this.navIcon.setColorFilter(this.navIconTint, PorterDuff.Mode.SRC_IN);
        } else {
            this.navIcon.clearColorFilter();
        }
    }

    private void setupMenuIconTint() {
        if (this.menuIconTintEnabled) {
            this.menuIcon.setColorFilter(this.menuIconTint, PorterDuff.Mode.SRC_IN);
        } else {
            this.menuIcon.clearColorFilter();
        }
    }

    private void setupSearchIconTint() {
        if (this.searchIconTintEnabled) {
            this.searchIcon.setColorFilter(this.searchIconTint, PorterDuff.Mode.SRC_IN);
        } else {
            this.searchIcon.clearColorFilter();
        }
    }

    private void setupArrowIconTint() {
        if (this.arrowIconTintEnabled) {
            this.arrowIcon.setColorFilter(this.arrowIconTint, PorterDuff.Mode.SRC_IN);
        } else {
            this.arrowIcon.clearColorFilter();
        }
    }

    private void setupClearIconTint() {
        if (this.clearIconTintEnabled) {
            this.clearIcon.setColorFilter(this.clearIconTint, PorterDuff.Mode.SRC_IN);
        } else {
            this.clearIcon.clearColorFilter();
        }
    }

    private void setupMenuDividerEnabled() {
        if (this.menuDividerEnabled) {
            this.menuDivider.setVisibility(0);
        } else {
            this.menuDivider.setVisibility(8);
        }
    }

    private void setupIconRippleStyle() {
        if (Build.VERSION.SDK_INT > 16) {
            TypedValue rippleStyle = new TypedValue();
            if (this.borderlessRippleEnabled && Build.VERSION.SDK_INT >= 21) {
                this.getContext().getTheme().resolveAttribute(16843868, rippleStyle, true);
            } else {
                this.getContext().getTheme().resolveAttribute(16843534, rippleStyle, true);
            }
            this.navIcon.setBackgroundResource(rippleStyle.resourceId);
            this.searchIcon.setBackgroundResource(rippleStyle.resourceId);
            this.menuIcon.setBackgroundResource(rippleStyle.resourceId);
            this.arrowIcon.setBackgroundResource(rippleStyle.resourceId);
            this.clearIcon.setBackgroundResource(rippleStyle.resourceId);
        } else {
            Log.w((String)"ContentValues", (String)"setupIconRippleStyle() Only Available On SDK Versions Higher Than 16!");
        }
    }

    public void setOnSearchActionListener(OnSearchActionListener onSearchActionListener) {
        this.onSearchActionListener = onSearchActionListener;
    }

    public void disableSearch() {
        this.animateNavIcon();
        this.searchEnabled = false;
        Animation out = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fade_out);
        Animation in = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fade_in_right);
        out.setAnimationListener((Animation.AnimationListener)this);
        this.searchIcon.setVisibility(0);
        this.inputContainer.startAnimation(out);
        this.searchIcon.startAnimation(in);
        if (this.placeholderText != null) {
            this.placeHolder.setVisibility(0);
            this.placeHolder.startAnimation(in);
        }
        if (this.listenerExists()) {
            this.onSearchActionListener.onSearchStateChanged(false);
        }
        if (this.suggestionsVisible) {
            this.animateSuggestions(this.getListHeight(false), 0);
        }
    }

    public void enableSearch() {
        this.animateNavIcon();
        this.adapter.notifyDataSetChanged();
        this.searchEnabled = true;
        Animation left_in = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fade_in_left);
        Animation left_out = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fade_out_left);
        left_in.setAnimationListener((Animation.AnimationListener)this);
        this.placeHolder.setVisibility(8);
        this.inputContainer.setVisibility(0);
        this.inputContainer.startAnimation(left_in);
        if (this.listenerExists()) {
            this.onSearchActionListener.onSearchStateChanged(true);
        }
        this.searchIcon.startAnimation(left_out);
    }

    private void animateNavIcon() {
        if (this.navIconShown) {
            this.navIcon.setImageResource(R.drawable.ic_menu_animated);
        } else {
            this.navIcon.setImageResource(R.drawable.ic_back_animated);
        }
        Drawable mDrawable = this.navIcon.getDrawable();
        if (mDrawable instanceof Animatable) {
            ((Animatable)mDrawable).start();
        }
        this.navIconShown = !this.navIconShown;
    }

    private void animateSuggestions(int from, int to) {
        this.suggestionsVisible = to > 0;
        final RelativeLayout last = (RelativeLayout)this.findViewById(R.id.last);
        final ViewGroup.LayoutParams lp = last.getLayoutParams();
        if (to == 0 && lp.height == 0) {
            return;
        }
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{from, to});
        animator.setDuration(200L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                lp.height = (Integer)animation.getAnimatedValue();
                last.setLayoutParams(lp);
            }
        });
        if (this.adapter.getItemCount() > 0) {
            animator.start();
        }
    }

    public void showSuggestionsList() {
        this.animateSuggestions(0, this.getListHeight(false));
    }

    public void hideSuggestionsList() {
        this.animateSuggestions(this.getListHeight(false), 0);
    }

    public void clearSuggestions() {
        if (this.suggestionsVisible) {
            this.animateSuggestions(this.getListHeight(false), 0);
        }
        this.adapter.clearSuggestions();
    }

    public boolean isSuggestionsVisible() {
        return this.suggestionsVisible;
    }

    public void setMenuIcon(int menuIconResId) {
        this.menuIconRes = menuIconResId;
        this.menuIcon.setImageResource(this.menuIconRes);
    }

    public void setSearchIcon(int searchIconResId) {
        this.searchIconRes = searchIconResId;
        this.searchIcon.setImageResource(searchIconResId);
    }

    public void setArrowIcon(int arrowIconResId) {
        this.arrowIconRes = arrowIconResId;
        this.arrowIcon.setImageResource(this.arrowIconRes);
    }

    public void setClearIcon(int clearIconResId) {
        this.clearIconRes = clearIconResId;
        this.clearIcon.setImageResource(this.clearIconRes);
    }

    public void setNavIconTint(int navIconTint) {
        this.navIconTint = navIconTint;
        this.setupNavIconTint();
    }

    public void setMenuIconTint(int menuIconTint) {
        this.menuIconTint = menuIconTint;
        this.setupMenuIconTint();
    }

    public void setSearchIconTint(int searchIconTint) {
        this.searchIconTint = searchIconTint;
        this.setupSearchIconTint();
    }

    public void setArrowIconTint(int arrowIconTint) {
        this.arrowIconTint = arrowIconTint;
        this.setupArrowIconTint();
    }

    public void setClearIconTint(int clearIconTint) {
        this.clearIconTint = clearIconTint;
        this.setupClearIconTint();
    }

    public void setIconRippleStyle(boolean borderlessRippleEnabled) {
        this.borderlessRippleEnabled = borderlessRippleEnabled;
        this.setupIconRippleStyle();
    }

    public void setHint(CharSequence hintText) {
        this.hintText = hintText;
        this.searchEdit.setHint(hintText);
    }

    public CharSequence getPlaceHolderText() {
        return this.placeHolder.getText();
    }

    public void setMenuDividerEnabled(boolean menuDividerEnabled) {
        this.menuDividerEnabled = menuDividerEnabled;
        this.setupMenuDividerEnabled();
    }

    public void setSpeechMode(boolean speechMode) {
        this.speechMode = speechMode;
        if (speechMode) {
            this.searchIcon.setImageResource(this.speechIconRes);
            this.searchIcon.setClickable(true);
        } else {
            this.searchIcon.setImageResource(this.searchIconRes);
            this.searchIcon.setClickable(false);
        }
    }

    public boolean isSpeechModeEnabled() {
        return this.speechMode;
    }

    public boolean isSearchEnabled() {
        return this.searchEnabled;
    }

    public void setMaxSuggestionCount(int maxSuggestionsCount) {
        this.maxSuggestionCount = maxSuggestionsCount;
        this.adapter.setMaxSuggestionsCount(maxSuggestionsCount);
    }

    public void setCustomSuggestionAdapter(SuggestionsAdapter suggestionAdapter) {
        this.adapter = suggestionAdapter;
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.mt_recycler);
        recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    public List getLastSuggestions() {
        return this.adapter.getSuggestions();
    }

    public void setLastSuggestions(List suggestions) {
        this.adapter.setSuggestions(suggestions);
    }

    public void updateLastSuggestions(List suggestions) {
        int startHeight = this.getListHeight(false);
        if (suggestions.size() > 0) {
            ArrayList newSuggestions = new ArrayList(suggestions);
            this.adapter.setSuggestions(newSuggestions);
            this.animateSuggestions(startHeight, this.getListHeight(false));
        } else {
            this.animateSuggestions(startHeight, 0);
        }
    }

    public void setSuggestionsClickListener(SuggestionsAdapter.OnItemViewClickListener listener) {
        if (this.adapter instanceof DefaultSuggestionsAdapter) {
            ((DefaultSuggestionsAdapter)this.adapter).setListener(listener);
        }
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.setupTextColors();
    }

    public void setTextHintColor(int hintColor) {
        this.hintColor = hintColor;
        this.setupTextColors();
    }

    public void setPlaceHolderColor(int placeholderColor) {
        this.placeholderColor = placeholderColor;
        this.setupTextColors();
    }

    public void setTextHighlightColor(int highlightedTextColor) {
        this.highlightedTextColor = highlightedTextColor;
        this.searchEdit.setHighlightColor(highlightedTextColor);
    }

    public void setDividerColor(int dividerColor) {
        this.dividerColor = dividerColor;
        this.setupDividerColor();
    }

    public void setNavButtonEnabled(boolean navButtonEnabled) {
        this.navButtonEnabled = navButtonEnabled;
        if (navButtonEnabled) {
            this.navIcon.setVisibility(0);
            this.navIcon.setClickable(true);
            this.navIcon.getLayoutParams().width = (int)(50.0f * this.destiny);
            ((RelativeLayout.LayoutParams)this.inputContainer.getLayoutParams()).leftMargin = (int)(50.0f * this.destiny);
            this.arrowIcon.setVisibility(8);
        } else {
            this.navIcon.getLayoutParams().width = 1;
            this.navIcon.setVisibility(4);
            this.navIcon.setClickable(false);
            ((RelativeLayout.LayoutParams)this.inputContainer.getLayoutParams()).leftMargin = (int)(0.0f * this.destiny);
            this.arrowIcon.setVisibility(0);
        }
        this.navIcon.requestLayout();
        this.placeHolder.requestLayout();
        this.arrowIcon.requestLayout();
    }

    public void setRoundedSearchBarEnabled(boolean roundedSearchBarEnabled) {
        this.roundedSearchBarEnabled = roundedSearchBarEnabled;
        this.setupRoundedSearchBarEnabled();
    }

    public void setCardViewElevation(int elevation) {
        CardView cardView = (CardView)this.findViewById(R.id.mt_container);
        cardView.setCardElevation((float)elevation);
    }

    public String getText() {
        return this.searchEdit.getText().toString();
    }

    public void setText(String text) {
        this.searchEdit.setText((CharSequence)text);
    }

    public void addTextChangeListener(TextWatcher textWatcher) {
        this.searchEdit.addTextChangedListener(textWatcher);
    }

    public EditText getSearchEditText() {
        return this.searchEdit;
    }

    public TextView getPlaceHolderView() {
        return this.placeHolder;
    }

    public void setPlaceHolder(CharSequence placeholder) {
        this.placeholderText = placeholder;
        this.placeHolder.setText(placeholder);
    }

    private boolean listenerExists() {
        return this.onSearchActionListener != null;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == this.getId()) {
            if (!this.searchEnabled) {
                this.enableSearch();
            }
        } else if (id2 == R.id.mt_arrow) {
            this.disableSearch();
        } else if (id2 == R.id.mt_search) {
            if (this.listenerExists()) {
                this.onSearchActionListener.onButtonClicked(1);
            }
        } else if (id2 == R.id.mt_clear) {
            this.searchEdit.setText((CharSequence)"");
        } else if (id2 == R.id.mt_menu) {
            this.popupMenu.show();
        } else if (id2 == R.id.mt_nav && this.listenerExists()) {
            if (this.navIconShown) {
                this.onSearchActionListener.onButtonClicked(2);
            } else {
                this.onSearchActionListener.onButtonClicked(3);
            }
        }
    }

    public void onAnimationStart(Animation animation) {
    }

    public void onAnimationEnd(Animation animation) {
        if (!this.searchEnabled) {
            this.inputContainer.setVisibility(8);
            this.searchEdit.setText((CharSequence)"");
        } else {
            this.searchIcon.setVisibility(8);
            this.searchEdit.requestFocus();
            if (!this.suggestionsVisible) {
                this.showSuggestionsList();
            }
        }
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onFocusChange(View v, boolean hasFocus) {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (hasFocus) {
            imm.showSoftInput(v, 1);
        } else {
            imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
        }
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (this.listenerExists()) {
            this.onSearchActionListener.onSearchConfirmed((CharSequence)this.searchEdit.getText());
        }
        if (this.suggestionsVisible) {
            this.hideSuggestionsList();
        }
        if (this.adapter instanceof DefaultSuggestionsAdapter) {
            this.adapter.addSuggestion(this.searchEdit.getText().toString());
        }
        return true;
    }

    private int getListHeight(boolean isSubtraction) {
        if (!isSubtraction) {
            return (int)((float)this.adapter.getListHeight() * this.destiny);
        }
        return (int)((float)((this.adapter.getItemCount() - 1) * this.adapter.getSingleViewHeight()) * this.destiny);
    }

    @Override
    public void OnItemClickListener(int position, View v) {
        if (v.getTag() instanceof String) {
            this.searchEdit.setText((CharSequence)((String)v.getTag()));
        }
    }

    @Override
    public void OnItemDeleteListener(int position, View v) {
        if (v.getTag() instanceof String) {
            this.animateSuggestions(this.getListHeight(false), this.getListHeight(true));
            this.adapter.deleteSuggestion(position, v.getTag());
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.isSearchBarVisible = this.searchEnabled ? 1 : 0;
        savedState.suggestionsVisible = this.suggestionsVisible ? 1 : 0;
        savedState.speechMode = this.speechMode ? 1 : 0;
        savedState.navIconResId = this.navIconResId;
        savedState.searchIconRes = this.searchIconRes;
        savedState.suggestions = this.getLastSuggestions();
        savedState.maxSuggestions = this.maxSuggestionCount;
        if (this.hintText != null) {
            savedState.hint = this.hintText.toString();
        }
        return savedState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.searchEnabled = savedState.isSearchBarVisible == 1;
        this.suggestionsVisible = savedState.suggestionsVisible == 1;
        this.setLastSuggestions(savedState.suggestions);
        if (this.suggestionsVisible) {
            this.animateSuggestions(0, this.getListHeight(false));
        }
        if (this.searchEnabled) {
            this.inputContainer.setVisibility(0);
            this.placeHolder.setVisibility(8);
            this.searchIcon.setVisibility(8);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 4 && this.searchEnabled) {
            this.animateSuggestions(this.getListHeight(false), 0);
            this.disableSearch();
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel source) {
                return new SavedState(source);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        private int isSearchBarVisible;
        private int suggestionsVisible;
        private int speechMode;
        private int searchIconRes;
        private int navIconResId;
        private String hint;
        private List suggestions;
        private int maxSuggestions;

        public SavedState(Parcel source) {
            super(source);
            this.isSearchBarVisible = source.readInt();
            this.suggestionsVisible = source.readInt();
            this.speechMode = source.readInt();
            this.navIconResId = source.readInt();
            this.searchIconRes = source.readInt();
            this.hint = source.readString();
            this.suggestions = source.readArrayList(null);
            this.maxSuggestions = source.readInt();
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.isSearchBarVisible);
            out.writeInt(this.suggestionsVisible);
            out.writeInt(this.speechMode);
            out.writeInt(this.searchIconRes);
            out.writeInt(this.navIconResId);
            out.writeString(this.hint);
            out.writeList(this.suggestions);
            out.writeInt(this.maxSuggestions);
        }
    }

    public static interface OnSearchActionListener {
        public void onSearchStateChanged(boolean var1);

        public void onSearchConfirmed(CharSequence var1);

        public void onButtonClicked(int var1);
    }
}

