/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.api;

import com.github.badoualy.telegram.api.OnClientTimeoutListener;
import com.github.badoualy.telegram.api.TelegramClient;
import com.github.badoualy.telegram.mtproto.util.Log;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J,\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0017\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/github/badoualy/telegram/api/TelegramClientPool;", "", "()V", "DEFAULT_EXPIRATION_DELAY", "", "TAG", "", "expireMap", "Ljava/util/HashMap;", "listenerMap", "Lcom/github/badoualy/telegram/api/OnClientTimeoutListener;", "map", "Lcom/github/badoualy/telegram/api/TelegramClient;", "timer", "Ljava/util/Timer;", "cleanUp", "", "getAndRemove", "id", "onTimeout", "put", "client", "listener", "expiresIn", "api-compileKotlin"})
public final class TelegramClientPool {
    private static final String TAG = "TelegramClientPool";
    private static final long DEFAULT_EXPIRATION_DELAY = 300000L;
    private static final HashMap<Long, TelegramClient> map;
    private static final HashMap<Long, OnClientTimeoutListener> listenerMap;
    private static final HashMap<Long, Long> expireMap;
    private static Timer timer;
    public static final TelegramClientPool INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    @JvmOverloads
    public static final void put(long id, @NotNull TelegramClient client, @Nullable OnClientTimeoutListener listener, long expiresIn) {
        Timer lock$iv;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Log.Companion.d$default((Log.Companion)Log.Companion, (String)TAG, (String)("Adding client with id " + id), (int)0, (int)4, null);
        TelegramClientPool telegramClientPool = INSTANCE;
        synchronized (lock$iv) {
            expireMap.put(id, System.currentTimeMillis() + expiresIn);
            if (listener != null) {
                listenerMap.put(id, listener);
            } else {
                listenerMap.remove(id);
            }
            if (map.containsKey(id) && Intrinsics.areEqual((Object)map.get(id), (Object)client) ^ true) {
                client.close(false);
            } else {
                map.put(id, client);
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            void $receiver$iv;
            lock$iv = timer;
            TimerTask task$iv = new TimerTask(id){
                final /* synthetic */ long $id$inlined;

                public void run() {
                    TimerTask $receiver = this;
                    TelegramClientPool.onTimeout(this.$id$inlined);
                }
                {
                    this.$id$inlined = l;
                }
            };
            $receiver$iv.schedule(task$iv, expiresIn);
        }
        catch (IllegalStateException e) {
            void $receiver$iv;
            Timer task$iv = timer = new Timer();
            TimerTask task$iv2 = new TimerTask(id){
                final /* synthetic */ long $id$inlined;

                public void run() {
                    TimerTask $receiver = this;
                    TelegramClientPool.onTimeout(this.$id$inlined);
                }
                {
                    this.$id$inlined = l;
                }
            };
            $receiver$iv.schedule(task$iv2, expiresIn);
        }
    }

    @JvmStatic
    @JvmOverloads
    public static /* bridge */ /* synthetic */ void put$default(long l, TelegramClient telegramClient, OnClientTimeoutListener onClientTimeoutListener, long l2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: put");
        }
        if ((n & 8) != 0) {
            l2 = DEFAULT_EXPIRATION_DELAY;
        }
        TelegramClientPool.put(l, telegramClient, onClientTimeoutListener, l2);
    }

    @JvmStatic
    @JvmOverloads
    public static void put(long id, @NotNull TelegramClient client, @Nullable OnClientTimeoutListener listener) {
        TelegramClientPool.put$default(id, client, listener, 0L, 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final TelegramClient getAndRemove(long id) {
        TelegramClientPool lock$iv = INSTANCE;
        synchronized (lock$iv) {
            expireMap.remove(id);
            TelegramClient telegramClient = map.remove(id);
            return telegramClient;
        }
    }

    @JvmStatic
    public static final void cleanUp() {
        timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void onTimeout(long id) {
        boolean bl;
        TelegramClientPool lock$iv = INSTANCE;
        synchronized (lock$iv) {
            boolean bl2;
            if (Intrinsics.compare((long)((Number)expireMap.getOrDefault(id, 0L)).longValue(), (long)System.currentTimeMillis()) <= 0) {
                Log.Companion.d$default((Log.Companion)Log.Companion, (String)TAG, (String)(id + " client timeout"), (int)0, (int)4, null);
                TelegramClient client = TelegramClientPool.getAndRemove(id);
                if (client != null) {
                    client.close(false);
                    bl2 = true;
                } else {
                    bl2 = false;
                }
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        boolean timeout = bl;
        if (timeout) {
            Unit unit;
            OnClientTimeoutListener onClientTimeoutListener = listenerMap.remove(id);
            if (onClientTimeoutListener != null) {
                onClientTimeoutListener.onClientTimeout(id);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
        }
    }

    private TelegramClientPool() {
        INSTANCE = this;
        TAG = TAG;
        DEFAULT_EXPIRATION_DELAY = 5L * 60L * 1000L;
        map = new HashMap();
        listenerMap = new HashMap();
        expireMap = new HashMap();
        timer = new Timer();
    }

    static {
        new TelegramClientPool();
    }
}

