/*
 * Decompiled with CFR 0.152.
 */
package in.mayanknagwanshi.imagepicker.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import in.mayanknagwanshi.imagepicker.R;

public class ImageCropView
extends AppCompatImageView {
    private Paint paint;
    private Bitmap bitmapGrid;
    private int maxHeight = 0;
    private int maxWidth = 0;
    private Rect rectCropGrid;
    private int sideLengthRect = 0;
    private int downTouchX = 0;
    private int downTouchY = 0;
    private int downTouchToMoveX = 0;
    private int downTouchToMoveY = 0;
    private int rectLeft = 0;
    private int rectTop = 0;
    private boolean isImageSet = false;

    public ImageCropView(@NonNull Context context) {
        this(context, null);
    }

    public ImageCropView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageCropView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.bitmapGrid = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.frame);
        this.paint = new Paint();
        this.paint.setAlpha(255);
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.getDrawable() == null) {
            return;
        }
        if (!this.isImageSet) {
            this.initCalc();
            this.isImageSet = true;
        }
        this.drawCropper(canvas);
    }

    private void drawCropper(Canvas canvas) {
        if (this.sideLengthRect == 0) {
            this.sideLengthRect = Math.min(this.maxWidth, this.maxHeight) / 2;
        }
        if (this.rectCropGrid == null) {
            this.rectCropGrid = new Rect(this.rectLeft, this.rectTop, this.sideLengthRect, this.sideLengthRect);
        }
        canvas.drawBitmap(this.bitmapGrid, null, this.rectCropGrid, this.paint);
    }

    private void initCalc() {
        this.maxHeight = this.getMeasuredHeight();
        this.maxWidth = this.getMeasuredWidth();
        if (this.getDrawable().getIntrinsicHeight() / this.getDrawable().getIntrinsicWidth() > this.maxHeight / this.maxWidth) {
            this.maxWidth = (int)((double)this.maxHeight * 1.0 / (double)this.getDrawable().getIntrinsicHeight() * (double)this.getDrawable().getIntrinsicWidth());
        }
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.isImageSet = false;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.rectCropGrid == null) {
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                int eventX = (int)event.getX();
                int eventY = (int)event.getY();
                if (this.getCornerPaddedRect(this.rectCropGrid.right, this.rectCropGrid.bottom).contains(eventX, eventY)) {
                    this.downTouchToMoveX = eventX;
                    this.downTouchToMoveY = eventY;
                    break;
                }
                if (this.rectCropGrid.contains(eventX, eventY)) {
                    this.downTouchX = eventX;
                    this.downTouchY = eventY;
                    break;
                }
                this.downTouchX = 0;
                this.downTouchY = 0;
                this.downTouchToMoveX = 0;
                this.downTouchToMoveY = 0;
                break;
            }
            case 2: {
                int moveY;
                int displacementY;
                int displacementX;
                int moveX;
                if (this.downTouchToMoveX != 0 && this.downTouchToMoveY != 0) {
                    moveX = (int)event.getX();
                    displacementX = moveX - this.downTouchToMoveX;
                    int displacement = Math.max(displacementX, displacementY = (moveY = (int)event.getY()) - this.downTouchToMoveY);
                    if (this.rectLeft + displacement + this.sideLengthRect <= this.maxWidth && this.rectTop + displacement + this.sideLengthRect <= this.maxHeight && this.sideLengthRect + displacement < Math.min(this.maxWidth, this.maxHeight) && this.sideLengthRect + displacement > Math.min(this.maxWidth, this.maxHeight) / 4) {
                        this.sideLengthRect += displacement;
                        this.rectCropGrid.set(this.rectLeft, this.rectTop, this.sideLengthRect + this.rectLeft, this.sideLengthRect + this.rectTop);
                    }
                    this.downTouchToMoveX = (int)event.getX();
                    this.downTouchToMoveY = (int)event.getY();
                    this.invalidate();
                }
                if (this.downTouchX == 0 && this.downTouchY == 0) break;
                moveX = (int)event.getX();
                moveY = (int)event.getY();
                displacementX = moveX - this.downTouchX;
                displacementY = moveY - this.downTouchY;
                if (this.rectLeft + displacementX + this.sideLengthRect <= this.maxWidth && this.rectLeft + displacementX >= 0 && this.rectTop + displacementY + this.sideLengthRect <= this.maxHeight && this.rectTop + displacementY >= 0) {
                    this.rectTop += displacementY;
                    this.rectLeft += displacementX;
                    this.rectCropGrid.set(this.rectLeft, this.rectTop, this.sideLengthRect + this.rectLeft, this.sideLengthRect + this.rectTop);
                    this.downTouchX = (int)event.getX();
                    this.downTouchY = (int)event.getY();
                }
                this.invalidate();
                break;
            }
            case 1: {
                this.downTouchX = 0;
                this.downTouchY = 0;
                this.downTouchToMoveX = 0;
                this.downTouchToMoveY = 0;
            }
        }
        return true;
    }

    private Rect getCornerPaddedRect(int x, int y) {
        int paddingRadius = this.sideLengthRect / 10;
        return new Rect(x - paddingRadius, y - paddingRadius, x + paddingRadius, y + paddingRadius);
    }

    public CroppedCoordinate getCroppedGrid() {
        double scaleFactor = (double)this.getDrawable().getIntrinsicWidth() * 1.0 / (double)this.maxWidth;
        return new CroppedCoordinate((int)((double)this.rectCropGrid.left * scaleFactor), (int)((double)this.rectCropGrid.top * scaleFactor), (int)((double)this.sideLengthRect * scaleFactor));
    }

    public static class CroppedCoordinate {
        int x;
        int y;
        int side;

        public CroppedCoordinate(int x, int y, int side) {
            this.x = x;
            this.y = y;
            this.side = side;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getSide() {
            return this.side;
        }
    }
}

