/*
 * Decompiled with CFR 0.152.
 */
package in.mayanknagwanshi.imagepicker.imageCompression;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.os.AsyncTask;
import androidx.exifinterface.media.ExifInterface;
import in.mayanknagwanshi.imagepicker.imageCompression.ImageCompressionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageCompression
extends AsyncTask<Void, Void, String> {
    private final String filePath;
    private final ImageCompressionListener imageCompressionListener;
    @SuppressLint(value={"StaticFieldLeak"})
    private final Context context;
    private static final float maxHeight = 1280.0f;
    private static final float maxWidth = 1280.0f;

    public ImageCompression(Context context, String filePath, ImageCompressionListener imageCompressionListener) {
        this.context = context;
        this.filePath = filePath;
        this.imageCompressionListener = imageCompressionListener;
    }

    protected void onPreExecute() {
        super.onPreExecute();
    }

    protected String doInBackground(Void ... strings) {
        return this.compressImage(this.filePath);
    }

    protected void onPostExecute(String imagePath) {
        this.imageCompressionListener.onCompressed(imagePath);
    }

    private String compressImage(String imagePath) {
        Bitmap scaledBitmap = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap bmp = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        int actualHeight = options.outHeight;
        int actualWidth = options.outWidth;
        float imgRatio = (float)actualWidth / (float)actualHeight;
        float maxRatio = 1.0f;
        if ((float)actualHeight > 1280.0f || (float)actualWidth > 1280.0f) {
            if (imgRatio < maxRatio) {
                imgRatio = 1280.0f / (float)actualHeight;
                actualWidth = (int)(imgRatio * (float)actualWidth);
                actualHeight = 1280;
            } else if (imgRatio > maxRatio) {
                imgRatio = 1280.0f / (float)actualWidth;
                actualHeight = (int)(imgRatio * (float)actualHeight);
                actualWidth = 1280;
            } else {
                actualHeight = 1280;
                actualWidth = 1280;
            }
        }
        options.inSampleSize = ImageCompression.calculateInSampleSize(options, actualWidth, actualHeight);
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[16384];
        try {
            bmp = BitmapFactory.decodeFile((String)imagePath, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        try {
            scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        float ratioX = (float)actualWidth / (float)options.outWidth;
        float ratioY = (float)actualHeight / (float)options.outHeight;
        float middleX = (float)actualWidth / 2.0f;
        float middleY = (float)actualHeight / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(bmp, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
        bmp.recycle();
        try {
            ExifInterface exif = new ExifInterface(imagePath);
            int orientation = exif.getAttributeInt("Orientation", 0);
            Matrix matrix = new Matrix();
            switch (orientation) {
                case 6: {
                    matrix.postRotate(90.0f);
                    break;
                }
                case 3: {
                    matrix.postRotate(180.0f);
                    break;
                }
                case 8: {
                    matrix.postRotate(270.0f);
                }
            }
            scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String filepath = this.getFilename();
        try {
            FileOutputStream out = new FileOutputStream(filepath);
            scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return filepath;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int heightRatio = Math.round((float)height / (float)reqHeight);
            int widthRatio = Math.round((float)width / (float)reqWidth);
            inSampleSize = Math.min(heightRatio, widthRatio);
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    private String getFilename() {
        File mediaStorageDir = new File(this.context.getExternalFilesDir(""), "compressed");
        if (!mediaStorageDir.exists()) {
            mediaStorageDir.mkdirs();
        }
        String mImageName = "IMG_" + String.valueOf(System.currentTimeMillis()) + ".png";
        return mediaStorageDir.getAbsolutePath() + "/" + mImageName;
    }
}

