/*
 * Decompiled with CFR 0.152.
 */
package in.mayanknagwanshi.imagepicker;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import in.mayanknagwanshi.imagepicker.ImageCropActivity;
import in.mayanknagwanshi.imagepicker.R;
import in.mayanknagwanshi.imagepicker.imageCompression.ImageCompression;
import in.mayanknagwanshi.imagepicker.imageCompression.ImageCompressionListener;
import in.mayanknagwanshi.imagepicker.imagePicker.ImagePickerUtil;

public class ImageSelectActivity
extends AppCompatActivity {
    private static final int EXTERNAL_PERMISSION_CODE = 1234;
    public static final int SELECT_IMAGE = 121;
    private ProgressBar progressBar;
    private TextView textViewCamera;
    private TextView textViewGallery;
    private TextView textViewCancel;
    private boolean isCompress = true;
    private boolean isCamera = true;
    private boolean isGallery = true;
    private boolean isCrop = false;
    public static final String FLAG_COMPRESS = "flag_compress";
    public static final String FLAG_CAMERA = "flag_camera";
    public static final String FLAG_GALLERY = "flag_gallery";
    public static final String FLAG_CROP = "flag_crop";
    public static final String RESULT_FILE_PATH = "result_file_path";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.supportRequestWindowFeature(1);
        this.setContentView(R.layout.activity_image_select);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.textViewCamera = (TextView)this.findViewById(R.id.textViewCamera);
        this.textViewGallery = (TextView)this.findViewById(R.id.textViewGallery);
        this.textViewCancel = (TextView)this.findViewById(R.id.textViewCancel);
        this.textViewCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageSelectActivity.this.setResult(0);
                ImageSelectActivity.this.finish();
            }
        });
        this.textViewCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageSelectActivity.this.checkPermission()) {
                    ImageSelectActivity.this.toggleProgress(true);
                    ImageSelectActivity.this.startActivityForResult(ImagePickerUtil.getPickImageChooserIntent((Context)ImageSelectActivity.this, true, false), 121);
                } else {
                    ImageSelectActivity.this.requestStoragePermission();
                }
            }
        });
        this.textViewGallery.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ImageSelectActivity.this.checkPermission()) {
                    ImageSelectActivity.this.toggleProgress(true);
                    ImageSelectActivity.this.startActivityForResult(ImagePickerUtil.getPickImageChooserIntent((Context)ImageSelectActivity.this, false, true), 121);
                } else {
                    ImageSelectActivity.this.requestStoragePermission();
                }
            }
        });
        if (this.getIntent() != null) {
            this.isCompress = this.getIntent().getBooleanExtra(FLAG_COMPRESS, true);
            this.isCamera = this.getIntent().getBooleanExtra(FLAG_CAMERA, true);
            this.isGallery = this.getIntent().getBooleanExtra(FLAG_GALLERY, true);
            this.isCrop = this.getIntent().getBooleanExtra(FLAG_CROP, false);
        }
        if (this.isCamera && this.isGallery) {
            this.toggleProgress(false);
        } else {
            this.toggleProgress(true);
        }
        if (!(!this.checkPermission() || this.isCamera && this.isGallery)) {
            this.startActivityForResult(ImagePickerUtil.getPickImageChooserIntent((Context)this, this.isCompress, this.isGallery), 121);
        } else {
            this.requestStoragePermission();
        }
    }

    @TargetApi(value=16)
    private boolean checkPermission() {
        int currentAPIVersion = Build.VERSION.SDK_INT;
        return currentAPIVersion < 23 || ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0 && ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == 0;
    }

    private void requestStoragePermission() {
        ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"}, (int)1234);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1234) {
            if (grantResults.length == 2 && grantResults[0] == 0) {
                if (!this.isCamera || !this.isGallery) {
                    this.startActivityForResult(ImagePickerUtil.getPickImageChooserIntent((Context)this, this.isCompress, this.isGallery), 121);
                }
            } else {
                this.setResult(0);
                this.finish();
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 121) {
            if (resultCode == -1) {
                this.sendResult(data);
            } else {
                this.setResult(0);
                this.finish();
            }
        }
    }

    private void sendResult(final Intent data) {
        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

            @Override
            public void run() {
                String filePath = ImagePickerUtil.getImageFilePath((Context)ImageSelectActivity.this, data);
                if (filePath != null && !ImageSelectActivity.this.isCompress) {
                    ImageSelectActivity.this.sendResult(filePath);
                    return;
                }
                new ImageCompression((Context)ImageSelectActivity.this, filePath, new ImageCompressionListener(){

                    @Override
                    public void onCompressed(String filePath) {
                        if (filePath != null && ImageSelectActivity.this.isCompress) {
                            ImageSelectActivity.this.sendResult(filePath);
                        }
                    }
                }).execute(new Void[0]);
            }
        }, 1000L);
    }

    private void sendResult(String filePath) {
        if (!this.isCrop) {
            Intent intent = new Intent();
            intent.putExtra(RESULT_FILE_PATH, filePath);
            this.setResult(-1, intent);
            this.finish();
        } else {
            ImageCropActivity.startActivity((Activity)this, filePath);
        }
    }

    private void toggleProgress(boolean showProgress) {
        this.progressBar.setVisibility(showProgress ? 0 : 8);
        this.textViewCamera.setVisibility(showProgress ? 8 : 0);
        this.textViewGallery.setVisibility(showProgress ? 8 : 0);
        this.textViewCancel.setVisibility(showProgress ? 8 : 0);
    }

    public static void startImageSelectionForResult(Activity activity, boolean isCamera, boolean isGallery, boolean isCompress, boolean isCrop, int requestCode) {
        Intent intent = new Intent((Context)activity, ImageSelectActivity.class);
        intent.putExtra(FLAG_COMPRESS, isCamera);
        intent.putExtra(FLAG_CAMERA, isGallery);
        intent.putExtra(FLAG_GALLERY, isCompress);
        intent.putExtra(FLAG_CROP, isCrop);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void startImageSelectionForResult(Fragment fragment, boolean isCamera, boolean isGallery, boolean isCompress, boolean isCrop, int requestCode) {
        Intent intent = new Intent(fragment.getContext(), ImageSelectActivity.class);
        intent.putExtra(FLAG_COMPRESS, isCamera);
        intent.putExtra(FLAG_CAMERA, isGallery);
        intent.putExtra(FLAG_GALLERY, isCompress);
        intent.putExtra(FLAG_CROP, isCrop);
        fragment.startActivityForResult(intent, requestCode);
    }
}

