/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.Indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Path;
import android.graphics.Shader;
import com.tools.speedlib.views.components.Indicators.Indicator;

public class TriangleIndicator
extends Indicator<TriangleIndicator> {
    private Path indicatorPath = new Path();

    public TriangleIndicator(Context context) {
        super(context);
        this.updateIndicator();
    }

    @Override
    protected float getDefaultIndicatorWidth() {
        return this.dpTOpx(25.0f);
    }

    @Override
    public void draw(Canvas canvas, float degree) {
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.indicatorPaint);
        canvas.restore();
    }

    @Override
    protected void updateIndicator() {
        this.indicatorPath = new Path();
        float indicatorH = (float)this.getPadding() + this.getSpeedometerWidth() + this.dpTOpx(5.0f);
        this.indicatorPath.moveTo(this.getCenterX(), indicatorH);
        this.indicatorPath.lineTo(this.getCenterX() - this.getIndicatorWidth(), indicatorH + this.getIndicatorWidth());
        this.indicatorPath.lineTo(this.getCenterX() + this.getIndicatorWidth(), indicatorH + this.getIndicatorWidth());
        this.indicatorPath.moveTo(0.0f, 0.0f);
        int endColor = Color.argb((int)0, (int)Color.red((int)this.getIndicatorColor()), (int)Color.green((int)this.getIndicatorColor()), (int)Color.blue((int)this.getIndicatorColor()));
        LinearGradient linearGradient = new LinearGradient(this.getCenterX(), indicatorH, this.getCenterX(), indicatorH + this.getIndicatorWidth(), this.getIndicatorColor(), endColor, Shader.TileMode.CLAMP);
        this.indicatorPaint.setShader((Shader)linearGradient);
    }

    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects && !this.isInEditMode()) {
            this.indicatorPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
        } else {
            this.indicatorPaint.setMaskFilter(null);
        }
    }
}

