/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views.components.Indicators;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Path;
import com.tools.speedlib.views.components.Indicators.Indicator;

public class SpindleIndicator
extends Indicator<SpindleIndicator> {
    private Path indicatorPath = new Path();

    public SpindleIndicator(Context context) {
        super(context);
        this.updateIndicator();
    }

    @Override
    protected float getDefaultIndicatorWidth() {
        return this.dpTOpx(16.0f);
    }

    @Override
    public void draw(Canvas canvas, float degree) {
        canvas.save();
        canvas.rotate(90.0f + degree, this.getCenterX(), this.getCenterY());
        canvas.drawPath(this.indicatorPath, this.indicatorPaint);
        canvas.restore();
    }

    @Override
    protected void updateIndicator() {
        this.indicatorPath.reset();
        this.indicatorPath.moveTo(this.getCenterX(), this.getCenterY());
        this.indicatorPath.quadTo(this.getCenterX() - this.getIndicatorWidth(), this.getViewSize() * 0.34f + (float)this.getPadding(), this.getCenterX(), this.getViewSize() * 0.18f + (float)this.getPadding());
        this.indicatorPath.quadTo(this.getCenterX() + this.getIndicatorWidth(), this.getViewSize() * 0.34f + (float)this.getPadding(), this.getCenterX(), this.getCenterY());
        this.indicatorPaint.setColor(this.getIndicatorColor());
    }

    @Override
    protected void setWithEffects(boolean withEffects) {
        if (withEffects && !this.isInEditMode()) {
            this.indicatorPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(15.0f, BlurMaskFilter.Blur.SOLID));
        } else {
            this.indicatorPaint.setMaskFilter(null);
        }
    }
}

