/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Typeface;
import android.util.AttributeSet;
import com.tools.speedlib.R;
import com.tools.speedlib.views.base.Speedometer;
import com.tools.speedlib.views.base.SpeedometerDefault;
import com.tools.speedlib.views.components.Indicators.SpindleIndicator;

public class PointerSpeedView
extends Speedometer {
    private Path markPath = new Path();
    private Paint speedometerPaint = new Paint(1);
    private Paint pointerPaint = new Paint(1);
    private Paint pointerBackPaint = new Paint(1);
    private Paint circlePaint = new Paint(1);
    private Paint markPaint = new Paint(1);
    private RectF speedometerRect = new RectF();
    private int speedometerColor = Color.parseColor((String)"#eeeeee");
    private int pointerColor = -1;

    public PointerSpeedView(Context context) {
        this(context, null);
    }

    public PointerSpeedView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PointerSpeedView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
        this.initAttributeSet(context, attrs);
    }

    @Override
    protected void defaultValues() {
        super.setTextColor(-1);
        super.setSpeedTextColor(-1);
        super.setUnitTextColor(-1);
        super.setSpeedTextSize(this.dpTOpx(24.0f));
        super.setUnitTextSize(this.dpTOpx(11.0f));
        super.setSpeedTextTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
    }

    @Override
    protected SpeedometerDefault getSpeedometerDefault() {
        SpeedometerDefault speedometerDefault = new SpeedometerDefault();
        speedometerDefault.indicator = ((SpindleIndicator)new SpindleIndicator(this.getContext()).setIndicatorWidth(this.dpTOpx(16.0f))).setIndicatorColor(-1);
        speedometerDefault.backgroundCircleColor = Color.parseColor((String)"#00bafe");
        speedometerDefault.speedometerWidth = this.dpTOpx(10.0f);
        return speedometerDefault;
    }

    private void init() {
        this.speedometerPaint.setStyle(Paint.Style.STROKE);
        this.speedometerPaint.setStrokeCap(Paint.Cap.ROUND);
        this.markPaint.setStyle(Paint.Style.STROKE);
        this.markPaint.setStrokeCap(Paint.Cap.ROUND);
        this.markPaint.setStrokeWidth(this.dpTOpx(2.0f));
        this.circlePaint.setColor(-1);
    }

    private void initAttributeSet(Context context, AttributeSet attrs) {
        if (attrs == null) {
            this.initAttributeValue();
            return;
        }
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PointerSpeedView, 0, 0);
        this.speedometerColor = a.getColor(R.styleable.PointerSpeedView_sv_speedometerColor, this.speedometerColor);
        this.pointerColor = a.getColor(R.styleable.PointerSpeedView_sv_pointerColor, this.pointerColor);
        this.circlePaint.setColor(a.getColor(R.styleable.PointerSpeedView_sv_centerCircleColor, this.circlePaint.getColor()));
        a.recycle();
        this.initAttributeValue();
    }

    private void initAttributeValue() {
        this.pointerPaint.setColor(this.pointerColor);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        float risk = this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f) + (float)this.getPadding();
        this.speedometerRect.set(risk, risk, (float)this.getSize() - risk, (float)this.getSize() - risk);
        this.updateRadial();
        this.updateBackgroundBitmap();
    }

    private void initDraw() {
        this.speedometerPaint.setStrokeWidth(this.getSpeedometerWidth());
        this.speedometerPaint.setShader((Shader)this.updateSweep());
        this.markPaint.setColor(this.getMarkColor());
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.initDraw();
        canvas.drawArc(this.speedometerRect, (float)this.getStartDegree(), (float)(this.getEndDegree() - this.getStartDegree()), false, this.speedometerPaint);
        canvas.save();
        canvas.rotate(90.0f + this.getDegree(), (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        canvas.drawCircle((float)this.getSize() * 0.5f, this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f) + (float)this.getPadding(), this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f), this.pointerBackPaint);
        canvas.drawCircle((float)this.getSize() * 0.5f, this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f) + (float)this.getPadding(), this.getSpeedometerWidth() * 0.5f + this.dpTOpx(1.0f), this.pointerPaint);
        canvas.restore();
        this.drawSpeedUnitText(canvas);
        this.drawIndicator(canvas);
        int c = this.getCenterCircleColor();
        this.circlePaint.setColor(Color.argb((int)120, (int)Color.red((int)c), (int)Color.green((int)c), (int)Color.blue((int)c)));
        canvas.drawCircle((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, (float)this.getWidthPa() / 14.0f, this.circlePaint);
        this.circlePaint.setColor(c);
        canvas.drawCircle((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, (float)this.getWidthPa() / 22.0f, this.circlePaint);
        this.drawNotes(canvas);
    }

    @Override
    protected void updateBackgroundBitmap() {
        Canvas c = this.createBackgroundBitmapCanvas();
        this.initDraw();
        this.markPath.reset();
        this.markPath.moveTo((float)this.getSize() * 0.5f, this.getSpeedometerWidth() + this.dpTOpx(8.0f) + this.dpTOpx(4.0f) + (float)this.getPadding());
        this.markPath.lineTo((float)this.getSize() * 0.5f, this.getSpeedometerWidth() + this.dpTOpx(8.0f) + this.dpTOpx(4.0f) + (float)this.getPadding() + (float)(this.getSize() / 60));
        c.save();
        c.rotate(90.0f + (float)this.getStartDegree(), (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        float everyDegree = (float)(this.getEndDegree() - this.getStartDegree()) * 0.111f;
        for (float i = (float)this.getStartDegree(); i < (float)this.getEndDegree() - 2.0f * everyDegree; i += everyDegree) {
            c.rotate(everyDegree, (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
            c.drawPath(this.markPath, this.markPaint);
        }
        c.restore();
        this.drawDefMinMaxSpeedPosition(c);
    }

    private SweepGradient updateSweep() {
        int startColor = Color.argb((int)150, (int)Color.red((int)this.speedometerColor), (int)Color.green((int)this.speedometerColor), (int)Color.blue((int)this.speedometerColor));
        int color2 = Color.argb((int)220, (int)Color.red((int)this.speedometerColor), (int)Color.green((int)this.speedometerColor), (int)Color.blue((int)this.speedometerColor));
        int color3 = Color.argb((int)70, (int)Color.red((int)this.speedometerColor), (int)Color.green((int)this.speedometerColor), (int)Color.blue((int)this.speedometerColor));
        int endColor = Color.argb((int)15, (int)Color.red((int)this.speedometerColor), (int)Color.green((int)this.speedometerColor), (int)Color.blue((int)this.speedometerColor));
        float position = this.getOffsetSpeed() * (float)(this.getEndDegree() - this.getStartDegree()) / 360.0f;
        SweepGradient sweepGradient = new SweepGradient((float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f, new int[]{startColor, color2, this.speedometerColor, color3, endColor, startColor}, new float[]{0.0f, position * 0.5f, position, position, 0.99f, 1.0f});
        Matrix matrix = new Matrix();
        matrix.postRotate((float)this.getStartDegree(), (float)this.getSize() * 0.5f, (float)this.getSize() * 0.5f);
        sweepGradient.setLocalMatrix(matrix);
        return sweepGradient;
    }

    private void updateRadial() {
        int centerColor = Color.argb((int)160, (int)Color.red((int)this.pointerColor), (int)Color.green((int)this.pointerColor), (int)Color.blue((int)this.pointerColor));
        int edgeColor = Color.argb((int)10, (int)Color.red((int)this.pointerColor), (int)Color.green((int)this.pointerColor), (int)Color.blue((int)this.pointerColor));
        RadialGradient pointerGradient = new RadialGradient((float)this.getSize() * 0.5f, this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f) + (float)this.getPadding(), this.getSpeedometerWidth() * 0.5f + this.dpTOpx(8.0f), new int[]{centerColor, edgeColor}, new float[]{0.4f, 1.0f}, Shader.TileMode.CLAMP);
        this.pointerBackPaint.setShader((Shader)pointerGradient);
    }

    public int getSpeedometerColor() {
        return this.speedometerColor;
    }

    public void setSpeedometerColor(int speedometerColor) {
        this.speedometerColor = speedometerColor;
        this.invalidate();
    }

    public int getPointerColor() {
        return this.pointerColor;
    }

    public void setPointerColor(int pointerColor) {
        this.pointerColor = pointerColor;
        this.pointerPaint.setColor(pointerColor);
        this.updateRadial();
        this.invalidate();
    }

    public int getCenterCircleColor() {
        return this.circlePaint.getColor();
    }

    public void setCenterCircleColor(int centerCircleColor) {
        this.circlePaint.setColor(centerCircleColor);
        if (!this.isAttachedToWindow()) {
            return;
        }
        this.invalidate();
    }

    @Override
    @Deprecated
    public int getLowSpeedColor() {
        return 0;
    }

    @Override
    @Deprecated
    public void setLowSpeedColor(int lowSpeedColor) {
    }

    @Override
    @Deprecated
    public int getMediumSpeedColor() {
        return 0;
    }

    @Override
    @Deprecated
    public void setMediumSpeedColor(int mediumSpeedColor) {
    }

    @Override
    @Deprecated
    public int getHighSpeedColor() {
        return 0;
    }

    @Override
    @Deprecated
    public void setHighSpeedColor(int highSpeedColor) {
    }
}

