/*
 * Decompiled with CFR 0.152.
 */
package com.tools.speedlib.listener.impl.handler;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.tools.speedlib.listener.impl.UIProgressListener;
import com.tools.speedlib.listener.impl.model.ProgressModel;
import java.lang.ref.WeakReference;

public abstract class ProgressHandler
extends Handler {
    public static final int UPDATE = 1;
    public static final int START = 2;
    public static final int FINISH = 3;
    private final WeakReference<UIProgressListener> mUIProgressListenerWeakReference;

    public ProgressHandler(UIProgressListener uiProgressListener) {
        super(Looper.getMainLooper());
        this.mUIProgressListenerWeakReference = new WeakReference<UIProgressListener>(uiProgressListener);
    }

    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                UIProgressListener uiProgessListener = (UIProgressListener)this.mUIProgressListenerWeakReference.get();
                if (uiProgessListener == null) break;
                ProgressModel progressModel = (ProgressModel)msg.obj;
                this.progress(uiProgessListener, progressModel.getCurrentBytes(), progressModel.getContentLength(), progressModel.isDone());
                break;
            }
            case 2: {
                UIProgressListener uiProgressListener = (UIProgressListener)this.mUIProgressListenerWeakReference.get();
                if (uiProgressListener == null) break;
                ProgressModel progressModel = (ProgressModel)msg.obj;
                this.start(uiProgressListener, progressModel.getCurrentBytes(), progressModel.getContentLength(), progressModel.isDone());
                break;
            }
            case 3: {
                UIProgressListener uiProgressListener = (UIProgressListener)this.mUIProgressListenerWeakReference.get();
                if (uiProgressListener == null) break;
                ProgressModel progressModel = (ProgressModel)msg.obj;
                this.finish(uiProgressListener, progressModel.getCurrentBytes(), progressModel.getContentLength(), progressModel.isDone());
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    public abstract void start(UIProgressListener var1, long var2, long var4, boolean var6);

    public abstract void progress(UIProgressListener var1, long var2, long var4, boolean var6);

    public abstract void finish(UIProgressListener var1, long var2, long var4, boolean var6);
}

