/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.circleprogress;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.res.ResourcesCompat;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.github.lzyzsd.circleprogress.R;
import com.github.lzyzsd.circleprogress.Utils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class ArcProgress
extends View {
    private Paint paint;
    protected Paint textPaint;
    private RectF rectF = new RectF();
    private float strokeWidth;
    private float suffixTextSize;
    private float bottomTextSize;
    private String bottomText;
    private String text;
    private float textSize;
    private int textColor;
    private int currentProgress = 0;
    private float progress = 0.0f;
    private int max;
    private int finishedStrokeColor;
    private int unfinishedStrokeColor;
    private float arcAngle;
    private String suffixText = "%";
    private float suffixTextPadding;
    private Typeface typeFace;
    private int fontResourceId;
    private float arcBottomHeight;
    private final int default_finished_color = -1;
    private final int default_unfinished_color = Color.rgb((int)72, (int)106, (int)176);
    private final int default_text_color = Color.rgb((int)66, (int)145, (int)241);
    private final float default_suffix_text_size;
    private final float default_suffix_padding;
    private final float default_bottom_text_size;
    private final float default_stroke_width;
    private final String default_suffix_text;
    private final int default_max = 100;
    private final float default_arc_angle = 288.0f;
    private float default_text_size = Utils.sp2px(this.getResources(), 18.0f);
    private final int min_size = (int)Utils.dp2px(this.getResources(), 100.0f);
    private static final String INSTANCE_STATE = "saved_instance";
    private static final String INSTANCE_STROKE_WIDTH = "stroke_width";
    private static final String INSTANCE_SUFFIX_TEXT_SIZE = "suffix_text_size";
    private static final String INSTANCE_SUFFIX_TEXT_PADDING = "suffix_text_padding";
    private static final String INSTANCE_BOTTOM_TEXT_SIZE = "bottom_text_size";
    private static final String INSTANCE_BOTTOM_TEXT = "bottom_text";
    private static final String INSTANCE_TEXT_SIZE = "text_size";
    private static final String INSTANCE_TEXT_COLOR = "text_color";
    private static final String INSTANCE_PROGRESS = "progress";
    private static final String INSTANCE_MAX = "max";
    private static final String INSTANCE_FINISHED_STROKE_COLOR = "finished_stroke_color";
    private static final String INSTANCE_UNFINISHED_STROKE_COLOR = "unfinished_stroke_color";
    private static final String INSTANCE_ARC_ANGLE = "arc_angle";
    private static final String INSTANCE_SUFFIX = "suffix";

    public ArcProgress(Context context) {
        this(context, null);
    }

    public ArcProgress(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ArcProgress(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.default_text_size = Utils.sp2px(this.getResources(), 40.0f);
        this.default_suffix_text_size = Utils.sp2px(this.getResources(), 15.0f);
        this.default_suffix_padding = Utils.dp2px(this.getResources(), 4.0f);
        this.default_suffix_text = "%";
        this.default_bottom_text_size = Utils.sp2px(this.getResources(), 10.0f);
        this.default_stroke_width = Utils.dp2px(this.getResources(), 4.0f);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ArcProgress, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
    }

    protected void initByAttributes(TypedArray attributes) {
        this.finishedStrokeColor = attributes.getColor(R.styleable.ArcProgress_arc_finished_color, -1);
        this.unfinishedStrokeColor = attributes.getColor(R.styleable.ArcProgress_arc_unfinished_color, this.default_unfinished_color);
        this.textColor = attributes.getColor(R.styleable.ArcProgress_arc_text_color, this.default_text_color);
        this.textSize = attributes.getDimension(R.styleable.ArcProgress_arc_text_size, this.default_text_size);
        this.arcAngle = attributes.getFloat(R.styleable.ArcProgress_arc_angle, 288.0f);
        this.setMax(attributes.getInt(R.styleable.ArcProgress_arc_max, 100));
        this.setProgress(attributes.getFloat(R.styleable.ArcProgress_arc_progress, 0.0f));
        this.strokeWidth = attributes.getDimension(R.styleable.ArcProgress_arc_stroke_width, this.default_stroke_width);
        this.suffixTextSize = attributes.getDimension(R.styleable.ArcProgress_arc_suffix_text_size, this.default_suffix_text_size);
        this.suffixText = TextUtils.isEmpty((CharSequence)attributes.getString(R.styleable.ArcProgress_arc_suffix_text)) ? this.default_suffix_text : attributes.getString(R.styleable.ArcProgress_arc_suffix_text);
        this.suffixTextPadding = attributes.getDimension(R.styleable.ArcProgress_arc_suffix_text_padding, this.default_suffix_padding);
        this.bottomTextSize = attributes.getDimension(R.styleable.ArcProgress_arc_bottom_text_size, this.default_bottom_text_size);
        this.bottomText = attributes.getString(R.styleable.ArcProgress_arc_bottom_text);
        this.initTypeFace(attributes);
    }

    private void initTypeFace(TypedArray attributes) {
        if (Build.VERSION.SDK_INT < 26) {
            int fontId = attributes.getResourceId(R.styleable.ArcProgress_arc_suffix_text_font, 0);
            if (fontId != 0) {
                try {
                    this.typeFace = ResourcesCompat.getFont((Context)this.getContext(), (int)fontId);
                }
                catch (Exception exception) {}
            }
        } else {
            this.typeFace = attributes.getFont(R.styleable.ArcProgress_arc_suffix_text_font);
        }
    }

    protected void initPainters() {
        this.textPaint = new TextPaint();
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setAntiAlias(true);
        this.paint = new Paint();
        this.paint.setColor(this.default_unfinished_color);
        this.paint.setAntiAlias(true);
        this.paint.setStrokeWidth(this.strokeWidth);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.invalidate();
    }

    public float getSuffixTextSize() {
        return this.suffixTextSize;
    }

    public void setSuffixTextSize(float suffixTextSize) {
        this.suffixTextSize = suffixTextSize;
        this.invalidate();
    }

    public String getBottomText() {
        return this.bottomText;
    }

    public void setBottomText(String bottomText) {
        this.bottomText = bottomText;
        this.invalidate();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        this.progress = Float.parseFloat(new DecimalFormat("#.##", dfs).format(progress));
        if (this.progress > (float)this.getMax()) {
            this.progress %= (float)this.getMax();
        }
        this.currentProgress = 0;
        this.invalidate();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    public float getBottomTextSize() {
        return this.bottomTextSize;
    }

    public void setBottomTextSize(float bottomTextSize) {
        this.bottomTextSize = bottomTextSize;
        this.invalidate();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.invalidate();
    }

    public void setDefaultText() {
        this.text = String.valueOf(this.getProgress());
        this.invalidate();
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public int getFinishedStrokeColor() {
        return this.finishedStrokeColor;
    }

    public void setFinishedStrokeColor(int finishedStrokeColor) {
        this.finishedStrokeColor = finishedStrokeColor;
        this.invalidate();
    }

    public int getUnfinishedStrokeColor() {
        return this.unfinishedStrokeColor;
    }

    public void setUnfinishedStrokeColor(int unfinishedStrokeColor) {
        this.unfinishedStrokeColor = unfinishedStrokeColor;
        this.invalidate();
    }

    public float getArcAngle() {
        return this.arcAngle;
    }

    public void setArcAngle(float arcAngle) {
        this.arcAngle = arcAngle;
        this.invalidate();
    }

    public String getSuffixText() {
        return this.suffixText;
    }

    public void setSuffixText(String suffixText) {
        this.suffixText = suffixText;
        this.invalidate();
    }

    public float getSuffixTextPadding() {
        return this.suffixTextPadding;
    }

    public void setSuffixTextPadding(float suffixTextPadding) {
        this.suffixTextPadding = suffixTextPadding;
        this.invalidate();
    }

    protected int getSuggestedMinimumHeight() {
        return this.min_size;
    }

    protected int getSuggestedMinimumWidth() {
        return this.min_size;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.rectF.set(this.strokeWidth / 2.0f, this.strokeWidth / 2.0f, (float)width - this.strokeWidth / 2.0f, (float)View.MeasureSpec.getSize((int)heightMeasureSpec) - this.strokeWidth / 2.0f);
        float radius = (float)width / 2.0f;
        float angle = (360.0f - this.arcAngle) / 2.0f;
        this.arcBottomHeight = radius * (float)(1.0 - Math.cos((double)(angle / 180.0f) * Math.PI));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float startAngle = 270.0f - this.arcAngle / 2.0f;
        float finishedSweepAngle = (float)this.currentProgress / (float)this.getMax() * this.arcAngle;
        float finishedStartAngle = startAngle;
        if (this.progress == 0.0f) {
            finishedStartAngle = 0.01f;
        }
        this.paint.setColor(this.unfinishedStrokeColor);
        canvas.drawArc(this.rectF, startAngle, this.arcAngle, false, this.paint);
        this.paint.setColor(this.finishedStrokeColor);
        canvas.drawArc(this.rectF, finishedStartAngle, finishedSweepAngle, false, this.paint);
        String text = String.valueOf(this.currentProgress);
        if (this.typeFace != null) {
            this.textPaint.setTypeface(this.typeFace);
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            this.textPaint.setColor(this.textColor);
            this.textPaint.setTextSize(this.textSize);
            float textHeight = this.textPaint.descent() + this.textPaint.ascent();
            float textBaseline = ((float)this.getHeight() - textHeight) / 2.0f;
            canvas.drawText(text, ((float)this.getWidth() - this.textPaint.measureText(text)) / 2.0f, textBaseline, this.textPaint);
            this.textPaint.setTextSize(this.suffixTextSize);
            float suffixHeight = this.textPaint.descent() + this.textPaint.ascent();
            canvas.drawText(this.suffixText, (float)this.getWidth() / 2.0f + this.textPaint.measureText(text) + this.suffixTextPadding, textBaseline + textHeight - suffixHeight, this.textPaint);
        }
        if (this.arcBottomHeight == 0.0f) {
            float radius = (float)this.getWidth() / 2.0f;
            float angle = (360.0f - this.arcAngle) / 2.0f;
            this.arcBottomHeight = radius * (float)(1.0 - Math.cos((double)(angle / 180.0f) * Math.PI));
        }
        if (!TextUtils.isEmpty((CharSequence)this.getBottomText())) {
            this.textPaint.setTextSize(this.bottomTextSize);
            float bottomTextBaseline = (float)this.getHeight() - this.arcBottomHeight - (this.textPaint.descent() + this.textPaint.ascent()) / 2.0f;
            canvas.drawText(this.getBottomText(), ((float)this.getWidth() - this.textPaint.measureText(this.getBottomText())) / 2.0f, bottomTextBaseline, this.textPaint);
        }
        if ((float)this.currentProgress < this.progress) {
            ++this.currentProgress;
            this.invalidate();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putFloat(INSTANCE_STROKE_WIDTH, this.getStrokeWidth());
        bundle.putFloat(INSTANCE_SUFFIX_TEXT_SIZE, this.getSuffixTextSize());
        bundle.putFloat(INSTANCE_SUFFIX_TEXT_PADDING, this.getSuffixTextPadding());
        bundle.putFloat(INSTANCE_BOTTOM_TEXT_SIZE, this.getBottomTextSize());
        bundle.putString(INSTANCE_BOTTOM_TEXT, this.getBottomText());
        bundle.putFloat(INSTANCE_TEXT_SIZE, this.getTextSize());
        bundle.putInt(INSTANCE_TEXT_COLOR, this.getTextColor());
        bundle.putFloat(INSTANCE_PROGRESS, this.getProgress());
        bundle.putInt(INSTANCE_MAX, this.getMax());
        bundle.putInt(INSTANCE_FINISHED_STROKE_COLOR, this.getFinishedStrokeColor());
        bundle.putInt(INSTANCE_UNFINISHED_STROKE_COLOR, this.getUnfinishedStrokeColor());
        bundle.putFloat(INSTANCE_ARC_ANGLE, this.getArcAngle());
        bundle.putString(INSTANCE_SUFFIX, this.getSuffixText());
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.strokeWidth = bundle.getFloat(INSTANCE_STROKE_WIDTH);
            this.suffixTextSize = bundle.getFloat(INSTANCE_SUFFIX_TEXT_SIZE);
            this.suffixTextPadding = bundle.getFloat(INSTANCE_SUFFIX_TEXT_PADDING);
            this.bottomTextSize = bundle.getFloat(INSTANCE_BOTTOM_TEXT_SIZE);
            this.bottomText = bundle.getString(INSTANCE_BOTTOM_TEXT);
            this.textSize = bundle.getFloat(INSTANCE_TEXT_SIZE);
            this.textColor = bundle.getInt(INSTANCE_TEXT_COLOR);
            this.setMax(bundle.getInt(INSTANCE_MAX));
            this.setProgress(bundle.getFloat(INSTANCE_PROGRESS));
            this.finishedStrokeColor = bundle.getInt(INSTANCE_FINISHED_STROKE_COLOR);
            this.unfinishedStrokeColor = bundle.getInt(INSTANCE_UNFINISHED_STROKE_COLOR);
            this.suffixText = bundle.getString(INSTANCE_SUFFIX);
            this.initPainters();
            super.onRestoreInstanceState(bundle.getParcelable(INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }
}

