/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library.helper;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.allen.library.data.AttributeSetData;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\u0018\u0000 X2\u00020\u0001:\u0001XB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\nH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010/\u001a\u0002002\u0006\u0010#\u001a\u00020$2\u0006\u00101\u001a\u000202J\u0010\u00103\u001a\u0002002\b\u00104\u001a\u0004\u0018\u00010$J\u0010\u00105\u001a\u0002002\u0006\u00106\u001a\u00020+H\u0002J\u0010\u00107\u001a\u0002002\u0006\u00106\u001a\u00020+H\u0002J\u0010\u00108\u001a\u0002002\u0006\u00106\u001a\u00020+H\u0002J\u0018\u00109\u001a\u0002002\u0006\u00106\u001a\u00020+2\u0006\u0010,\u001a\u00020\nH\u0002J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0004J\u000e\u0010<\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0004J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0004J\u000e\u0010>\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0004J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\u0004J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010A\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010B\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\nJ\u000e\u0010C\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010D\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010E\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010F\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010G\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010H\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\nJ\u000e\u0010K\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\nJ\u000e\u0010L\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\nJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010N\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010O\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\nJ\u000e\u0010P\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\nJ\u000e\u0010Q\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0004J\u000e\u0010R\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0004J\u000e\u0010S\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\nJ\u0010\u0010T\u001a\u0002002\u0006\u00106\u001a\u00020+H\u0002J\u000e\u0010T\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010U\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0013J\u0010\u0010V\u001a\u0002002\u0006\u00106\u001a\u00020+H\u0002J\u0010\u0010W\u001a\u0002002\u0006\u00106\u001a\u00020+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/allen/library/helper/ShapeBuilder;", "", "()V", "cornersBottomLeftRadius", "", "cornersBottomRightRadius", "cornersRadius", "cornersTopLeftRadius", "cornersTopRightRadius", "gradientAngle", "", "gradientCenterColor", "gradientCenterX", "gradientCenterY", "gradientEndColor", "gradientGradientRadius", "gradientStartColor", "gradientType", "gradientUseLevel", "", "selectorDisableColor", "selectorDrawable", "Landroid/graphics/drawable/StateListDrawable;", "getSelectorDrawable", "()Landroid/graphics/drawable/StateListDrawable;", "selectorNormalColor", "selectorPressedColor", "shapeType", "sizeHeight", "sizeWidth", "solidColor", "strokeColor", "strokeDashGap", "strokeDashWidth", "strokeWidth", "targetView", "Landroid/view/View;", "useSelector", "dip2px", "context", "Landroid/content/Context;", "dipValue", "getDrawable", "Landroid/graphics/drawable/GradientDrawable;", "state", "getGradientOrientationByAngle", "Landroid/graphics/drawable/GradientDrawable$Orientation;", "init", "", "attributeSetData", "Lcom/allen/library/data/AttributeSetData;", "into", "view", "setBorder", "gradientDrawable", "setGradient", "setRadius", "setSelectorColor", "setShapeCornersBottomLeftRadius", "radius", "setShapeCornersBottomRightRadius", "setShapeCornersRadius", "setShapeCornersTopLeftRadius", "setShapeCornersTopRightRadius", "setShapeGradientAngle", "setShapeGradientCenterColor", "setShapeGradientCenterX", "setShapeGradientCenterY", "setShapeGradientEndColor", "setShapeGradientGradientRadius", "setShapeGradientStartColor", "setShapeGradientType", "setShapeGradientUseLevel", "setShapeSelectorDisableColor", "color", "setShapeSelectorNormalColor", "setShapeSelectorPressedColor", "setShapeSizeHeight", "setShapeSizeWidth", "setShapeSolidColor", "setShapeStrokeColor", "setShapeStrokeDashGap", "setShapeStrokeDashWidth", "setShapeStrokeWidth", "setShapeType", "setShapeUseSelector", "setSize", "setSolidColor", "Companion", "library_release"})
public final class ShapeBuilder {
    private int shapeType = -1;
    private int solidColor = -1;
    private int strokeWidth = -1;
    private int strokeColor = -1;
    private float strokeDashWidth;
    private float strokeDashGap;
    private float cornersRadius;
    private float cornersTopLeftRadius;
    private float cornersTopRightRadius;
    private float cornersBottomLeftRadius;
    private float cornersBottomRightRadius;
    private int gradientAngle = -1;
    private int gradientCenterX;
    private int gradientCenterY;
    private int gradientGradientRadius;
    private int gradientStartColor = -1;
    private int gradientCenterColor = -1;
    private int gradientEndColor = -1;
    private int gradientType;
    private boolean gradientUseLevel;
    private int sizeWidth = -1;
    private int sizeHeight = -1;
    private int selectorPressedColor;
    private int selectorDisableColor;
    private int selectorNormalColor;
    private boolean useSelector;
    private View targetView;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;
    public static final int TOP_BOTTOM = 0;
    public static final int TR_BL = 1;
    public static final int RIGHT_LEFT = 2;
    public static final int BR_TL = 3;
    public static final int BOTTOM_TOP = 4;
    public static final int BL_TR = 5;
    public static final int LEFT_RIGHT = 6;
    public static final int TL_BR = 7;
    public static final int LINEAR = 0;
    public static final int RADIAL = 1;
    public static final int SWEEP = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ShapeBuilder setShapeType(int shapeType) {
        this.shapeType = shapeType;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeSolidColor(int color) {
        this.solidColor = color;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeCornersRadius(float radius) {
        this.cornersRadius = radius;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeCornersTopLeftRadius(float radius) {
        this.cornersTopLeftRadius = radius;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeCornersTopRightRadius(float radius) {
        this.cornersTopRightRadius = radius;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeCornersBottomRightRadius(float radius) {
        this.cornersBottomRightRadius = radius;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeCornersBottomLeftRadius(float radius) {
        this.cornersBottomLeftRadius = radius;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeStrokeDashWidth(float strokeDashWidth) {
        this.strokeDashWidth = strokeDashWidth;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeStrokeDashGap(float strokeDashGap) {
        this.strokeDashGap = strokeDashGap;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeUseSelector(boolean useSelector) {
        this.useSelector = useSelector;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeSelectorPressedColor(int color) {
        this.selectorPressedColor = color;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeSelectorNormalColor(int color) {
        this.selectorNormalColor = color;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeSelectorDisableColor(int color) {
        this.selectorDisableColor = color;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeSizeWidth(int sizeWidth) {
        this.sizeWidth = sizeWidth;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeSizeHeight(int sizeHeight) {
        this.sizeHeight = sizeHeight;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientAngle(int gradientAngle) {
        this.gradientAngle = gradientAngle;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientCenterX(int gradientCenterX) {
        this.gradientCenterX = gradientCenterX;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientCenterY(int gradientCenterY) {
        this.gradientCenterY = gradientCenterY;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientGradientRadius(int gradientGradientRadius) {
        this.gradientGradientRadius = gradientGradientRadius;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientStartColor(int gradientStartColor) {
        this.gradientStartColor = gradientStartColor;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientCenterColor(int gradientCenterColor) {
        this.gradientCenterColor = gradientCenterColor;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientEndColor(int gradientEndColor) {
        this.gradientEndColor = gradientEndColor;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientType(int gradientType) {
        this.gradientType = gradientType;
        return this;
    }

    @NotNull
    public final ShapeBuilder setShapeGradientUseLevel(boolean gradientUseLevel) {
        this.gradientUseLevel = gradientUseLevel;
        return this;
    }

    public final void init(@NotNull View targetView, @NotNull AttributeSetData attributeSetData) {
        Intrinsics.checkNotNullParameter((Object)targetView, (String)"targetView");
        Intrinsics.checkNotNullParameter((Object)attributeSetData, (String)"attributeSetData");
        this.setShapeType(attributeSetData.getShapeType());
        this.setShapeCornersRadius(attributeSetData.getCornersRadius());
        this.setShapeCornersTopLeftRadius(attributeSetData.getCornersTopLeftRadius());
        this.setShapeCornersTopRightRadius(attributeSetData.getCornersTopRightRadius());
        this.setShapeCornersBottomRightRadius(attributeSetData.getCornersBottomRightRadius());
        this.setShapeCornersBottomLeftRadius(attributeSetData.getCornersBottomLeftRadius());
        this.setShapeSolidColor(attributeSetData.getSolidColor());
        this.setShapeStrokeColor(attributeSetData.getStrokeColor());
        this.setShapeStrokeWidth(attributeSetData.getStrokeWidth());
        this.setShapeStrokeDashWidth(attributeSetData.getStrokeDashWidth());
        this.setShapeStrokeDashGap(attributeSetData.getStrokeDashGap());
        this.setShapeUseSelector(attributeSetData.getUseSelector());
        this.setShapeSelectorNormalColor(attributeSetData.getSelectorNormalColor());
        this.setShapeSelectorPressedColor(attributeSetData.getSelectorPressedColor());
        this.setShapeSelectorDisableColor(attributeSetData.getSelectorDisableColor());
        this.setShapeSizeWidth(attributeSetData.getSizeWidth());
        this.setShapeSizeHeight(attributeSetData.getSizeHeight());
        this.setShapeGradientType(attributeSetData.getGradientType());
        this.setShapeGradientAngle(attributeSetData.getGradientAngle());
        this.setShapeGradientGradientRadius(attributeSetData.getGradientGradientRadius());
        this.setShapeGradientUseLevel(attributeSetData.getGradientUseLevel());
        this.setShapeGradientCenterX(attributeSetData.getGradientCenterX());
        this.setShapeGradientCenterY(attributeSetData.getGradientCenterY());
        this.setShapeGradientStartColor(attributeSetData.getGradientStartColor());
        this.setShapeGradientCenterColor(attributeSetData.getGradientCenterColor());
        this.setShapeGradientEndColor(attributeSetData.getGradientEndColor());
        this.into(targetView);
    }

    private final void setShapeType(GradientDrawable gradientDrawable) {
        if (this.shapeType != -1) {
            switch (this.shapeType) {
                case 0: {
                    gradientDrawable.setShape(0);
                    break;
                }
                case 1: {
                    gradientDrawable.setShape(1);
                    break;
                }
                case 2: {
                    gradientDrawable.setShape(2);
                    break;
                }
                case 3: {
                    gradientDrawable.setShape(3);
                    break;
                }
            }
        }
    }

    private final void setSize(GradientDrawable gradientDrawable) {
        if (this.sizeWidth > 0 || this.sizeHeight > 0) {
            gradientDrawable.setSize(this.sizeWidth, this.sizeHeight);
        }
    }

    private final void setBorder(GradientDrawable gradientDrawable) {
        if (this.strokeWidth >= 0) {
            gradientDrawable.setStroke(this.strokeWidth, this.strokeColor, this.strokeDashWidth, this.strokeDashGap);
        }
    }

    private final void setRadius(GradientDrawable gradientDrawable) {
        if (this.shapeType == 0) {
            if (this.cornersRadius != 0.0f) {
                gradientDrawable.setCornerRadius(this.cornersRadius);
            } else if (this.cornersTopLeftRadius != 0.0f || this.cornersTopRightRadius != 0.0f || this.cornersBottomRightRadius != 0.0f || this.cornersBottomLeftRadius != 0.0f) {
                gradientDrawable.setCornerRadii(new float[]{this.cornersTopLeftRadius, this.cornersTopLeftRadius, this.cornersTopRightRadius, this.cornersTopRightRadius, this.cornersBottomRightRadius, this.cornersBottomRightRadius, this.cornersBottomLeftRadius, this.cornersBottomLeftRadius});
            }
        }
    }

    private final void setSolidColor(GradientDrawable gradientDrawable) {
        if (this.gradientStartColor == -1 && this.gradientEndColor == -1) {
            gradientDrawable.setColor(this.solidColor);
        }
    }

    private final void setSelectorColor(GradientDrawable gradientDrawable, int state) {
        if (this.useSelector && state != 0) {
            switch (state) {
                case 16842919: {
                    gradientDrawable.setColor(this.selectorPressedColor);
                    break;
                }
                case -16842910: {
                    gradientDrawable.setColor(this.selectorDisableColor);
                    break;
                }
                case 16842910: {
                    gradientDrawable.setColor(this.selectorNormalColor);
                    break;
                }
            }
        }
    }

    private final void setGradient(GradientDrawable gradientDrawable) {
        if ((this.gradientStartColor != -1 || this.gradientEndColor != -1) && Build.VERSION.SDK_INT >= 16) {
            if (this.gradientCenterColor == -1) {
                gradientDrawable.setColors(new int[]{this.gradientStartColor, this.gradientEndColor});
            } else {
                gradientDrawable.setColors(new int[]{this.gradientStartColor, this.gradientCenterColor, this.gradientEndColor});
            }
            switch (this.gradientType) {
                case 0: {
                    gradientDrawable.setGradientType(0);
                    if (this.gradientAngle == -1) break;
                    gradientDrawable.setOrientation(this.getGradientOrientationByAngle(this.gradientAngle));
                    break;
                }
                case 1: {
                    gradientDrawable.setGradientType(1);
                    gradientDrawable.setGradientRadius((float)this.gradientGradientRadius);
                    break;
                }
                case 2: {
                    gradientDrawable.setGradientType(2);
                    break;
                }
            }
            if (this.gradientCenterX != 0 || this.gradientCenterY != 0) {
                gradientDrawable.setGradientCenter((float)this.gradientCenterX, (float)this.gradientCenterY);
            }
            gradientDrawable.setUseLevel(this.gradientUseLevel);
        }
    }

    private final GradientDrawable.Orientation getGradientOrientationByAngle(int gradientAngle) {
        GradientDrawable.Orientation orientation = null;
        switch (gradientAngle) {
            case 0: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 45: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 90: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 135: {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 180: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 225: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 270: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 315: {
                orientation = GradientDrawable.Orientation.TL_BR;
                break;
            }
        }
        return orientation;
    }

    private final StateListDrawable getSelectorDrawable() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919, 16842910}, (Drawable)this.getDrawable(16842919));
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)this.getDrawable(-16842910));
        stateListDrawable.addState(new int[0], (Drawable)this.getDrawable(16842910));
        return stateListDrawable;
    }

    private final GradientDrawable getDrawable(int state) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        this.setShapeType(gradientDrawable);
        this.setGradient(gradientDrawable);
        this.setSolidColor(gradientDrawable);
        this.setBorder(gradientDrawable);
        this.setRadius(gradientDrawable);
        this.setSize(gradientDrawable);
        this.setSelectorColor(gradientDrawable, state);
        return gradientDrawable;
    }

    public final void into(@Nullable View view) {
        if (view == null) {
            return;
        }
        ViewCompat.setBackground((View)view, (Drawable)(this.useSelector ? (Drawable)this.getSelectorDrawable() : (Drawable)this.getDrawable(0)));
    }

    private final int dip2px(Context context, float dipValue) {
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/allen/library/helper/ShapeBuilder$Companion;", "", "()V", "BL_TR", "", "BOTTOM_TOP", "BR_TL", "LEFT_RIGHT", "LINE", "LINEAR", "OVAL", "RADIAL", "RECTANGLE", "RIGHT_LEFT", "RING", "SWEEP", "TL_BR", "TOP_BOTTOM", "TR_BL", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

