/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.SwitchCompat;
import com.allen.library.BaseTextView;
import com.allen.library.CircleImageView;
import com.allen.library.R;
import com.allen.library.helper.EditTextHelper;
import com.allen.library.helper.ShapeBuilder;

public class SuperTextView
extends RelativeLayout {
    private Context mContext;
    private BaseTextView leftView;
    private BaseTextView centerView;
    private BaseTextView rightView;
    private RelativeLayout.LayoutParams leftBaseViewParams;
    private RelativeLayout.LayoutParams centerBaseViewParams;
    private RelativeLayout.LayoutParams rightBaseViewParams;
    private CircleImageView leftIconIV;
    private CircleImageView rightIconIV;
    private RelativeLayout.LayoutParams leftImgParams;
    private RelativeLayout.LayoutParams rightImgParams;
    private int leftIconWidth;
    private int leftIconHeight;
    private int rightIconWidth;
    private int rightIconHeight;
    private int leftIconMarginLeft;
    private int rightIconMarginRight;
    private Drawable leftIconRes;
    private Drawable rightIconRes;
    private int defaultColor = -13158601;
    private int defaultSize = 15;
    private int defaultMaxEms = 0;
    private int defaultMaxLines = 0;
    private String mLeftTextString;
    private String mLeftTopTextString;
    private String mLeftBottomTextString;
    private String mRightTextString;
    private String mRightTopTextString;
    private String mRightBottomTextString;
    private String mCenterTextString;
    private String mCenterTopTextString;
    private String mCenterBottomTextString;
    private ColorStateList mLeftTextColor;
    private ColorStateList mLeftTopTextColor;
    private ColorStateList mLeftBottomTextColor;
    private ColorStateList mCenterTextColor;
    private ColorStateList mCenterTopTextColor;
    private ColorStateList mCenterBottomTextColor;
    private ColorStateList mRightTextColor;
    private ColorStateList mRightTopTextColor;
    private ColorStateList mRightBottomTextColor;
    private ColorStateList mRightEditHintTextColor;
    private ColorStateList mRightEditTextColor;
    private int mLeftTextSize;
    private int mLeftTopTextSize;
    private int mLeftBottomTextSize;
    private int mRightTextSize;
    private int mRightTopTextSize;
    private int mRightBottomTextSize;
    private int mCenterTextSize;
    private int mCenterTopTextSize;
    private int mCenterBottomTextSize;
    private int mLeftTopLines;
    private int mLeftLines;
    private int mLeftBottomLines;
    private int mCenterTopLines;
    private int mCenterLines;
    private int mCenterBottomLines;
    private int mRightTopLines;
    private int mRightLines;
    private int mRightBottomLines;
    private int mLeftTopMaxEms;
    private int mLeftMaxEms;
    private int mLeftBottomMaxEms;
    private int mCenterTopMaxEms;
    private int mCenterMaxEms;
    private int mCenterBottomMaxEms;
    private int mRightTopMaxEms;
    private int mRightMaxEms;
    private int mRightBottomMaxEms;
    private Drawable mLeftTextBackground;
    private Drawable mCenterTextBackground;
    private Drawable mRightTextBackground;
    private Drawable mLeftTvDrawableLeft;
    private Drawable mLeftTvDrawableRight;
    private Drawable mCenterTvDrawableLeft;
    private Drawable mCenterTvDrawableRight;
    private Drawable mRightTvDrawableLeft;
    private Drawable mRightTvDrawableRight;
    private int mLeftTvDrawableWidth;
    private int mLeftTvDrawableHeight;
    private int mCenterTvDrawableWidth;
    private int mCenterTvDrawableHeight;
    private int mRightTvDrawableWidth;
    private int mRightTvDrawableHeight;
    private int mTextViewDrawablePadding;
    private static final int gravity_Left_Center = 0;
    private static final int gravity_Center = 1;
    private static final int gravity_Right_Center = 2;
    private static final int default_Gravity = 1;
    private int mLeftGravity;
    private int mCenterGravity;
    private int mRightGravity;
    private int mLeftTextGravity;
    private int mCenterTextGravity;
    private int mRightTextGravity;
    private static final int text_gravity_Left = 0;
    private static final int text_gravity_center = 1;
    private static final int text_gravity_right = 2;
    private static final int default_text_gravity = -1;
    private int mLeftViewWidth;
    private int mTopDividerLineMarginLR;
    private int mTopDividerLineMarginLeft;
    private int mTopDividerLineMarginRight;
    private int mBottomDividerLineMarginLR;
    private int mBottomDividerLineMarginLeft;
    private int mBottomDividerLineMarginRight;
    private int mDividerLineType;
    private int mDividerLineColor;
    private int mDividerLineHeight;
    private int mDefaultDividerLineColor = -1513240;
    public static final int NONE = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int BOTH = 3;
    private static final int default_Divider = 2;
    private int default_Margin = 10;
    private int mLeftViewMarginLeft;
    private int mLeftViewMarginRight;
    private int mCenterViewMarginLeft;
    private int mCenterViewMarginRight;
    private int mRightViewMarginLeft;
    private int mRightViewMarginRight;
    private boolean useRipple;
    private Drawable mBackground_drawable;
    private OnSuperTextViewClickListener superTextViewClickListener;
    private OnLeftTopTvClickListener leftTopTvClickListener;
    private OnLeftTvClickListener leftTvClickListener;
    private OnLeftBottomTvClickListener leftBottomTvClickListener;
    private OnCenterTopTvClickListener centerTopTvClickListener;
    private OnCenterTvClickListener centerTvClickListener;
    private OnCenterBottomTvClickListener centerBottomTvClickListener;
    private OnRightTopTvClickListener rightTopTvClickListener;
    private OnRightTvClickListener rightTvClickListener;
    private OnRightBottomTvClickListener rightBottomTvClickListener;
    private OnSwitchCheckedChangeListener switchCheckedChangeListener;
    private OnCheckBoxCheckedChangeListener checkBoxCheckedChangeListener;
    private OnEditTextChangeListener editTextChangeListener;
    private OnLeftImageViewClickListener leftImageViewClickListener;
    private OnRightImageViewClickListener rightImageViewClickListener;
    private static final int TYPE_CHECKBOX = 0;
    private static final int TYPE_SWITCH = 1;
    private static final int TYPE_EDIT = 2;
    private static int mRightViewType;
    private AppCompatCheckBox rightCheckBox;
    private RelativeLayout.LayoutParams rightCheckBoxParams;
    private Drawable rightCheckBoxBg;
    private int rightCheckBoxMarginRight;
    private boolean isChecked;
    private int centerSpaceHeight;
    private SwitchCompat mSwitch;
    private RelativeLayout.LayoutParams mSwitchParams;
    private int rightSwitchMarginRight;
    private boolean switchIsChecked = true;
    private AppCompatEditText mEditText;
    private RelativeLayout.LayoutParams mEditParams;
    private int mEditMinWidth;
    private int mEditImeOption;
    private int mEditInputType;
    private int rightEditMarginRight;
    private int editActiveLineColor = -1;
    private int mEditTextSize;
    private int mEditCusorDrawableRes;
    private boolean mEditCusorVisible;
    private String mEditHintText;
    private String mTextOff;
    private String mTextOn;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private int mThumbTextPadding;
    private Drawable mThumbResource;
    private Drawable mTrackResource;
    private int defaultShapeColor = -1;
    private int selectorPressedColor;
    private int selectorNormalColor;
    private int solidColor;
    private float cornersRadius;
    private float cornersTopLeftRadius;
    private float cornersTopRightRadius;
    private float cornersBottomLeftRadius;
    private float cornersBottomRightRadius;
    private int strokeWidth;
    private int strokeColor;
    private float strokeDashWidth;
    private float strokeDashGap;
    private boolean useShape;
    private boolean mLeftIconShowCircle;
    private boolean mRightIconShowCircle;
    private GradientDrawable gradientDrawable;
    private Paint mTopDividerPaint;
    private Paint mBottomDividerPaint;
    private boolean mIsShowTopDivider;
    private boolean mIsShowBottomDivider;
    private ShapeBuilder shapeBuilder;

    public SuperTextView(Context context) {
        this(context, null);
    }

    public SuperTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SuperTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.defaultSize = this.sp2px(context, this.defaultSize);
        this.default_Margin = this.dip2px(context, this.default_Margin);
        this.shapeBuilder = new ShapeBuilder();
        this.getAttr(attrs);
        this.initPaint();
        this.initView();
    }

    private void getAttr(AttributeSet attrs) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attrs, R.styleable.SuperTextView);
        this.mLeftTextString = typedArray.getString(R.styleable.SuperTextView_sLeftTextString);
        this.mLeftTopTextString = typedArray.getString(R.styleable.SuperTextView_sLeftTopTextString);
        this.mLeftBottomTextString = typedArray.getString(R.styleable.SuperTextView_sLeftBottomTextString);
        this.mCenterTextString = typedArray.getString(R.styleable.SuperTextView_sCenterTextString);
        this.mCenterTopTextString = typedArray.getString(R.styleable.SuperTextView_sCenterTopTextString);
        this.mCenterBottomTextString = typedArray.getString(R.styleable.SuperTextView_sCenterBottomTextString);
        this.mRightTextString = typedArray.getString(R.styleable.SuperTextView_sRightTextString);
        this.mRightTopTextString = typedArray.getString(R.styleable.SuperTextView_sRightTopTextString);
        this.mRightBottomTextString = typedArray.getString(R.styleable.SuperTextView_sRightBottomTextString);
        this.mLeftTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sLeftTextColor);
        this.mLeftTopTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sLeftTopTextColor);
        this.mLeftBottomTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sLeftBottomTextColor);
        this.mCenterTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sCenterTextColor);
        this.mCenterTopTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sCenterTopTextColor);
        this.mCenterBottomTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sCenterBottomTextColor);
        this.mRightTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sRightTextColor);
        this.mRightTopTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sRightTopTextColor);
        this.mRightBottomTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sRightBottomTextColor);
        this.mLeftTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTextSize, this.defaultSize);
        this.mLeftTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTopTextSize, this.defaultSize);
        this.mLeftBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftBottomTextSize, this.defaultSize);
        this.mCenterTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTextSize, this.defaultSize);
        this.mCenterTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTopTextSize, this.defaultSize);
        this.mCenterBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterBottomTextSize, this.defaultSize);
        this.mRightTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTextSize, this.defaultSize);
        this.mRightTopTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTopTextSize, this.defaultSize);
        this.mRightBottomTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightBottomTextSize, this.defaultSize);
        this.mLeftTopLines = typedArray.getInt(R.styleable.SuperTextView_sLeftTopLines, this.defaultMaxLines);
        this.mLeftLines = typedArray.getInt(R.styleable.SuperTextView_sLeftLines, this.defaultMaxLines);
        this.mLeftBottomLines = typedArray.getInt(R.styleable.SuperTextView_sLeftBottomLines, this.defaultMaxLines);
        this.mCenterTopLines = typedArray.getInt(R.styleable.SuperTextView_sCenterTopLines, this.defaultMaxLines);
        this.mCenterLines = typedArray.getInt(R.styleable.SuperTextView_sCenterLines, this.defaultMaxLines);
        this.mCenterBottomLines = typedArray.getInt(R.styleable.SuperTextView_sCenterBottomLines, this.defaultMaxLines);
        this.mRightTopLines = typedArray.getInt(R.styleable.SuperTextView_sRightTopLines, this.defaultMaxLines);
        this.mRightLines = typedArray.getInt(R.styleable.SuperTextView_sRightLines, this.defaultMaxLines);
        this.mRightBottomLines = typedArray.getInt(R.styleable.SuperTextView_sRightBottomLines, this.defaultMaxLines);
        this.mLeftTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftTopMaxEms, this.defaultMaxEms);
        this.mLeftMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftMaxEms, this.defaultMaxEms);
        this.mLeftBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sLeftBottomMaxEms, this.defaultMaxEms);
        this.mCenterTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterTopMaxEms, this.defaultMaxEms);
        this.mCenterMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterMaxEms, this.defaultMaxEms);
        this.mCenterBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sCenterBottomMaxEms, this.defaultMaxEms);
        this.mRightTopMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightTopMaxEms, this.defaultMaxEms);
        this.mRightMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightMaxEms, this.defaultMaxEms);
        this.mRightBottomMaxEms = typedArray.getInt(R.styleable.SuperTextView_sRightBottomMaxEms, this.defaultMaxEms);
        this.mLeftGravity = typedArray.getInt(R.styleable.SuperTextView_sLeftViewGravity, 1);
        this.mCenterGravity = typedArray.getInt(R.styleable.SuperTextView_sCenterViewGravity, 1);
        this.mRightGravity = typedArray.getInt(R.styleable.SuperTextView_sRightViewGravity, 1);
        this.mLeftTextGravity = typedArray.getInt(R.styleable.SuperTextView_sLeftTextGravity, -1);
        this.mCenterTextGravity = typedArray.getInt(R.styleable.SuperTextView_sCenterTextGravity, -1);
        this.mRightTextGravity = typedArray.getInt(R.styleable.SuperTextView_sRightTextGravity, -1);
        this.mLeftTvDrawableLeft = typedArray.getDrawable(R.styleable.SuperTextView_sLeftTvDrawableLeft);
        this.mLeftTvDrawableRight = typedArray.getDrawable(R.styleable.SuperTextView_sLeftTvDrawableRight);
        this.mCenterTvDrawableLeft = typedArray.getDrawable(R.styleable.SuperTextView_sCenterTvDrawableLeft);
        this.mCenterTvDrawableRight = typedArray.getDrawable(R.styleable.SuperTextView_sCenterTvDrawableRight);
        this.mRightTvDrawableLeft = typedArray.getDrawable(R.styleable.SuperTextView_sRightTvDrawableLeft);
        this.mRightTvDrawableRight = typedArray.getDrawable(R.styleable.SuperTextView_sRightTvDrawableRight);
        this.mTextViewDrawablePadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTextViewDrawablePadding, this.default_Margin);
        this.mLeftTvDrawableWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTvDrawableWidth, -1);
        this.mLeftTvDrawableHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftTvDrawableHeight, -1);
        this.mCenterTvDrawableWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTvDrawableWidth, -1);
        this.mCenterTvDrawableHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterTvDrawableHeight, -1);
        this.mRightTvDrawableWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTvDrawableWidth, -1);
        this.mRightTvDrawableHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightTvDrawableHeight, -1);
        this.mLeftViewWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewWidth, 0);
        this.mTopDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginLR, 0);
        this.mTopDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginLeft, 0);
        this.mTopDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sTopDividerLineMarginRight, 0);
        this.mBottomDividerLineMarginLR = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginLR, 0);
        this.mBottomDividerLineMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginLeft, 0);
        this.mBottomDividerLineMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sBottomDividerLineMarginRight, 0);
        this.mDividerLineType = typedArray.getInt(R.styleable.SuperTextView_sDividerLineType, 2);
        this.mDividerLineColor = typedArray.getColor(R.styleable.SuperTextView_sDividerLineColor, this.mDefaultDividerLineColor);
        this.mDividerLineHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sDividerLineHeight, this.dip2px(this.mContext, 0.5f));
        this.mLeftViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewMarginLeft, this.default_Margin);
        this.mLeftViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftViewMarginRight, this.default_Margin);
        this.mCenterViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterViewMarginLeft, 0);
        this.mCenterViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterViewMarginRight, 0);
        this.mRightViewMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightViewMarginLeft, this.default_Margin);
        this.mRightViewMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightViewMarginRight, this.default_Margin);
        this.leftIconWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconWidth, 0);
        this.leftIconHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconHeight, 0);
        this.rightIconWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconWidth, 0);
        this.rightIconHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconHeight, 0);
        this.leftIconMarginLeft = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sLeftIconMarginLeft, this.default_Margin);
        this.rightIconMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightIconMarginRight, this.default_Margin);
        this.leftIconRes = typedArray.getDrawable(R.styleable.SuperTextView_sLeftIconRes);
        this.rightIconRes = typedArray.getDrawable(R.styleable.SuperTextView_sRightIconRes);
        this.mLeftTextBackground = typedArray.getDrawable(R.styleable.SuperTextView_sLeftTextBackground);
        this.mCenterTextBackground = typedArray.getDrawable(R.styleable.SuperTextView_sCenterTextBackground);
        this.mRightTextBackground = typedArray.getDrawable(R.styleable.SuperTextView_sRightTextBackground);
        this.useRipple = typedArray.getBoolean(R.styleable.SuperTextView_sUseRipple, true);
        this.mBackground_drawable = typedArray.getDrawable(R.styleable.SuperTextView_sBackgroundDrawableRes);
        mRightViewType = typedArray.getInt(R.styleable.SuperTextView_sRightViewType, -1);
        switch (mRightViewType) {
            case 0: {
                this.isChecked = typedArray.getBoolean(R.styleable.SuperTextView_sIsChecked, false);
                this.rightCheckBoxMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightCheckBoxMarginRight, this.default_Margin);
                this.rightCheckBoxBg = typedArray.getDrawable(R.styleable.SuperTextView_sRightCheckBoxRes);
                break;
            }
            case 1: {
                this.rightSwitchMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sRightSwitchMarginRight, this.default_Margin);
                this.switchIsChecked = typedArray.getBoolean(R.styleable.SuperTextView_sSwitchIsChecked, false);
                this.mTextOff = typedArray.getString(R.styleable.SuperTextView_sTextOff);
                this.mTextOn = typedArray.getString(R.styleable.SuperTextView_sTextOn);
                this.mSwitchMinWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sSwitchMinWidth, 0);
                this.mSwitchPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sSwitchPadding, 0);
                this.mThumbTextPadding = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sThumbTextPadding, 0);
                this.mThumbResource = typedArray.getDrawable(R.styleable.SuperTextView_sThumbResource);
                this.mTrackResource = typedArray.getDrawable(R.styleable.SuperTextView_sTrackResource);
                break;
            }
            case 2: {
                this.rightEditMarginRight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sEditMarginRight, 0);
                this.mEditMinWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sEditMinWidth, 0);
                this.mEditImeOption = typedArray.getInt(R.styleable.SuperTextView_android_imeOptions, 0);
                this.mEditInputType = typedArray.getInt(R.styleable.SuperTextView_android_inputType, 0);
                this.mRightEditTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sEditTextColor);
                this.mRightEditHintTextColor = typedArray.getColorStateList(R.styleable.SuperTextView_sEditHintTextColor);
                this.mEditHintText = typedArray.getString(R.styleable.SuperTextView_sEditHint);
                this.editActiveLineColor = typedArray.getColor(R.styleable.SuperTextView_sEditActiveLineColor, this.editActiveLineColor);
                this.mEditTextSize = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sEditTextSize, this.defaultSize);
                this.mEditCusorDrawableRes = typedArray.getResourceId(R.styleable.SuperTextView_sEditCursorDrawable, 0);
                this.mEditCusorVisible = typedArray.getBoolean(R.styleable.SuperTextView_sEditCursorVisible, true);
            }
        }
        this.centerSpaceHeight = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sCenterSpaceHeight, this.dip2px(this.mContext, 5.0f));
        this.selectorPressedColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSelectorPressedColor, this.defaultShapeColor);
        this.selectorNormalColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSelectorNormalColor, this.defaultShapeColor);
        this.solidColor = typedArray.getColor(R.styleable.SuperTextView_sShapeSolidColor, this.defaultShapeColor);
        this.cornersRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersRadius, 0);
        this.cornersTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersTopLeftRadius, 0);
        this.cornersTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersTopRightRadius, 0);
        this.cornersBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersBottomLeftRadius, 0);
        this.cornersBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeCornersBottomRightRadius, 0);
        this.strokeWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeWidth, 0);
        this.strokeDashWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeDashWidth, 0);
        this.strokeDashGap = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_sShapeStrokeDashGap, 0);
        this.strokeColor = typedArray.getColor(R.styleable.SuperTextView_sShapeStrokeColor, this.defaultShapeColor);
        this.useShape = typedArray.getBoolean(R.styleable.SuperTextView_sUseShape, false);
        this.mLeftIconShowCircle = typedArray.getBoolean(R.styleable.SuperTextView_sLeftIconShowCircle, false);
        this.mRightIconShowCircle = typedArray.getBoolean(R.styleable.SuperTextView_sRightIconShowCircle, false);
        typedArray.recycle();
    }

    private RelativeLayout.LayoutParams getParams(RelativeLayout.LayoutParams params) {
        if (params == null) {
            params = new RelativeLayout.LayoutParams(-2, -2);
        }
        return params;
    }

    private void initView() {
        this.initSuperTextView();
        this.initShape();
        this.initLeftIcon();
        switch (mRightViewType) {
            case 0: {
                this.initRightCheckBox();
                break;
            }
            case 1: {
                this.initRightSwitch();
            }
        }
        this.initRightIcon();
        if (mRightViewType == 2) {
            this.initRightEditText();
        }
        this.initLeftTextView();
        this.initCenterTextView();
        this.initRightTextView();
    }

    private void initShape() {
        if (this.useShape) {
            this.shapeBuilder.setShapeType(0).setShapeCornersRadius(this.cornersRadius).setShapeCornersTopLeftRadius(this.cornersTopLeftRadius).setShapeCornersTopRightRadius(this.cornersTopRightRadius).setShapeCornersBottomRightRadius(this.cornersBottomRightRadius).setShapeCornersBottomLeftRadius(this.cornersBottomLeftRadius).setShapeSolidColor(this.solidColor).setShapeStrokeColor(this.strokeColor).setShapeStrokeWidth(this.strokeWidth).setShapeStrokeDashWidth(this.strokeDashWidth).setShapeStrokeDashGap(this.strokeDashGap).setShapeUseSelector(true).setShapeSelectorNormalColor(this.selectorNormalColor).setShapeSelectorPressedColor(this.selectorPressedColor).into((View)this);
        }
    }

    private void initPaint() {
        this.mTopDividerPaint = new Paint();
        this.mTopDividerPaint.setColor(this.mDividerLineColor);
        this.mTopDividerPaint.setAntiAlias(true);
        this.mTopDividerPaint.setStrokeWidth((float)this.mDividerLineHeight);
        this.mBottomDividerPaint = new Paint();
        this.mBottomDividerPaint.setColor(this.mDividerLineColor);
        this.mBottomDividerPaint.setAntiAlias(true);
        this.mBottomDividerPaint.setStrokeWidth((float)this.mDividerLineHeight);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (!this.useShape) {
            this.mIsShowTopDivider = 1 == this.mDividerLineType || 3 == this.mDividerLineType;
            boolean bl = this.mIsShowBottomDivider = 2 == this.mDividerLineType || 3 == this.mDividerLineType;
            if (this.mIsShowTopDivider) {
                this.drawTopDivider(canvas);
            }
            if (this.mIsShowBottomDivider) {
                this.drawBottomDivider(canvas);
            }
        }
    }

    private void drawTopDivider(Canvas canvas) {
        this.drawDivider(canvas, true, this.mTopDividerLineMarginLR, this.mTopDividerLineMarginLeft, this.mTopDividerLineMarginRight, this.mTopDividerPaint);
    }

    private void drawBottomDivider(Canvas canvas) {
        this.drawDivider(canvas, false, this.mBottomDividerLineMarginLR, this.mBottomDividerLineMarginLeft, this.mBottomDividerLineMarginRight, this.mBottomDividerPaint);
    }

    private void drawDivider(Canvas canvas, boolean isTopDivider, int marginLR, int marginLeft, int marginRight, Paint paint) {
        if (marginLR != 0) {
            marginLeft = marginRight = marginLR;
        }
        canvas.drawLine((float)marginLeft, isTopDivider ? 0.0f : (float)this.getHeight(), (float)(this.getWidth() - marginRight), isTopDivider ? 0.0f : (float)this.getHeight(), paint);
    }

    private void initSuperTextView() {
        if (this.useRipple) {
            this.setBackgroundResource(R.drawable.selector_white);
            this.setClickable(true);
        }
        if (this.mBackground_drawable != null) {
            this.setBackgroundDrawable(this.mBackground_drawable);
        }
    }

    private void initLeftIcon() {
        if (this.leftIconIV == null) {
            this.leftIconIV = new CircleImageView(this.mContext);
        }
        this.leftImgParams = new RelativeLayout.LayoutParams(-2, -2);
        this.leftImgParams.addRule(9, -1);
        this.leftImgParams.addRule(15, -1);
        if (this.leftIconHeight != 0 && this.leftIconWidth != 0) {
            this.leftImgParams.width = this.leftIconWidth;
            this.leftImgParams.height = this.leftIconHeight;
        }
        this.leftIconIV.setId(R.id.sLeftImgId);
        this.leftIconIV.setLayoutParams((ViewGroup.LayoutParams)this.leftImgParams);
        if (this.leftIconRes != null) {
            this.leftImgParams.setMargins(this.leftIconMarginLeft, 0, 0, 0);
            this.leftIconIV.setImageDrawable(this.leftIconRes);
        }
        this.setCircleImage(this.leftIconIV, this.mLeftIconShowCircle);
        this.addView((View)this.leftIconIV);
    }

    private void initRightIcon() {
        if (this.rightIconIV == null) {
            this.rightIconIV = new CircleImageView(this.mContext);
        }
        this.rightImgParams = new RelativeLayout.LayoutParams(-2, -2);
        this.rightImgParams.addRule(15, -1);
        switch (mRightViewType) {
            case 0: {
                this.rightImgParams.addRule(0, R.id.sRightCheckBoxId);
                break;
            }
            case 1: {
                this.rightImgParams.addRule(0, R.id.sRightSwitchId);
                break;
            }
            default: {
                this.rightImgParams.addRule(11, -1);
            }
        }
        if (this.rightIconHeight != 0 && this.rightIconWidth != 0) {
            this.rightImgParams.width = this.rightIconWidth;
            this.rightImgParams.height = this.rightIconHeight;
        }
        this.rightIconIV.setId(R.id.sRightImgId);
        this.rightIconIV.setLayoutParams((ViewGroup.LayoutParams)this.rightImgParams);
        if (this.rightIconRes != null) {
            this.rightImgParams.setMargins(0, 0, this.rightIconMarginRight, 0);
            this.rightIconIV.setImageDrawable(this.rightIconRes);
        }
        this.setCircleImage(this.rightIconIV, this.mRightIconShowCircle);
        this.addView((View)this.rightIconIV);
    }

    private void initLeftTextView() {
        if (this.leftView == null) {
            this.leftView = this.initBaseView(R.id.sLeftViewId);
        }
        this.leftBaseViewParams = this.getParams(this.leftBaseViewParams);
        this.leftBaseViewParams.addRule(1, R.id.sLeftImgId);
        this.leftBaseViewParams.addRule(15, -1);
        if (this.mLeftViewWidth != 0) {
            this.leftBaseViewParams.width = this.mLeftViewWidth;
        }
        this.leftBaseViewParams.setMargins(this.mLeftViewMarginLeft, 0, this.mLeftViewMarginRight, 0);
        this.leftView.setLayoutParams((ViewGroup.LayoutParams)this.leftBaseViewParams);
        this.leftView.setCenterSpaceHeight(this.centerSpaceHeight);
        this.setDefaultColor(this.leftView, this.mLeftTopTextColor, this.mLeftTextColor, this.mLeftBottomTextColor);
        this.setDefaultSize(this.leftView, this.mLeftTopTextSize, this.mLeftTextSize, this.mLeftBottomTextSize);
        this.setDefaultLines(this.leftView, this.mLeftTopLines, this.mLeftLines, this.mLeftBottomLines);
        this.setDefaultMaxEms(this.leftView, this.mLeftTopMaxEms, this.mLeftMaxEms, this.mLeftBottomMaxEms);
        this.setDefaultGravity(this.leftView, this.mLeftGravity);
        this.setDefaultTextGravity(this.leftView, this.mLeftTextGravity);
        this.setDefaultDrawable(this.leftView.getCenterTextView(), this.mLeftTvDrawableLeft, this.mLeftTvDrawableRight, this.mTextViewDrawablePadding, this.mLeftTvDrawableWidth, this.mLeftTvDrawableHeight);
        this.setDefaultBackground(this.leftView.getCenterTextView(), this.mLeftTextBackground);
        this.setDefaultString(this.leftView, this.mLeftTopTextString, this.mLeftTextString, this.mLeftBottomTextString);
        this.addView((View)this.leftView);
    }

    private void initCenterTextView() {
        if (this.centerView == null) {
            this.centerView = this.initBaseView(R.id.sCenterViewId);
        }
        this.centerBaseViewParams = this.getParams(this.centerBaseViewParams);
        this.centerBaseViewParams.addRule(13, -1);
        this.centerBaseViewParams.addRule(15, -1);
        if (this.mCenterGravity != 1) {
            this.centerBaseViewParams.addRule(1, R.id.sLeftViewId);
            this.centerBaseViewParams.addRule(0, R.id.sRightViewId);
        }
        this.centerBaseViewParams.setMargins(this.mCenterViewMarginLeft, 0, this.mCenterViewMarginRight, 0);
        this.centerView.setLayoutParams((ViewGroup.LayoutParams)this.centerBaseViewParams);
        this.centerView.setCenterSpaceHeight(this.centerSpaceHeight);
        this.setDefaultColor(this.centerView, this.mCenterTopTextColor, this.mCenterTextColor, this.mCenterBottomTextColor);
        this.setDefaultSize(this.centerView, this.mCenterTopTextSize, this.mCenterTextSize, this.mCenterBottomTextSize);
        this.setDefaultLines(this.centerView, this.mCenterTopLines, this.mCenterLines, this.mCenterBottomLines);
        this.setDefaultMaxEms(this.centerView, this.mCenterTopMaxEms, this.mCenterMaxEms, this.mCenterBottomMaxEms);
        this.setDefaultGravity(this.centerView, this.mCenterGravity);
        this.setDefaultTextGravity(this.centerView, this.mCenterTextGravity);
        this.setDefaultDrawable(this.centerView.getCenterTextView(), this.mCenterTvDrawableLeft, this.mCenterTvDrawableRight, this.mTextViewDrawablePadding, this.mCenterTvDrawableWidth, this.mCenterTvDrawableHeight);
        this.setDefaultBackground(this.centerView.getCenterTextView(), this.mCenterTextBackground);
        this.setDefaultString(this.centerView, this.mCenterTopTextString, this.mCenterTextString, this.mCenterBottomTextString);
        this.addView((View)this.centerView);
    }

    private void initRightTextView() {
        if (this.rightView == null) {
            this.rightView = this.initBaseView(R.id.sRightViewId);
        }
        this.rightBaseViewParams = this.getParams(this.rightBaseViewParams);
        this.rightBaseViewParams.addRule(15, -1);
        this.rightBaseViewParams.addRule(0, R.id.sRightImgId);
        this.rightBaseViewParams.setMargins(this.mRightViewMarginLeft, 0, this.mRightViewMarginRight, 0);
        this.rightView.setLayoutParams((ViewGroup.LayoutParams)this.rightBaseViewParams);
        this.rightView.setCenterSpaceHeight(this.centerSpaceHeight);
        this.setDefaultColor(this.rightView, this.mRightTopTextColor, this.mRightTextColor, this.mRightBottomTextColor);
        this.setDefaultSize(this.rightView, this.mRightTopTextSize, this.mRightTextSize, this.mRightBottomTextSize);
        this.setDefaultLines(this.rightView, this.mRightTopLines, this.mRightLines, this.mRightBottomLines);
        this.setDefaultMaxEms(this.rightView, this.mRightTopMaxEms, this.mRightMaxEms, this.mRightBottomMaxEms);
        this.setDefaultGravity(this.rightView, this.mRightGravity);
        this.setDefaultTextGravity(this.rightView, this.mRightTextGravity);
        this.setDefaultDrawable(this.rightView.getCenterTextView(), this.mRightTvDrawableLeft, this.mRightTvDrawableRight, this.mTextViewDrawablePadding, this.mRightTvDrawableWidth, this.mRightTvDrawableHeight);
        this.setDefaultBackground(this.rightView.getCenterTextView(), this.mRightTextBackground);
        this.setDefaultString(this.rightView, this.mRightTopTextString, this.mRightTextString, this.mRightBottomTextString);
        this.addView((View)this.rightView);
    }

    private void initRightCheckBox() {
        if (this.rightCheckBox == null) {
            this.rightCheckBox = new AppCompatCheckBox(this.mContext);
        }
        this.rightCheckBoxParams = new RelativeLayout.LayoutParams(-2, -2);
        this.rightCheckBoxParams.addRule(11, -1);
        this.rightCheckBoxParams.addRule(15, -1);
        this.rightCheckBoxParams.setMargins(0, 0, this.rightCheckBoxMarginRight, 0);
        this.rightCheckBox.setId(R.id.sRightCheckBoxId);
        this.rightCheckBox.setLayoutParams((ViewGroup.LayoutParams)this.rightCheckBoxParams);
        if (this.rightCheckBoxBg != null) {
            this.rightCheckBox.setGravity(13);
            this.rightCheckBox.setButtonDrawable(this.rightCheckBoxBg);
        }
        this.rightCheckBox.setChecked(this.isChecked);
        this.rightCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (SuperTextView.this.checkBoxCheckedChangeListener != null) {
                    SuperTextView.this.checkBoxCheckedChangeListener.onCheckedChanged(buttonView, isChecked);
                }
            }
        });
        this.addView((View)this.rightCheckBox);
    }

    private void initRightSwitch() {
        if (this.mSwitch == null) {
            this.mSwitch = new SwitchCompat(this.mContext);
        }
        this.mSwitchParams = new RelativeLayout.LayoutParams(-2, -2);
        this.mSwitchParams.addRule(11, -1);
        this.mSwitchParams.addRule(15, -1);
        this.mSwitchParams.setMargins(0, 0, this.rightSwitchMarginRight, 0);
        this.mSwitch.setId(R.id.sRightSwitchId);
        this.mSwitch.setLayoutParams((ViewGroup.LayoutParams)this.mSwitchParams);
        this.mSwitch.setChecked(this.switchIsChecked);
        if (!TextUtils.isEmpty((CharSequence)this.mTextOff)) {
            this.mSwitch.setTextOff((CharSequence)this.mTextOff);
            this.mSwitch.setShowText(true);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mTextOn)) {
            this.mSwitch.setTextOn((CharSequence)this.mTextOn);
            this.mSwitch.setShowText(true);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            if (this.mSwitchMinWidth != 0) {
                this.mSwitch.setSwitchMinWidth(this.mSwitchMinWidth);
            }
            if (this.mSwitchPadding != 0) {
                this.mSwitch.setSwitchPadding(this.mSwitchPadding);
            }
            if (this.mThumbResource != null) {
                this.mSwitch.setThumbDrawable(this.mThumbResource);
            }
            if (this.mThumbResource != null) {
                this.mSwitch.setTrackDrawable(this.mTrackResource);
            }
            if (this.mThumbTextPadding != 0) {
                this.mSwitch.setThumbTextPadding(this.mThumbTextPadding);
            }
        }
        this.mSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (SuperTextView.this.switchCheckedChangeListener != null) {
                    SuperTextView.this.switchCheckedChangeListener.onCheckedChanged(buttonView, isChecked);
                }
            }
        });
        this.addView((View)this.mSwitch);
    }

    private void initRightEditText() {
        if (this.mEditText == null) {
            this.mEditText = new AppCompatEditText(this.mContext);
            this.mEditText.setSingleLine(true);
            this.mEditText.setGravity(0x800005);
            this.mEditText.setImeOptions(this.mEditImeOption);
            this.mEditText.setInputType(this.mEditInputType);
            this.mEditText.setBackgroundDrawable(null);
            this.mEditText.setTextSize(0, (float)this.mEditTextSize);
            this.mEditText.setCursorVisible(this.mEditCusorVisible);
            EditTextHelper.INSTANCE.setCursorDrawable((EditText)this.mEditText, this.mEditCusorDrawableRes);
        }
        if (this.mRightEditHintTextColor != null) {
            this.mEditText.setHintTextColor(this.mRightEditHintTextColor);
        }
        if (this.mRightEditTextColor != null) {
            this.mEditText.setTextColor(this.mRightEditTextColor);
        }
        if (this.mEditHintText != null) {
            this.mEditText.setHint((CharSequence)this.mEditHintText);
        }
        if (this.mEditMinWidth == 0) {
            this.mEditParams = new RelativeLayout.LayoutParams(-1, -2);
        } else {
            this.mEditText.setMinWidth(this.mEditMinWidth);
            this.mEditParams = new RelativeLayout.LayoutParams(-2, -2);
        }
        this.mEditParams.addRule(0, R.id.sRightImgId);
        this.mEditParams.addRule(15, -1);
        this.mEditParams.setMargins(0, 0, this.rightEditMarginRight, 0);
        this.mEditText.setId(R.id.sRightEditTextId);
        this.mEditText.setLayoutParams((ViewGroup.LayoutParams)this.mEditParams);
        this.addView((View)this.mEditText);
        this.mEditText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                if (SuperTextView.this.editTextChangeListener != null) {
                    SuperTextView.this.editTextChangeListener.beforeTextChanged(s, start, count, after);
                }
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (SuperTextView.this.editTextChangeListener != null) {
                    SuperTextView.this.editTextChangeListener.onTextChanged(s, start, before, count);
                }
            }

            public void afterTextChanged(Editable s) {
                if (SuperTextView.this.editTextChangeListener != null) {
                    SuperTextView.this.editTextChangeListener.afterTextChanged(s);
                }
            }
        });
        if (this.editActiveLineColor != -1) {
            this.mEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus) {
                        SuperTextView.this.setBottomDividerLineColor(SuperTextView.this.editActiveLineColor);
                    } else {
                        SuperTextView.this.setBottomDividerLineColor(SuperTextView.this.mDividerLineColor);
                    }
                }
            });
        }
    }

    private void setCircleImage(CircleImageView circleImageView, boolean disableCircularTransformation) {
        circleImageView.setDisableCircularTransformation(!disableCircularTransformation);
    }

    private BaseTextView initBaseView(int id2) {
        BaseTextView baseTextView = new BaseTextView(this.mContext);
        baseTextView.setId(id2);
        return baseTextView;
    }

    private void setDefaultString(BaseTextView baseTextView, String topTextString, String leftTextString, String bottomTextString) {
        if (baseTextView != null) {
            baseTextView.setTopTextString(topTextString);
            baseTextView.setCenterTextString(leftTextString);
            baseTextView.setBottomTextString(bottomTextString);
        }
    }

    private void setDefaultColor(BaseTextView baseTextView, ColorStateList topTextColor, ColorStateList textColor, ColorStateList bottomTextColor) {
        if (baseTextView != null) {
            if (topTextColor == null) {
                topTextColor = ColorStateList.valueOf((int)this.defaultColor);
            }
            if (textColor == null) {
                textColor = ColorStateList.valueOf((int)this.defaultColor);
            }
            if (bottomTextColor == null) {
                bottomTextColor = ColorStateList.valueOf((int)this.defaultColor);
            }
            baseTextView.getTopTextView().setTextColor(topTextColor);
            baseTextView.getCenterTextView().setTextColor(textColor);
            baseTextView.getBottomTextView().setTextColor(bottomTextColor);
        }
    }

    private void setDefaultSize(BaseTextView baseTextView, int topTextSize, int leftTextSize, int bottomTextSize) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().setTextSize(0, (float)topTextSize);
            baseTextView.getCenterTextView().setTextSize(0, (float)leftTextSize);
            baseTextView.getBottomTextView().setTextSize(0, (float)bottomTextSize);
        }
    }

    private void setDefaultMaxEms(BaseTextView baseTextView, int topMaxEms, int centerMaxEms, int bottomMaxEms) {
        if (baseTextView != null) {
            baseTextView.setMaxEms(topMaxEms, centerMaxEms, bottomMaxEms);
        }
    }

    private void setDefaultLines(BaseTextView baseTextView, int leftTopLines, int leftLines, int bottomLines) {
        if (baseTextView != null) {
            if (leftTopLines != 0) {
                baseTextView.getTopTextView().setMaxLines(leftTopLines);
            }
            if (leftLines != 0) {
                baseTextView.getCenterTextView().setMaxLines(leftLines);
            }
            if (bottomLines != 0) {
                baseTextView.getBottomTextView().setMaxLines(bottomLines);
            }
        }
    }

    private void setDefaultGravity(BaseTextView baseTextView, int gravity) {
        if (baseTextView != null) {
            this.setGravity(baseTextView, gravity);
        }
    }

    private void setGravity(BaseTextView baseTextView, int gravity) {
        switch (gravity) {
            case 0: {
                baseTextView.setGravity(19);
                break;
            }
            case 1: {
                baseTextView.setGravity(17);
                break;
            }
            case 2: {
                baseTextView.setGravity(21);
            }
        }
    }

    private void setDefaultTextGravity(BaseTextView baseTextView, int gravity) {
        if (baseTextView != null) {
            switch (gravity) {
                case 0: {
                    this.setTextGravity(baseTextView, 3);
                    break;
                }
                case 1: {
                    this.setTextGravity(baseTextView, 17);
                    break;
                }
                case 2: {
                    this.setTextGravity(baseTextView, 5);
                }
            }
        }
    }

    public void setDefaultDrawable(AppCompatTextView textView, Drawable drawableLeft, Drawable drawableRight, int drawablePadding, int drawableWidth, int drawableHeight) {
        if (drawableLeft != null || drawableRight != null) {
            textView.setVisibility(0);
        }
        if (drawableWidth != -1 && drawableHeight != -1) {
            if (drawableLeft != null) {
                drawableLeft.setBounds(0, 0, drawableWidth, drawableHeight);
            }
            if (drawableRight != null) {
                drawableRight.setBounds(0, 0, drawableWidth, drawableHeight);
            }
            textView.setCompoundDrawables(drawableLeft, null, drawableRight, null);
        } else {
            textView.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, null, drawableRight, null);
        }
        textView.setCompoundDrawablePadding(drawablePadding);
    }

    private void setDefaultBackground(AppCompatTextView textView, Drawable background) {
        if (background != null) {
            textView.setVisibility(0);
            if (Build.VERSION.SDK_INT < 16) {
                textView.setBackgroundDrawable(background);
            } else {
                textView.setBackground(background);
            }
        }
    }

    private void setDefaultLeftViewClickListener(BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.leftTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.leftTopTvClickListener.onClickListener();
                    }
                });
            }
            if (this.leftTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.leftTvClickListener.onClickListener();
                    }
                });
            }
            if (this.leftBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.leftBottomTvClickListener.onClickListener();
                    }
                });
            }
        }
    }

    private void setDefaultCenterViewClickListener(BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.centerTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.centerTopTvClickListener.onClickListener();
                    }
                });
            }
            if (this.centerTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.centerTvClickListener.onClickListener();
                    }
                });
            }
            if (this.centerBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.centerBottomTvClickListener.onClickListener();
                    }
                });
            }
        }
    }

    private void setDefaultRightViewClickListener(BaseTextView baseTextView) {
        if (baseTextView != null) {
            if (this.rightTopTvClickListener != null) {
                baseTextView.getTopTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.rightTopTvClickListener.onClickListener();
                    }
                });
            }
            if (this.rightTvClickListener != null) {
                baseTextView.getCenterTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.rightTvClickListener.onClickListener();
                    }
                });
            }
            if (this.rightBottomTvClickListener != null) {
                baseTextView.getBottomTextView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SuperTextView.this.rightBottomTvClickListener.onClickListener();
                    }
                });
            }
        }
    }

    private void setDefaultTextIsBold(BaseTextView baseTextView, boolean topTextBold, boolean centerTextBold, boolean bottomTextBold) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().getPaint().setFakeBoldText(topTextBold);
            baseTextView.getCenterTextView().getPaint().setFakeBoldText(centerTextBold);
            baseTextView.getBottomTextView().getPaint().setFakeBoldText(bottomTextBold);
        }
    }

    public SuperTextView setLeftTopString(CharSequence string) {
        if (this.leftView != null) {
            this.leftView.setTopTextString(string);
        }
        return this;
    }

    public SuperTextView setLeftString(CharSequence string) {
        if (this.leftView != null) {
            this.leftView.setCenterTextString(string);
        }
        return this;
    }

    public SuperTextView setLeftBottomString(CharSequence string) {
        if (this.leftView != null) {
            this.leftView.setBottomTextString(string);
        }
        return this;
    }

    public SuperTextView setCenterTopString(CharSequence string) {
        if (this.centerView != null) {
            this.centerView.setTopTextString(string);
        }
        return this;
    }

    public SuperTextView setCenterString(CharSequence string) {
        if (this.centerView != null) {
            this.centerView.setCenterTextString(string);
        }
        return this;
    }

    public SuperTextView setCenterBottomString(CharSequence string) {
        if (this.centerView != null) {
            this.centerView.setBottomTextString(string);
        }
        return this;
    }

    public SuperTextView setRightTopString(CharSequence string) {
        if (this.rightView != null) {
            this.rightView.setTopTextString(string);
        }
        return this;
    }

    public SuperTextView setRightString(CharSequence string) {
        if (this.rightView != null) {
            this.rightView.setCenterTextString(string);
        }
        return this;
    }

    public SuperTextView setRightBottomString(CharSequence string) {
        if (this.rightView != null) {
            this.rightView.setBottomTextString(string);
        }
        return this;
    }

    public SuperTextView setLeftTopTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setLeftTopTextColor(colorStateList);
        return this;
    }

    public SuperTextView setLeftTopTextColor(ColorStateList color) {
        if (this.leftView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.leftView.getTopTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setLeftTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setLeftTextColor(colorStateList);
        return this;
    }

    public SuperTextView setLeftTextColor(ColorStateList color) {
        if (this.leftView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.leftView.getCenterTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setLeftBottomTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setLeftBottomTextColor(colorStateList);
        return this;
    }

    public SuperTextView setLeftBottomTextColor(ColorStateList color) {
        if (this.leftView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.leftView.getBottomTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setCenterTopTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setCenterTopTextColor(colorStateList);
        return this;
    }

    public SuperTextView setCenterTopTextColor(ColorStateList color) {
        if (this.centerView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.centerView.getTopTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setCenterTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setCenterTextColor(colorStateList);
        return this;
    }

    public SuperTextView setCenterTextColor(ColorStateList color) {
        if (this.centerView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.centerView.getCenterTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setCenterBottomTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setCenterBottomTextColor(colorStateList);
        return this;
    }

    public SuperTextView setCenterBottomTextColor(ColorStateList color) {
        if (this.centerView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.centerView.getBottomTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setRightTopTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setRightTopTextColor(colorStateList);
        return this;
    }

    public SuperTextView setRightTopTextColor(ColorStateList color) {
        if (this.rightView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.rightView.getTopTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setRightTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setRightTextColor(colorStateList);
        return this;
    }

    public SuperTextView setRightTextColor(ColorStateList color) {
        if (this.rightView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.rightView.getCenterTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setRightBottomTextColor(int color) {
        ColorStateList colorStateList = ColorStateList.valueOf((int)color);
        this.setRightBottomTextColor(colorStateList);
        return this;
    }

    public SuperTextView setRightBottomTextColor(ColorStateList color) {
        if (this.rightView != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.rightView.getBottomTextView().setTextColor(color);
        }
        return this;
    }

    public SuperTextView setLeftTopTextIsBold(boolean isBold) {
        if (this.leftView != null) {
            this.leftView.setFakeBoldText((TextView)this.leftView.getTopTextView(), isBold);
        }
        return this;
    }

    public SuperTextView setLeftTextIsBold(boolean isBold) {
        if (this.leftView != null) {
            this.leftView.setFakeBoldText((TextView)this.leftView.getCenterTextView(), isBold);
        }
        return this;
    }

    public SuperTextView setLeftBottomTextIsBold(boolean isBold) {
        if (this.leftView != null) {
            this.leftView.setFakeBoldText((TextView)this.leftView.getBottomTextView(), isBold);
        }
        return this;
    }

    public SuperTextView setCenterTopTextIsBold(boolean isBold) {
        if (this.centerView != null) {
            this.centerView.setFakeBoldText((TextView)this.centerView.getTopTextView(), isBold);
        }
        return this;
    }

    public SuperTextView setCenterTextIsBold(boolean isBold) {
        if (this.centerView != null) {
            this.centerView.setFakeBoldText((TextView)this.centerView.getCenterTextView(), isBold);
        }
        return this;
    }

    public SuperTextView setCenterBottomTextIsBold(boolean isBold) {
        if (this.centerView != null) {
            this.centerView.setFakeBoldText((TextView)this.centerView.getBottomTextView(), isBold);
        }
        return this;
    }

    public SuperTextView setRightTopTextIsBold(boolean isBold) {
        if (this.rightView != null) {
            this.rightView.setFakeBoldText((TextView)this.rightView.getTopTextView(), isBold);
        }
        return this;
    }

    public SuperTextView setRightTextIsBold(boolean isBold) {
        if (this.rightView != null) {
            this.rightView.setFakeBoldText((TextView)this.rightView.getCenterTextView(), isBold);
        }
        return this;
    }

    public SuperTextView setRightBottomTextIsBold(boolean isBold) {
        if (this.rightView != null) {
            this.rightView.setFakeBoldText((TextView)this.rightView.getBottomTextView(), isBold);
        }
        return this;
    }

    public String getLeftTopString() {
        return this.leftView != null ? this.leftView.getTopTextView().getText().toString().trim() : "";
    }

    public String getLeftString() {
        return this.leftView != null ? this.leftView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getLeftBottomString() {
        return this.leftView != null ? this.leftView.getBottomTextView().getText().toString().trim() : "";
    }

    public String getCenterTopString() {
        return this.centerView != null ? this.centerView.getTopTextView().getText().toString().trim() : "";
    }

    public String getCenterString() {
        return this.centerView != null ? this.centerView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getCenterBottomString() {
        return this.centerView != null ? this.centerView.getBottomTextView().getText().toString().trim() : "";
    }

    public String getRightTopString() {
        return this.rightView != null ? this.rightView.getTopTextView().getText().toString().trim() : "";
    }

    public String getRightString() {
        return this.rightView != null ? this.rightView.getCenterTextView().getText().toString().trim() : "";
    }

    public String getRightBottomString() {
        return this.rightView != null ? this.rightView.getBottomTextView().getText().toString().trim() : "";
    }

    public ImageView getLeftIconIV() {
        this.leftImgParams.setMargins(this.leftIconMarginLeft, 0, 0, 0);
        return this.leftIconIV;
    }

    public ImageView getRightIconIV() {
        this.rightImgParams.setMargins(0, 0, this.rightIconMarginRight, 0);
        return this.rightIconIV;
    }

    public CheckBox getCheckBox() {
        return this.rightCheckBox;
    }

    public SuperTextView setCbChecked(boolean checked) {
        this.isChecked = checked;
        if (this.rightCheckBox != null) {
            this.rightCheckBox.setChecked(checked);
        }
        return this;
    }

    public SuperTextView setCbClickable(boolean clickable) {
        if (this.rightCheckBox != null) {
            this.rightCheckBox.setClickable(clickable);
        }
        return this;
    }

    public SuperTextView setCbBackground(Drawable drawable2) {
        this.rightCheckBoxBg = drawable2;
        if (this.rightCheckBox != null) {
            this.rightCheckBox.setBackgroundDrawable(drawable2);
        }
        return this;
    }

    public boolean getCbisChecked() {
        boolean isChecked = false;
        if (this.rightCheckBox != null) {
            isChecked = this.rightCheckBox.isChecked();
        }
        return isChecked;
    }

    public SuperTextView setSwitchIsChecked(boolean checked) {
        this.switchIsChecked = checked;
        if (this.mSwitch != null) {
            this.mSwitch.setChecked(checked);
        }
        return this;
    }

    public SuperTextView setSwitchClickable(boolean clickable) {
        if (this.mSwitch != null) {
            this.mSwitch.setClickable(clickable);
        }
        return this;
    }

    public boolean getSwitchIsChecked() {
        boolean isChecked = false;
        if (this.mSwitch != null) {
            isChecked = this.mSwitch.isChecked();
        }
        return isChecked;
    }

    public SwitchCompat getSwitch() {
        return this.mSwitch;
    }

    public AppCompatEditText getEditText() {
        return this.mEditText;
    }

    public SuperTextView setEditImeOptions(int option) {
        if (this.mEditText != null) {
            this.mEditText.setImeOptions(option);
        }
        return this;
    }

    public SuperTextView setEditInputType(int inputType) {
        if (this.mEditText != null) {
            this.mEditText.setInputType(inputType);
        }
        return this;
    }

    public SuperTextView setEditHintText(String hintText) {
        if (this.mEditText != null) {
            this.mEditText.setHint((CharSequence)hintText);
        }
        return this;
    }

    public SuperTextView setEditHintTextColor(int color) {
        if (this.mEditText != null) {
            this.setEditHintTextColor(ColorStateList.valueOf((int)color));
        }
        return this;
    }

    public SuperTextView setEditHintTextColor(ColorStateList color) {
        if (this.mEditText != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.mEditText.setHintTextColor(color);
        }
        return this;
    }

    public SuperTextView setEditTextColor(int color) {
        if (this.mEditText != null) {
            this.setEditTextColor(ColorStateList.valueOf((int)color));
        }
        return this;
    }

    public SuperTextView setEditTextColor(ColorStateList color) {
        if (this.mEditText != null) {
            if (color == null) {
                throw new NullPointerException();
            }
            this.mEditText.setTextColor(color);
        }
        return this;
    }

    public SuperTextView setEditCursorVisible(boolean visible) {
        if (this.mEditText != null) {
            this.mEditText.setCursorVisible(visible);
        }
        return this;
    }

    public SuperTextView setEditCursorDrawableRes(@DrawableRes int drawableRes) {
        if (this.mEditText != null) {
            EditTextHelper.INSTANCE.setCursorDrawable((EditText)this.mEditText, drawableRes);
        }
        return this;
    }

    public SuperTextView setLeftTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.leftView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding, this.mLeftTvDrawableWidth, this.mLeftTvDrawableHeight);
        return this;
    }

    public SuperTextView setLeftTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.leftView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding, this.mLeftTvDrawableWidth, this.mLeftTvDrawableHeight);
        return this;
    }

    public SuperTextView setCenterTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.centerView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding, this.mCenterTvDrawableWidth, this.mCenterTvDrawableHeight);
        return this;
    }

    public SuperTextView setCenterTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.centerView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding, this.mCenterTvDrawableWidth, this.mCenterTvDrawableHeight);
        return this;
    }

    public SuperTextView setRightTvDrawableLeft(Drawable drawableLeft) {
        this.setDefaultDrawable(this.rightView.getCenterTextView(), drawableLeft, null, this.mTextViewDrawablePadding, this.mRightTvDrawableWidth, this.mRightTvDrawableHeight);
        return this;
    }

    public SuperTextView setRightTvDrawableRight(Drawable drawableRight) {
        this.setDefaultDrawable(this.rightView.getCenterTextView(), null, drawableRight, this.mTextViewDrawablePadding, this.mRightTvDrawableWidth, this.mRightTvDrawableHeight);
        return this;
    }

    public SuperTextView setLeftIcon(Drawable leftIcon) {
        if (this.leftIconIV != null) {
            this.leftImgParams.setMargins(this.leftIconMarginLeft, 0, 0, 0);
            this.leftIconIV.setImageDrawable(leftIcon);
        }
        return this;
    }

    public SuperTextView setLeftIcon(int resId) {
        if (this.leftIconIV != null) {
            this.leftImgParams.setMargins(this.leftIconMarginLeft, 0, 0, 0);
            this.leftIconIV.setImageResource(resId);
        }
        return this;
    }

    public SuperTextView setRightIcon(Drawable rightIcon) {
        if (this.rightIconIV != null) {
            this.rightImgParams.setMargins(0, 0, this.rightIconMarginRight, 0);
            this.rightIconIV.setImageDrawable(rightIcon);
        }
        return this;
    }

    public SuperTextView setRightIcon(int resId) {
        if (this.rightIconIV != null) {
            this.rightImgParams.setMargins(0, 0, this.rightIconMarginRight, 0);
            this.rightIconIV.setImageResource(resId);
        }
        return this;
    }

    public SuperTextView setSBackground(Drawable drawable2) {
        if (drawable2 != null) {
            this.setBackgroundDrawable(drawable2);
        }
        return this;
    }

    public AppCompatTextView getLeftTopTextView() {
        if (this.leftView == null) {
            this.initLeftTextView();
        }
        return this.leftView.getTopTextView();
    }

    public AppCompatTextView getLeftTextView() {
        if (this.leftView == null) {
            this.initLeftTextView();
        }
        return this.leftView.getCenterTextView();
    }

    public AppCompatTextView getLeftBottomTextView() {
        if (this.leftView == null) {
            this.initLeftTextView();
        }
        return this.leftView.getBottomTextView();
    }

    public AppCompatTextView getCenterTopTextView() {
        if (this.centerView == null) {
            this.initCenterTextView();
        }
        return this.centerView.getTopTextView();
    }

    public AppCompatTextView getCenterTextView() {
        if (this.centerView == null) {
            this.initCenterTextView();
        }
        return this.centerView.getCenterTextView();
    }

    public AppCompatTextView getCenterBottomTextView() {
        if (this.centerView == null) {
            this.initCenterTextView();
        }
        return this.centerView.getBottomTextView();
    }

    public AppCompatTextView getRightTopTextView() {
        if (this.rightView == null) {
            this.initRightTextView();
        }
        return this.rightView.getTopTextView();
    }

    public AppCompatTextView getRightTextView() {
        if (this.rightView == null) {
            this.initRightTextView();
        }
        return this.rightView.getCenterTextView();
    }

    public AppCompatTextView getRightBottomTextView() {
        if (this.rightView == null) {
            this.initRightTextView();
        }
        return this.rightView.getBottomTextView();
    }

    public SuperTextView setLeftTextGravity(int gravity) {
        this.setTextGravity(this.leftView, gravity);
        return this;
    }

    public SuperTextView setCenterTextGravity(int gravity) {
        this.setTextGravity(this.centerView, gravity);
        return this;
    }

    public SuperTextView setRightTextGravity(int gravity) {
        this.setTextGravity(this.rightView, gravity);
        return this;
    }

    private void setTextGravity(BaseTextView baseTextView, int gravity) {
        if (baseTextView != null) {
            baseTextView.getTopTextView().setGravity(gravity);
            baseTextView.getCenterTextView().setGravity(gravity);
            baseTextView.getBottomTextView().setGravity(gravity);
        }
    }

    public SuperTextView setDividerLineType(int dividerType) {
        this.mDividerLineType = dividerType;
        this.invalidate();
        return this;
    }

    public SuperTextView setTopDividerLineColor(int lineColor) {
        this.mTopDividerPaint.setColor(lineColor);
        this.invalidate();
        return this;
    }

    public SuperTextView setBottomDividerLineColor(int lineColor) {
        this.mBottomDividerPaint.setColor(lineColor);
        this.invalidate();
        return this;
    }

    public SuperTextView setOnSuperTextViewClickListener(OnSuperTextViewClickListener onSuperTextViewClickListener) {
        this.superTextViewClickListener = onSuperTextViewClickListener;
        if (this.superTextViewClickListener != null) {
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.superTextViewClickListener.onClickListener(SuperTextView.this);
                }
            });
        }
        return this;
    }

    public SuperTextView setLeftTopTvClickListener(OnLeftTopTvClickListener leftTopTvClickListener) {
        this.leftTopTvClickListener = leftTopTvClickListener;
        this.setDefaultLeftViewClickListener(this.leftView);
        return this;
    }

    public SuperTextView setLeftTvClickListener(OnLeftTvClickListener leftTvClickListener) {
        this.leftTvClickListener = leftTvClickListener;
        this.setDefaultLeftViewClickListener(this.leftView);
        return this;
    }

    public SuperTextView setLeftBottomTvClickListener(OnLeftBottomTvClickListener leftBottomTvClickListener) {
        this.leftBottomTvClickListener = leftBottomTvClickListener;
        this.setDefaultLeftViewClickListener(this.leftView);
        return this;
    }

    public SuperTextView setCenterTopTvClickListener(OnCenterTopTvClickListener centerTopTvClickListener) {
        this.centerTopTvClickListener = centerTopTvClickListener;
        this.setDefaultCenterViewClickListener(this.centerView);
        return this;
    }

    public SuperTextView setCenterTvClickListener(OnCenterTvClickListener centerTvClickListener) {
        this.centerTvClickListener = centerTvClickListener;
        this.setDefaultCenterViewClickListener(this.centerView);
        return this;
    }

    public SuperTextView setCenterBottomTvClickListener(OnCenterBottomTvClickListener centerBottomTvClickListener) {
        this.centerBottomTvClickListener = centerBottomTvClickListener;
        this.setDefaultCenterViewClickListener(this.centerView);
        return this;
    }

    public SuperTextView setRightTopTvClickListener(OnRightTopTvClickListener rightTopTvClickListener) {
        this.rightTopTvClickListener = rightTopTvClickListener;
        this.setDefaultRightViewClickListener(this.rightView);
        return this;
    }

    public SuperTextView setRightTvClickListener(OnRightTvClickListener rightTvClickListener) {
        this.rightTvClickListener = rightTvClickListener;
        this.setDefaultRightViewClickListener(this.rightView);
        return this;
    }

    public SuperTextView setRightBottomTvClickListener(OnRightBottomTvClickListener rightBottomTvClickListener) {
        this.rightBottomTvClickListener = rightBottomTvClickListener;
        this.setDefaultRightViewClickListener(this.rightView);
        return this;
    }

    public SuperTextView setLeftImageViewClickListener(OnLeftImageViewClickListener listener) {
        this.leftImageViewClickListener = listener;
        if (this.leftIconIV != null) {
            this.leftIconIV.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.leftImageViewClickListener.onClickListener((ImageView)SuperTextView.this.leftIconIV);
                }
            });
        }
        return this;
    }

    public SuperTextView setRightImageViewClickListener(OnRightImageViewClickListener listener) {
        this.rightImageViewClickListener = listener;
        if (this.rightIconIV != null) {
            this.rightIconIV.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SuperTextView.this.rightImageViewClickListener.onClickListener((ImageView)SuperTextView.this.rightIconIV);
                }
            });
        }
        return this;
    }

    public SuperTextView setSwitchCheckedChangeListener(OnSwitchCheckedChangeListener switchCheckedChangeListener) {
        this.switchCheckedChangeListener = switchCheckedChangeListener;
        return this;
    }

    public SuperTextView setCheckBoxCheckedChangeListener(OnCheckBoxCheckedChangeListener checkBoxCheckedChangeListener) {
        this.checkBoxCheckedChangeListener = checkBoxCheckedChangeListener;
        return this;
    }

    public SuperTextView setEditTextChangeListener(OnEditTextChangeListener editTextChangeListener) {
        this.editTextChangeListener = editTextChangeListener;
        return this;
    }

    public SuperTextView setLeftTextGroupClickListener(final OnLeftTextGroupClickListener leftTextGroupClickListener) {
        if (leftTextGroupClickListener != null) {
            this.leftView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    leftTextGroupClickListener.onClickListener(v);
                }
            });
        }
        return this;
    }

    public SuperTextView setCenterTextGroupClickListener(final OnCenterTextGroupClickListener centerTextGroupClickListener) {
        if (centerTextGroupClickListener != null) {
            this.centerView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    centerTextGroupClickListener.onClickListener(v);
                }
            });
        }
        return this;
    }

    public SuperTextView setRightTextGroupClickListener(final OnRightTextGroupClickListener rightTextGroupClickListener) {
        if (rightTextGroupClickListener != null) {
            this.rightView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    rightTextGroupClickListener.onClickListener(v);
                }
            });
        }
        return this;
    }

    public ShapeBuilder getShapeBuilder() {
        return this.shapeBuilder;
    }

    private int sp2px(Context context, float spValue) {
        float scale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * scale + 0.5f);
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static interface OnRightTextGroupClickListener {
        public void onClickListener(View var1);
    }

    public static interface OnCenterTextGroupClickListener {
        public void onClickListener(View var1);
    }

    public static interface OnLeftTextGroupClickListener {
        public void onClickListener(View var1);
    }

    public static interface OnEditTextChangeListener {
        public void beforeTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void onTextChanged(CharSequence var1, int var2, int var3, int var4);

        public void afterTextChanged(Editable var1);
    }

    public static interface OnCheckBoxCheckedChangeListener {
        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }

    public static interface OnSwitchCheckedChangeListener {
        public void onCheckedChanged(CompoundButton var1, boolean var2);
    }

    public static interface OnRightImageViewClickListener {
        public void onClickListener(ImageView var1);
    }

    public static interface OnLeftImageViewClickListener {
        public void onClickListener(ImageView var1);
    }

    public static interface OnRightBottomTvClickListener {
        public void onClickListener();
    }

    public static interface OnRightTvClickListener {
        public void onClickListener();
    }

    public static interface OnRightTopTvClickListener {
        public void onClickListener();
    }

    public static interface OnCenterBottomTvClickListener {
        public void onClickListener();
    }

    public static interface OnCenterTvClickListener {
        public void onClickListener();
    }

    public static interface OnCenterTopTvClickListener {
        public void onClickListener();
    }

    public static interface OnLeftBottomTvClickListener {
        public void onClickListener();
    }

    public static interface OnLeftTvClickListener {
        public void onClickListener();
    }

    public static interface OnLeftTopTvClickListener {
        public void onClickListener();
    }

    public static interface OnSuperTextViewClickListener {
        public void onClickListener(SuperTextView var1);
    }
}

