/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library;

import android.content.Context;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;

public class BaseTextView
extends LinearLayout {
    private Context mContext;
    private AppCompatTextView topTextView;
    private AppCompatTextView centerTextView;
    private AppCompatTextView bottomTextView;
    private LinearLayout.LayoutParams topTVParams;
    private LinearLayout.LayoutParams centerTVParams;
    private LinearLayout.LayoutParams bottomTVParams;

    public BaseTextView(Context context) {
        this(context, null);
    }

    public BaseTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BaseTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        this.mContext = context;
        this.initView();
    }

    private void initView() {
        this.initTopView();
        this.initCenterView();
        this.initBottomView();
    }

    private void initTopView() {
        if (this.topTVParams == null) {
            this.topTVParams = this.getParams(this.topTVParams);
        }
        if (this.topTextView == null) {
            this.topTextView = this.initTextView(this.topTVParams, this.topTextView);
        }
    }

    private void initCenterView() {
        if (this.centerTVParams == null) {
            this.centerTVParams = this.getParams(this.centerTVParams);
        }
        if (this.centerTextView == null) {
            this.centerTextView = this.initTextView(this.centerTVParams, this.centerTextView);
        }
    }

    private void initBottomView() {
        if (this.bottomTVParams == null) {
            this.bottomTVParams = this.getParams(this.bottomTVParams);
        }
        if (this.bottomTextView == null) {
            this.bottomTextView = this.initTextView(this.bottomTVParams, this.bottomTextView);
        }
    }

    private AppCompatTextView initTextView(LinearLayout.LayoutParams params, AppCompatTextView textView) {
        textView = this.getTextView(textView, params);
        this.addView((View)textView);
        return textView;
    }

    public AppCompatTextView getTextView(AppCompatTextView textView, LinearLayout.LayoutParams layoutParams) {
        if (textView == null) {
            textView = new AppCompatTextView(this.mContext);
            textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            textView.setVisibility(8);
        }
        return textView;
    }

    public LinearLayout.LayoutParams getParams(LinearLayout.LayoutParams params) {
        if (params == null) {
            params = new LinearLayout.LayoutParams(-2, -2);
        }
        return params;
    }

    private void setTextString(AppCompatTextView textView, CharSequence textString) {
        textView.setText(textString);
        if (!TextUtils.isEmpty((CharSequence)textString)) {
            textView.setVisibility(0);
        }
    }

    public void setTopTextString(CharSequence s) {
        this.setTextString(this.topTextView, s);
    }

    public void setCenterTextString(CharSequence s) {
        this.setTextString(this.centerTextView, s);
    }

    public void setBottomTextString(CharSequence s) {
        this.setTextString(this.bottomTextView, s);
    }

    public AppCompatTextView getTopTextView() {
        return this.topTextView;
    }

    public AppCompatTextView getCenterTextView() {
        return this.centerTextView;
    }

    public AppCompatTextView getBottomTextView() {
        return this.bottomTextView;
    }

    public void setMaxEms(int topMaxEms, int centerMaxEms, int bottomMaxEms) {
        if (topMaxEms != 0) {
            this.topTextView.setEllipsize(TextUtils.TruncateAt.END);
            this.topTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(topMaxEms)});
        }
        if (centerMaxEms != 0) {
            this.centerTextView.setEllipsize(TextUtils.TruncateAt.END);
            this.centerTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(centerMaxEms)});
        }
        if (bottomMaxEms != 0) {
            this.bottomTextView.setEllipsize(TextUtils.TruncateAt.END);
            this.bottomTextView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(bottomMaxEms)});
        }
    }

    public void setFakeBoldText(TextView textView, boolean isBold) {
        if (textView != null) {
            textView.getPaint().setFakeBoldText(isBold);
            textView.invalidate();
        }
    }

    public void setCenterSpaceHeight(int centerSpaceHeight) {
        this.topTVParams.setMargins(0, 0, 0, centerSpaceHeight);
        this.centerTVParams.setMargins(0, 0, 0, 0);
        this.bottomTVParams.setMargins(0, centerSpaceHeight, 0, 0);
    }
}

