/*
 * Decompiled with CFR 0.152.
 */
package com.allen.library.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;

public class ShapeBuilder {
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;
    private int shapeType = -1;
    private int solidColor = -1;
    private int strokeWidth = -1;
    private int strokeColor = -1;
    private float strokeDashWidth = 0.0f;
    private float strokeDashGap = 0.0f;
    private float cornersRadius = 0.0f;
    private float cornersTopLeftRadius = 0.0f;
    private float cornersTopRightRadius = 0.0f;
    private float cornersBottomLeftRadius = 0.0f;
    private float cornersBottomRightRadius = 0.0f;
    public static final int TOP_BOTTOM = 0;
    public static final int TR_BL = 1;
    public static final int RIGHT_LEFT = 2;
    public static final int BR_TL = 3;
    public static final int BOTTOM_TOP = 4;
    public static final int BL_TR = 5;
    public static final int LEFT_RIGHT = 6;
    public static final int TL_BR = 7;
    private int gradientAngle = -1;
    private int gradientCenterX;
    private int gradientCenterY;
    private int gradientGradientRadius;
    private int gradientStartColor;
    private int gradientCenterColor;
    private int gradientEndColor;
    private int gradientType;
    public static final int LINEAR = 0;
    public static final int RADIAL = 1;
    public static final int SWEEP = 2;
    private boolean gradientUseLevel;
    private int sizeWidth = -1;
    private int sizeHeight = -1;
    private int selectorPressedColor;
    private int selectorDisableColor;
    private int selectorNormalColor;
    private boolean useSelector;

    public ShapeBuilder setShapeType(int shapeType) {
        this.shapeType = shapeType;
        return this;
    }

    public ShapeBuilder setShapeSolidColor(int color) {
        this.solidColor = color;
        return this;
    }

    public ShapeBuilder setShapeCornersRadius(float radius) {
        this.cornersRadius = radius;
        return this;
    }

    public ShapeBuilder setShapeCornersTopLeftRadius(float radius) {
        this.cornersTopLeftRadius = radius;
        return this;
    }

    public ShapeBuilder setShapeCornersTopRightRadius(float radius) {
        this.cornersTopRightRadius = radius;
        return this;
    }

    public ShapeBuilder setShapeCornersBottomRightRadius(float radius) {
        this.cornersBottomRightRadius = radius;
        return this;
    }

    public ShapeBuilder setShapeCornersBottomLeftRadius(float radius) {
        this.cornersBottomLeftRadius = radius;
        return this;
    }

    public ShapeBuilder setShapeStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        return this;
    }

    public ShapeBuilder setShapeStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        return this;
    }

    public ShapeBuilder setShapeStrokeDashWidth(float strokeDashWidth) {
        this.strokeDashWidth = strokeDashWidth;
        return this;
    }

    public ShapeBuilder setShapeStrokeDashGap(float strokeDashGap) {
        this.strokeDashGap = strokeDashGap;
        return this;
    }

    public ShapeBuilder setShapeUseSelector(boolean useSelector) {
        this.useSelector = useSelector;
        return this;
    }

    public ShapeBuilder setShapeSelectorPressedColor(int color) {
        this.selectorPressedColor = color;
        return this;
    }

    public ShapeBuilder setShapeSelectorNormalColor(int color) {
        this.selectorNormalColor = color;
        return this;
    }

    public ShapeBuilder setShapeSelectorDisableColor(int color) {
        this.selectorDisableColor = color;
        return this;
    }

    public ShapeBuilder setShapeSizeWidth(int sizeWidth) {
        this.sizeWidth = sizeWidth;
        return this;
    }

    public ShapeBuilder setShapeSizeHeight(int sizeHeight) {
        this.sizeHeight = sizeHeight;
        return this;
    }

    public ShapeBuilder setShapeGradientAngle(int gradientAngle) {
        this.gradientAngle = gradientAngle;
        return this;
    }

    public ShapeBuilder setShapeGradientCenterX(int gradientCenterX) {
        this.gradientCenterX = gradientCenterX;
        return this;
    }

    public ShapeBuilder setShapeGradientCenterY(int gradientCenterY) {
        this.gradientCenterY = gradientCenterY;
        return this;
    }

    public ShapeBuilder setShapeGradientGradientRadius(int gradientGradientRadius) {
        this.gradientGradientRadius = gradientGradientRadius;
        return this;
    }

    public ShapeBuilder setShapeGradientStartColor(int gradientStartColor) {
        this.gradientStartColor = gradientStartColor;
        return this;
    }

    public ShapeBuilder setShapeGradientCenterColor(int gradientCenterColor) {
        this.gradientCenterColor = gradientCenterColor;
        return this;
    }

    public ShapeBuilder setShapeGradientEndColor(int gradientEndColor) {
        this.gradientEndColor = gradientEndColor;
        return this;
    }

    public ShapeBuilder setShapeGradientType(int gradientType) {
        this.gradientType = gradientType;
        return this;
    }

    public ShapeBuilder setShapeGradientUseLevel(boolean gradientUseLevel) {
        this.gradientUseLevel = gradientUseLevel;
        return this;
    }

    private void setShapeType(GradientDrawable gradientDrawable) {
        if (this.shapeType != -1) {
            switch (this.shapeType) {
                case 0: {
                    gradientDrawable.setShape(0);
                    break;
                }
                case 1: {
                    gradientDrawable.setShape(1);
                    break;
                }
                case 2: {
                    gradientDrawable.setShape(2);
                    break;
                }
                case 3: {
                    gradientDrawable.setShape(3);
                }
            }
        }
    }

    private void setSize(GradientDrawable gradientDrawable) {
        if (this.sizeWidth > 0 || this.sizeHeight > 0) {
            gradientDrawable.setSize(this.sizeWidth, this.sizeHeight);
        }
    }

    private void setBorder(GradientDrawable gradientDrawable) {
        if (this.strokeWidth >= 0) {
            gradientDrawable.setStroke(this.strokeWidth, this.strokeColor, this.strokeDashWidth, this.strokeDashGap);
        }
    }

    private void setRadius(GradientDrawable gradientDrawable) {
        if (this.shapeType == 0) {
            if (this.cornersRadius != 0.0f) {
                gradientDrawable.setCornerRadius(this.cornersRadius);
            } else if (this.cornersTopLeftRadius != 0.0f || this.cornersTopRightRadius != 0.0f || this.cornersBottomRightRadius != 0.0f || this.cornersBottomLeftRadius != 0.0f) {
                gradientDrawable.setCornerRadii(new float[]{this.cornersTopLeftRadius, this.cornersTopLeftRadius, this.cornersTopRightRadius, this.cornersTopRightRadius, this.cornersBottomRightRadius, this.cornersBottomRightRadius, this.cornersBottomLeftRadius, this.cornersBottomLeftRadius});
            }
        }
    }

    private void setSolidColor(GradientDrawable gradientDrawable) {
        if (this.solidColor != -1) {
            gradientDrawable.setColor(this.solidColor);
        }
    }

    private void setSelectorColor(GradientDrawable gradientDrawable, int state) {
        if (this.useSelector && state != 0) {
            switch (state) {
                case 16842919: {
                    gradientDrawable.setColor(this.selectorPressedColor);
                    break;
                }
                case -16842910: {
                    gradientDrawable.setColor(this.selectorDisableColor);
                    break;
                }
                case 16842910: {
                    gradientDrawable.setColor(this.selectorNormalColor);
                }
            }
        }
    }

    private void setGradient(GradientDrawable gradientDrawable) {
        if (this.gradientAngle != -1) {
            if (Build.VERSION.SDK_INT >= 16) {
                gradientDrawable.setOrientation(this.getGradientOrientationByAngle(this.gradientAngle));
                if (this.gradientCenterColor == -1) {
                    gradientDrawable.setColors(new int[]{this.gradientStartColor, this.gradientEndColor});
                } else {
                    gradientDrawable.setColors(new int[]{this.gradientStartColor, this.gradientCenterColor, this.gradientEndColor});
                }
                switch (this.gradientType) {
                    case 0: {
                        gradientDrawable.setGradientType(0);
                        break;
                    }
                    case 1: {
                        gradientDrawable.setGradientType(1);
                        gradientDrawable.setGradientRadius((float)this.gradientGradientRadius);
                        break;
                    }
                    case 2: {
                        gradientDrawable.setGradientType(2);
                    }
                }
                gradientDrawable.setUseLevel(this.gradientUseLevel);
                if (this.gradientCenterX != 0 && this.gradientCenterY != 0) {
                    gradientDrawable.setGradientCenter((float)this.gradientCenterX, (float)this.gradientCenterY);
                }
            }
        } else {
            this.setSolidColor(gradientDrawable);
        }
    }

    private GradientDrawable.Orientation getGradientOrientationByAngle(int gradientAngle) {
        GradientDrawable.Orientation orientation = null;
        switch (gradientAngle) {
            case 0: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 45: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 90: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 135: {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 180: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 225: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 270: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 315: {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    private StateListDrawable getSelectorDrawable() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919, 16842910}, (Drawable)this.getDrawable(16842919));
        stateListDrawable.addState(new int[]{-16842910}, (Drawable)this.getDrawable(-16842910));
        stateListDrawable.addState(new int[0], (Drawable)this.getDrawable(16842910));
        return stateListDrawable;
    }

    private GradientDrawable getDrawable(int state) {
        GradientDrawable gradientDrawable = new GradientDrawable();
        this.setShapeType(gradientDrawable);
        this.setGradient(gradientDrawable);
        this.setBorder(gradientDrawable);
        this.setRadius(gradientDrawable);
        this.setSize(gradientDrawable);
        this.setSelectorColor(gradientDrawable, state);
        return gradientDrawable;
    }

    public void into(View view) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)(this.useSelector ? this.getSelectorDrawable() : this.getDrawable(0)));
        } else {
            view.setBackgroundDrawable((Drawable)(this.useSelector ? this.getSelectorDrawable() : this.getDrawable(0)));
        }
    }

    private int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }
}

