/*
 * Decompiled with CFR 0.152.
 */
package com.lygttpod.shape.helper;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.lygttpod.shape.R;
import com.lygttpod.shape.data.AttributeSetData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/lygttpod/shape/helper/AttributeSetHelper;", "", "()V", "defaultColor", "", "defaultSelectorColor", "dip2px", "context", "Landroid/content/Context;", "dipValue", "", "loadFromAttributeSet", "Lcom/lygttpod/shape/data/AttributeSetData;", "attrs", "Landroid/util/AttributeSet;", "shape_release"})
public final class AttributeSetHelper {
    private final int defaultColor;
    private final int defaultSelectorColor;

    @NotNull
    public final AttributeSetData loadFromAttributeSet(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AttributeSetData attributeSetData = new AttributeSetData();
        if (attrs == null) {
            return attributeSetData;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026s, R.styleable.ShapeView)");
        TypedArray typedArray2 = typedArray;
        attributeSetData.setShapeType(typedArray2.getInt(R.styleable.ShapeView_shapeType, 0));
        attributeSetData.setSolidColor(typedArray2.getColor(R.styleable.ShapeView_shapeSolidColor, this.defaultColor));
        attributeSetData.setSelectorPressedColor(typedArray2.getColor(R.styleable.ShapeView_shapeSelectorPressedColor, this.defaultSelectorColor));
        attributeSetData.setSelectorDisableColor(typedArray2.getColor(R.styleable.ShapeView_shapeSelectorDisableColor, this.defaultSelectorColor));
        attributeSetData.setSelectorNormalColor(typedArray2.getColor(R.styleable.ShapeView_shapeSelectorNormalColor, this.defaultSelectorColor));
        attributeSetData.setCornersRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersRadius, 0));
        attributeSetData.setCornersTopLeftRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersTopLeftRadius, 0));
        attributeSetData.setCornersTopRightRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersTopRightRadius, 0));
        attributeSetData.setCornersBottomLeftRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersBottomLeftRadius, 0));
        attributeSetData.setCornersBottomRightRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeCornersBottomRightRadius, 0));
        attributeSetData.setStrokeWidth(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeStrokeWidth, 0));
        attributeSetData.setStrokeDashWidth(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeStrokeDashWidth, 0));
        attributeSetData.setStrokeDashGap(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeStrokeDashGap, 0));
        attributeSetData.setStrokeColor(typedArray2.getColor(R.styleable.ShapeView_shapeStrokeColor, this.defaultColor));
        attributeSetData.setSizeWidth(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeSizeWidth, 0));
        attributeSetData.setSizeHeight(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeSizeHeight, this.dip2px(context, 48.0f)));
        attributeSetData.setGradientAngle((int)typedArray2.getFloat(R.styleable.ShapeView_shapeGradientAngle, -1.0f));
        attributeSetData.setGradientCenterX(typedArray2.getFloat(R.styleable.ShapeView_shapeGradientCenterX, 0.0f));
        attributeSetData.setGradientCenterY(typedArray2.getFloat(R.styleable.ShapeView_shapeGradientCenterY, 0.0f));
        attributeSetData.setGradientGradientRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shapeGradientGradientRadius, 0));
        attributeSetData.setGradientStartColor(typedArray2.getColor(R.styleable.ShapeView_shapeGradientStartColor, -1));
        attributeSetData.setGradientCenterColor(typedArray2.getColor(R.styleable.ShapeView_shapeGradientCenterColor, -1));
        attributeSetData.setGradientEndColor(typedArray2.getColor(R.styleable.ShapeView_shapeGradientEndColor, -1));
        attributeSetData.setGradientType(typedArray2.getInt(R.styleable.ShapeView_shapeGradientType, 0));
        attributeSetData.setGradientUseLevel(typedArray2.getBoolean(R.styleable.ShapeView_shapeGradientUseLevel, false));
        attributeSetData.setUseSelector(typedArray2.getBoolean(R.styleable.ShapeView_shapeUseSelector, false));
        attributeSetData.setShowShadow(typedArray2.getBoolean(R.styleable.ShapeView_showShadow, false));
        attributeSetData.setShadowColor(typedArray2.getColor(R.styleable.ShapeView_shadowColor, -7829368));
        attributeSetData.setShadowColorAlpha(typedArray2.getFloat(R.styleable.ShapeView_shadowColorAlpha, 0.2f));
        attributeSetData.setShadowLeftWidth(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowLeftWidth, 0));
        attributeSetData.setShadowTopWidth(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowTopWidth, 0));
        attributeSetData.setShadowRightWidth(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowRightWidth, 0));
        attributeSetData.setShadowBottomWidth(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowBottomWidth, 0));
        attributeSetData.setShadowCornersRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowCornersRadius, 0));
        attributeSetData.setShadowCornersTopLeftRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowCornersTopLeftRadius, 0));
        attributeSetData.setShadowCornersTopRightRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowCornersTopRightRadius, 0));
        attributeSetData.setShadowCornersBottomLeftRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowCornersBottomLeftRadius, 0));
        attributeSetData.setShadowCornersBottomRightRadius(typedArray2.getDimensionPixelSize(R.styleable.ShapeView_shadowCornersBottomRightRadius, 0));
        typedArray2.recycle();
        return attributeSetData;
    }

    private final int dip2px(Context context, float dipValue) {
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public AttributeSetHelper() {
        this.defaultColor = 0xFFFFFF;
        this.defaultSelectorColor = 0x20000000;
    }
}

