/*
 * Decompiled with CFR 0.152.
 */
package com.lwjfork.code.text;

import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import com.lwjfork.code.base.BaseDrawer;

public abstract class BaseTextDrawer
extends BaseDrawer {
    protected int codeInputType;
    @ColorInt
    protected int codeTextColor;
    protected int codeTextSize;
    protected int dotRadius;
    protected Paint textPaint;
    protected String content = new String();

    public BaseTextDrawer() {
        this.initPaint();
    }

    public BaseTextDrawer(int codeInputType, int codeTextColor, int codeTextSize, int dotRadius) {
        this.codeInputType = codeInputType;
        this.codeTextColor = codeTextColor;
        this.codeTextSize = codeTextSize;
        this.dotRadius = dotRadius;
        this.initPaint();
    }

    public void initPaint() {
        this.textPaint = new Paint();
        this.textPaint.setColor(this.codeTextColor);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setTextSize((float)this.codeTextSize);
    }

    @Override
    public void drawCanvas() {
        if (this.canvas == null) {
            return;
        }
        if (this.textPaint == null) {
            this.initPaint();
        }
        this.clearCanvas(this.canvas);
        int length = this.content.length();
        for (int i = 0; i < length; ++i) {
            this.drawText((Rect)this.blockRects.get(i), this.content.charAt(i));
        }
    }

    protected abstract void drawText(Rect var1, char var2);

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.drawCanvas();
    }

    public int getCodeInputType() {
        return this.codeInputType;
    }

    public void setCodeInputType(int codeInputType) {
        this.codeInputType = codeInputType;
    }

    public int getCodeTextColor() {
        return this.codeTextColor;
    }

    public void setCodeTextColor(int codeTextColor) {
        this.codeTextColor = codeTextColor;
        this.textPaint.setColor(codeTextColor);
        this.drawCanvas();
    }

    public int getCodeTextSize() {
        return this.codeTextSize;
    }

    public void setCodeTextSize(int codeTextSize) {
        this.codeTextSize = codeTextSize;
        this.textPaint.setTextSize((float)codeTextSize);
        if (this.codeInputType == 2) {
            this.drawCanvas();
        }
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(int dotRadius) {
        this.dotRadius = dotRadius;
        if (this.codeInputType == 1) {
            this.drawCanvas();
        }
    }
}

