/*
 * Decompiled with CFR 0.152.
 */
package com.lwjfork.code.block;

import android.graphics.Paint;
import android.graphics.RectF;
import com.lwjfork.code.block.BaseBlockDrawer;

public class UnderlineBlockDrawer
extends BaseBlockDrawer {
    public UnderlineBlockDrawer() {
    }

    public UnderlineBlockDrawer(int blockNormalColor, int blockFocusedColor, int blockErrorColor, int blockShape, int blockLineWidth, int blockCorner) {
        super(blockNormalColor, blockFocusedColor, blockErrorColor, blockShape, blockLineWidth, blockCorner);
    }

    @Override
    protected void initPaint() {
        super.initPaint();
        this.blockPaint.setStyle(Paint.Style.FILL);
        this.blockPaint.setStrokeWidth((float)this.blockLineWidth);
    }

    @Override
    protected void drawFocusedBlock(RectF rectF) {
        this.drawLine(this.blockFocusColor, rectF);
    }

    @Override
    protected void drawNormalBlock(RectF rectF) {
        this.drawLine(this.blockNormalColor, rectF);
    }

    @Override
    protected void drawErrorBlock(RectF rectF) {
        this.drawLine(this.blockErrorColor, rectF);
    }

    private void drawLine(int color, RectF rectF) {
        if (rectF == null) {
            return;
        }
        this.blockPaint.setColor(color);
        this.canvas.drawLine(rectF.left, rectF.bottom - (float)this.blockLineWidth, rectF.right, rectF.bottom - (float)this.blockLineWidth, this.blockPaint);
    }
}

