/*
 * Decompiled with CFR 0.152.
 */
package com.lwjfork.code.block;

import android.graphics.Paint;
import android.graphics.RectF;
import com.lwjfork.code.block.BaseBlockDrawer;

public class SolidBlockDrawer
extends BaseBlockDrawer {
    public SolidBlockDrawer() {
    }

    public SolidBlockDrawer(int blockNormalColor, int blockFocusColor, int blockErrorColor, int blockShape, int blockLineWidth, int blockCorner) {
        super(blockNormalColor, blockFocusColor, blockErrorColor, blockShape, blockLineWidth, blockCorner);
    }

    @Override
    protected void initPaint() {
        super.initPaint();
        this.blockPaint.setStyle(Paint.Style.FILL);
    }

    @Override
    protected void drawFocusedBlock(RectF rectF) {
        this.drawRect(this.blockFocusColor, rectF);
    }

    @Override
    protected void drawNormalBlock(RectF rectF) {
        this.drawRect(this.blockNormalColor, rectF);
    }

    @Override
    protected void drawErrorBlock(RectF rectF) {
        this.drawRect(this.blockErrorColor, rectF);
    }

    private void drawRect(int color, RectF rectF) {
        if (rectF == null) {
            return;
        }
        this.blockPaint.setColor(color);
        this.canvas.drawRoundRect(rectF, (float)this.blockCorner, (float)this.blockCorner, this.blockPaint);
    }
}

