/*
 * Decompiled with CFR 0.152.
 */
package com.lwjfork.code.base;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import java.util.ArrayList;

public abstract class BaseDrawer {
    protected Canvas canvas;
    protected ArrayList<Rect> blockRects;
    protected int currentBlockIndex;
    private boolean isFocused = false;

    public Bitmap createBitmapAndCanvas(int measureWidth, int measureHeight) {
        Bitmap blockBitmap = Bitmap.createBitmap((int)measureWidth, (int)measureHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas();
        this.canvas.setBitmap(blockBitmap);
        return blockBitmap;
    }

    public void setBlockRects(ArrayList<Rect> blockRects) {
        this.blockRects = blockRects;
    }

    public void setCurrentBlockIndex(int currentBlockIndex) {
        this.currentBlockIndex = currentBlockIndex;
    }

    public void setFocused(boolean isFocused) {
        this.isFocused = isFocused;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    protected void clearCanvas(Canvas canvas) {
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public ArrayList<Rect> getBlockRects() {
        return this.blockRects;
    }

    public int getCurrentBlockIndex() {
        return this.currentBlockIndex;
    }

    public abstract void drawCanvas();
}

