/*
 * Decompiled with CFR 0.152.
 */
package com.lwjfork.code.block;

import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import com.lwjfork.code.base.BaseDrawer;

public abstract class BaseBlockDrawer
extends BaseDrawer {
    @ColorInt
    protected int blockNormalColor;
    @ColorInt
    protected int blockFocusColor;
    @ColorInt
    protected int blockErrorColor;
    protected int blockShape;
    protected int blockLineWidth;
    protected boolean isErrorState;
    protected Paint blockPaint;
    protected int blockCorner;

    public BaseBlockDrawer() {
        this.initPaint();
    }

    public BaseBlockDrawer(int blockNormalColor, int blockFocusColor, int blockErrorColor, int blockShape, int blockLineWidth, int blockCorner) {
        this.blockNormalColor = blockNormalColor;
        this.blockFocusColor = blockFocusColor;
        this.blockErrorColor = blockErrorColor;
        this.blockShape = blockShape;
        this.blockLineWidth = blockLineWidth;
        this.blockCorner = blockCorner;
        this.initPaint();
    }

    protected void initPaint() {
        this.blockPaint = new Paint();
        this.blockPaint.setAntiAlias(true);
        this.blockPaint.setColor(this.blockNormalColor);
    }

    @Override
    public final void drawCanvas() {
        if (this.canvas == null) {
            return;
        }
        this.clearCanvas(this.canvas);
        int size = this.blockRects.size();
        for (int i = 0; i < size; ++i) {
            if (i == this.currentBlockIndex && this.isFocused()) continue;
            RectF rectF = this.fixPosition(i);
            if (this.isErrorState) {
                this.drawErrorBlock(rectF);
                continue;
            }
            this.drawNormalBlock(rectF);
        }
        if (this.isFocused()) {
            this.drawFocusedBlock(this.fixPosition(this.currentBlockIndex));
        }
    }

    protected abstract void drawFocusedBlock(RectF var1);

    protected abstract void drawNormalBlock(RectF var1);

    protected abstract void drawErrorBlock(RectF var1);

    public int getBlockNormalColor() {
        return this.blockNormalColor;
    }

    public int getBlockShape() {
        return this.blockShape;
    }

    public void seBlockShape(int blockShape) {
        this.blockShape = blockShape;
        this.drawCanvas();
    }

    public int getBlockLineWidth() {
        return this.blockLineWidth;
    }

    public void setBlockLineWidth(int blockLineWidth) {
        this.blockLineWidth = blockLineWidth;
        if (this.blockShape == 1 || this.blockShape == 3) {
            this.blockPaint.setStrokeWidth((float)blockLineWidth);
            this.drawCanvas();
        }
    }

    public void setBlockNormalColor(int blockNormalColor) {
        this.blockNormalColor = blockNormalColor;
        this.drawCanvas();
    }

    public int getBlockFocusColor() {
        return this.blockFocusColor;
    }

    public void setBlockFocusColor(int blockFocusColor) {
        this.blockFocusColor = blockFocusColor;
        this.drawCanvas();
    }

    public int getBlockErrorColor() {
        return this.blockErrorColor;
    }

    public void setBlockErrorColor(int blockErrorColor) {
        this.blockErrorColor = blockErrorColor;
        this.drawCanvas();
    }

    public int getBlockCorner() {
        return this.blockCorner;
    }

    public void setBlockCorner(int blockCorner) {
        this.blockCorner = blockCorner;
        if (this.blockShape == 1 || this.blockShape == 2) {
            this.drawCanvas();
        }
    }

    protected RectF fixPosition(int i) {
        if (i >= 0 && i < this.blockRects.size()) {
            Rect rect = (Rect)this.blockRects.get(i);
            if (this.blockShape == 3) {
                return new RectF(rect);
            }
            int left = rect.left;
            int top = rect.top;
            int right = rect.right;
            int bottom = rect.bottom;
            if (i == 0) {
                left += this.blockLineWidth / 2;
            } else if (i == this.blockRects.size() - 1) {
                right -= this.blockLineWidth / 2;
            }
            return new RectF((float)left, (float)(top += this.blockLineWidth / 2), (float)right, (float)(bottom -= this.blockLineWidth));
        }
        return null;
    }

    public boolean isErrorState() {
        return this.isErrorState;
    }

    public void setErrorState(boolean errorState) {
        this.isErrorState = errorState;
        this.drawCanvas();
    }
}

