/*
 * Decompiled with CFR 0.152.
 */
package com.lwjfork.code;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.support.annotation.Px;
import android.text.Editable;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.ActionMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.widget.EditText;
import android.widget.TextView;
import com.lwjfork.code.R;
import com.lwjfork.code.block.BaseBlockDrawer;
import com.lwjfork.code.block.NoneBlockDrawer;
import com.lwjfork.code.block.SolidBlockDrawer;
import com.lwjfork.code.block.StrokeBlockDrawer;
import com.lwjfork.code.block.UnderlineBlockDrawer;
import com.lwjfork.code.cusor.CursorDrawer;
import com.lwjfork.code.text.BaseTextDrawer;
import com.lwjfork.code.text.NoneTextDrawer;
import com.lwjfork.code.text.PasswordTextDrawer;
import com.lwjfork.code.text.TextDrawer;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class CodeEditText
extends EditText {
    @ColorInt
    protected int blockNormalColor;
    @ColorInt
    protected int blockFocusColor;
    @ColorInt
    protected int blockErrorColor;
    protected int blockShape;
    protected int blockLineWidth;
    protected int codeInputType;
    @ColorInt
    protected int codeTextColor;
    protected int codeTextSize;
    protected int dotRadius;
    protected int blockCorner;
    private int blockSpace;
    private int maxCodeLength;
    private boolean showCursor;
    private int cursorDuration;
    private int cursorWidth;
    @ColorInt
    private int cursorColor;
    private Bitmap blockBitmap;
    private Bitmap textBitmap;
    private Bitmap cursorBitmap;
    private ArrayList<Rect> blockRects;
    private BaseBlockDrawer blockDrawer;
    private BaseTextDrawer textDrawer;
    private CursorDrawer cursorDrawer;
    protected Context mContext;
    private DisplayMetrics metrics;
    OnTextChangedListener onTextChangedListener;
    boolean errorState;

    public CodeEditText(Context context) {
        this(context, null);
    }

    public CodeEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CodeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public CodeEditText(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mContext = context;
        this.metrics = this.mContext.getResources().getDisplayMetrics();
        this.parseAttrs(context, attrs, defStyleAttr, defStyleRes);
        this.forbidCopyAndPaste();
        this.initEditText();
    }

    private void parseAttrs(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.CodeEditText, defStyleAttr, defStyleRes);
        this.maxCodeLength = typedArray.getInteger(R.styleable.CodeEditText_maxCodeLength, 6);
        this.codeTextColor = typedArray.getColor(R.styleable.CodeEditText_codeTextColor, -16777216);
        this.codeTextSize = typedArray.getDimensionPixelSize(R.styleable.CodeEditText_codeTextSize, this.sp2px(12.0f));
        this.dotRadius = typedArray.getDimensionPixelSize(R.styleable.CodeEditText_dotRadius, this.dp2px(5.0f));
        this.codeInputType = typedArray.getInteger(R.styleable.CodeEditText_codeInputType, -1);
        this.textDrawer = this.createTextDrawer(this.codeInputType, this.codeTextColor, this.codeTextSize, this.dotRadius);
        this.blockNormalColor = typedArray.getColor(R.styleable.CodeEditText_blockNormalColor, this.codeTextColor);
        this.blockFocusColor = typedArray.getColor(R.styleable.CodeEditText_blockFocusColor, this.blockNormalColor);
        this.blockErrorColor = typedArray.getColor(R.styleable.CodeEditText_blockErrorColor, this.blockNormalColor);
        this.blockLineWidth = typedArray.getDimensionPixelSize(R.styleable.CodeEditText_blockLineWidth, this.dp2px(1.0f));
        this.blockCorner = typedArray.getDimensionPixelSize(R.styleable.CodeEditText_blockCorner, 0);
        this.blockSpace = typedArray.getDimensionPixelSize(R.styleable.CodeEditText_blockSpace, 0);
        this.blockShape = typedArray.getInteger(R.styleable.CodeEditText_blockShape, -1);
        this.blockDrawer = this.createBlockDrawer(this.blockNormalColor, this.blockFocusColor, this.blockErrorColor, this.blockShape, this.blockLineWidth, this.blockCorner);
        this.showCursor = typedArray.getBoolean(R.styleable.CodeEditText_showCursor, false);
        this.cursorDuration = typedArray.getInteger(R.styleable.CodeEditText_cursorDuration, 500);
        this.cursorWidth = typedArray.getDimensionPixelSize(R.styleable.CodeEditText_blockCorner, this.dp2px(1.0f));
        this.cursorColor = typedArray.getColor(R.styleable.CodeEditText_cursorColor, this.blockNormalColor);
        this.cursorDrawer = this.createCursorDrawer(this.showCursor, this.cursorDuration, this.cursorWidth, this.cursorColor);
        typedArray.recycle();
    }

    private CursorDrawer createCursorDrawer(boolean showCursor, int cursorDuration, int cursorWidth, int cursorColor) {
        return new CursorDrawer(showCursor, cursorDuration, cursorWidth, cursorColor);
    }

    private BaseBlockDrawer createBlockDrawer(int blockNormalColor, int blockFocusColor, int blockErrorColor, int blockShape, int blockLineWidth, int blockCorner) {
        switch (blockShape) {
            case 2: {
                return new SolidBlockDrawer(blockNormalColor, blockFocusColor, blockErrorColor, blockShape, blockLineWidth, blockCorner);
            }
            case 1: {
                return new StrokeBlockDrawer(blockNormalColor, blockFocusColor, blockErrorColor, blockShape, blockLineWidth, blockCorner);
            }
            case 3: {
                return new UnderlineBlockDrawer(blockNormalColor, blockFocusColor, blockErrorColor, blockShape, blockLineWidth, blockCorner);
            }
        }
        return new NoneBlockDrawer(blockNormalColor, blockFocusColor, blockErrorColor, blockShape, blockLineWidth, blockCorner);
    }

    private BaseTextDrawer createTextDrawer(int codeInputType, int codeTextColor, int codeTextSize, int dotRadius) {
        switch (codeInputType) {
            case 2: {
                return new TextDrawer(codeInputType, codeTextColor, codeTextSize, dotRadius);
            }
            case 1: {
                return new PasswordTextDrawer(codeInputType, codeTextColor, codeTextSize, dotRadius);
            }
        }
        return new NoneTextDrawer(codeInputType, codeTextColor, codeTextSize, dotRadius);
    }

    private void initEditText() {
        this.setCursorVisible(false);
        this.setTextColor(0);
        this.setBackgroundDrawable(null);
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.maxCodeLength)});
        this.setSingleLine();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measureWidth = this.getMeasuredWidth();
        int measureHeight = this.getMeasuredHeight();
        this.initRect(measureWidth, measureHeight);
        this.initBitmapAndCanvas(measureWidth, measureHeight);
    }

    private void initRect(int measureWidth, int measureHeight) {
        if (this.blockRects == null) {
            this.blockRects = new ArrayList();
        }
        this.blockRects.clear();
        int startX = 0;
        int startY = 0;
        int endX = 0;
        int endY = 0;
        int blockWidth = (measureWidth - this.blockSpace * (this.maxCodeLength - 1)) / 6;
        int blockHeight = measureHeight;
        for (int i = 0; i < this.maxCodeLength; ++i) {
            endX = startX + blockWidth;
            endY = startY + blockHeight;
            Rect blockRect = new Rect(startX, startY, endX, endY);
            this.blockRects.add(blockRect);
            startX = endX + this.blockSpace;
            startY = 0;
        }
        this.blockDrawer.setBlockRects(this.blockRects);
        this.textDrawer.setBlockRects(this.blockRects);
        this.cursorDrawer.setBlockRects(this.blockRects);
    }

    private void initBitmapAndCanvas(int measureWidth, int measureHeight) {
        this.blockBitmap = this.blockDrawer.createBitmapAndCanvas(measureWidth, measureHeight);
        this.textBitmap = this.textDrawer.createBitmapAndCanvas(measureWidth, measureHeight);
        this.cursorBitmap = this.cursorDrawer.createBitmapAndCanvas(measureWidth, measureHeight);
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.blockBitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(this.textBitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(this.cursorBitmap, 0.0f, 0.0f, null);
        this.blockDrawer.drawCanvas();
        this.textDrawer.drawCanvas();
        this.cursorDrawer.drawCanvas();
        if (this.isInEditMode()) {
            this.textDrawer.setContent("111");
        }
    }

    private void forbidCopyAndPaste() {
        this.setLongClickable(false);
        this.setTextIsSelectable(false);
        this.setCustomSelectionActionModeCallback(new ActionMode.Callback(){

            public boolean onCreateActionMode(ActionMode mode, Menu menu) {
                return false;
            }

            public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
                return false;
            }

            public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
                return false;
            }

            public void onDestroyActionMode(ActionMode mode) {
            }
        });
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 0) {
            this.setInsertionDisabled();
        }
        return super.onTouchEvent(event);
    }

    public boolean onTextContextMenuItem(int id2) {
        if (id2 == 0x1020022) {
            return false;
        }
        return super.onTextContextMenuItem(id2);
    }

    private void setInsertionDisabled() {
        try {
            Field editorField = TextView.class.getDeclaredField("mEditor");
            editorField.setAccessible(true);
            Object editorObject = editorField.get((Object)this);
            Class<?> editorClass = Class.forName("android.widget.Editor");
            Field mInsertionControllerEnabledField = editorClass.getDeclaredField("mInsertionControllerEnabled");
            mInsertionControllerEnabledField.setAccessible(true);
            mInsertionControllerEnabledField.set(editorObject, false);
            Field mSelectionControllerEnabledField = editorClass.getDeclaredField("mSelectionControllerEnabled");
            mSelectionControllerEnabledField.setAccessible(true);
            mSelectionControllerEnabledField.set(editorObject, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSuggestionsEnabled() {
        return false;
    }

    public void delete() {
        Editable editable = this.getText();
        if (editable.length() > 0) {
            editable.delete(editable.length() - 1, editable.length());
        }
    }

    public void addChar(char c) {
        Editable editable = this.getText();
        editable.append(c);
    }

    public void addCharSequence(CharSequence sequence) {
        Editable editable = this.getText();
        editable.append(sequence);
    }

    public void setOnTextChangedListener(OnTextChangedListener onTextChangedListener) {
        this.onTextChangedListener = onTextChangedListener;
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (this.isInEditMode()) {
            return;
        }
        if (lengthBefore == lengthAfter && lengthBefore == 0) {
            return;
        }
        int currentBlockIndex = text.toString().length();
        if (this.onTextChangedListener != null) {
            this.onTextChangedListener.onCodeChanged(text.toString());
            if (text.length() == this.maxCodeLength) {
                this.onTextChangedListener.onInputCompleted(text.toString());
            }
        }
        this.blockDrawer.setCurrentBlockIndex(currentBlockIndex);
        this.textDrawer.setCurrentBlockIndex(currentBlockIndex);
        this.cursorDrawer.setCurrentBlockIndex(currentBlockIndex);
        this.textDrawer.setContent(this.getText().toString());
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        this.blockDrawer.setFocused(focused);
        this.textDrawer.setFocused(focused);
        this.cursorDrawer.setFocused(focused);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.recycleBitmap(this.blockBitmap);
        this.recycleBitmap(this.textBitmap);
        this.recycleBitmap(this.cursorBitmap);
    }

    private void recycleBitmap(Bitmap bitmap) {
        if (bitmap != null && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
    }

    public void clearContent() {
        this.getEditableText().clear();
    }

    public boolean isErrorState() {
        return this.errorState;
    }

    public void setErrorState(boolean errorState) {
        this.errorState = errorState;
        this.blockDrawer.setErrorState(errorState);
    }

    public int getBlockNormalColor() {
        return this.blockNormalColor;
    }

    public void setBlockNormalColor(@ColorInt int blockNormalColor) {
        this.blockNormalColor = blockNormalColor;
        if (this.blockDrawer != null) {
            this.blockDrawer.setBlockNormalColor(blockNormalColor);
        }
    }

    public int getBlockFocusColor() {
        return this.blockFocusColor;
    }

    public void setBlockFocusColor(@ColorInt int blockFocusColor) {
        this.blockFocusColor = blockFocusColor;
        if (this.blockDrawer != null) {
            this.blockDrawer.setBlockFocusColor(blockFocusColor);
        }
    }

    public int getBlockErrorColor() {
        return this.blockErrorColor;
    }

    public void setBlockErrorColor(@ColorInt int blockErrorColor) {
        this.blockErrorColor = blockErrorColor;
        if (this.blockDrawer != null) {
            this.blockDrawer.setBlockErrorColor(blockErrorColor);
        }
    }

    public int getBlockLineWidth() {
        return this.blockLineWidth;
    }

    public void setBlockLineWidth(int blockLineWidth) {
        this.blockLineWidth = blockLineWidth;
        if (this.blockDrawer != null) {
            this.blockDrawer.setBlockLineWidth(blockLineWidth);
        }
    }

    public int getCorner() {
        return this.blockCorner;
    }

    public void setBlockCorner(int blockCorner) {
        this.blockCorner = blockCorner;
        if (this.blockDrawer != null) {
            this.blockDrawer.setBlockCorner(blockCorner);
        }
    }

    public int getBlockSpace() {
        return this.blockSpace;
    }

    public void setBlockSpace(int blockSpace) {
        this.blockSpace = blockSpace;
        this.requestLayout();
    }

    public int getCodeTextColor() {
        return this.codeTextColor;
    }

    public void setCodeTextColor(@ColorInt int codeTextColor) {
        this.codeTextColor = codeTextColor;
        if (this.textDrawer != null) {
            this.textDrawer.setCodeTextColor(codeTextColor);
        }
    }

    public int getCodeTextSize() {
        return this.codeTextSize;
    }

    public void setCodeTextSize(@Px int codeTextSize) {
        this.codeTextSize = codeTextSize;
        if (this.textDrawer != null) {
            this.textDrawer.setCodeTextSize(codeTextSize);
        }
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(@Px int dotRadius) {
        this.dotRadius = dotRadius;
        if (this.textDrawer != null) {
            this.textDrawer.setDotRadius(dotRadius);
        }
    }

    public int getMaxCodeLength() {
        return this.maxCodeLength;
    }

    public void setMaxCodeLength(int maxCodeLength) {
        this.maxCodeLength = maxCodeLength;
        this.requestLayout();
    }

    public boolean isShowCursor() {
        return this.cursorDrawer.isShowCursor();
    }

    public void setShowCursor(boolean showCursor) {
        this.cursorDrawer.setShowCursor(showCursor);
    }

    public int getCursorDuration() {
        return 1000;
    }

    public void setCursorDuration(int cursorDuration) {
        this.cursorDrawer.setCursorDuration(cursorDuration);
    }

    public int getCursorWidth() {
        return this.cursorDrawer.getCursorWidth();
    }

    public void setCursorWidth(@Px int cursorWidth) {
        this.cursorDrawer.setCursorWidth(cursorWidth);
    }

    public int getCursorColor() {
        return this.cursorDrawer.getCursorColor();
    }

    public void setCursorColor(@ColorInt int cursorColor) {
        this.cursorDrawer.setCursorColor(cursorColor);
    }

    public int getBlockShape() {
        return this.blockDrawer.getBlockShape();
    }

    public void setBlockShape(BaseBlockDrawer newBlockDrawer) {
        if (newBlockDrawer == null) {
            return;
        }
        if (this.blockDrawer != null) {
            newBlockDrawer.setFocused(this.blockDrawer.isFocused());
            newBlockDrawer.setBlockRects(this.blockDrawer.getBlockRects());
            newBlockDrawer.setErrorState(this.blockDrawer.isErrorState());
            newBlockDrawer.setCurrentBlockIndex(this.blockDrawer.getCurrentBlockIndex());
            newBlockDrawer.setBlockCorner(this.blockDrawer.getBlockCorner());
            newBlockDrawer.setBlockErrorColor(this.blockDrawer.getBlockErrorColor());
            newBlockDrawer.setBlockFocusColor(this.blockDrawer.getBlockFocusColor());
            newBlockDrawer.setBlockNormalColor(this.blockDrawer.getBlockNormalColor());
            newBlockDrawer.setBlockLineWidth(this.blockDrawer.getBlockLineWidth());
            newBlockDrawer.setCanvas(this.blockDrawer.getCanvas());
            this.blockDrawer = newBlockDrawer;
            this.invalidate();
        } else {
            this.blockDrawer = newBlockDrawer;
            this.blockDrawer.setErrorState(this.errorState);
            this.blockDrawer.setBlockRects(this.blockRects);
            this.requestLayout();
        }
    }

    public void setBlockShape(int blockShape) {
        if (blockShape == this.blockDrawer.getBlockShape()) {
            return;
        }
        BaseBlockDrawer newBlockDrawer = this.createBlockDrawer(this.blockNormalColor, this.blockFocusColor, this.blockErrorColor, blockShape, this.blockLineWidth, this.blockCorner);
        this.setBlockShape(newBlockDrawer);
    }

    public int getCodeInputType() {
        return this.textDrawer.getCodeInputType();
    }

    public void setCodeInputType(int codeInputType) {
        if (codeInputType == this.textDrawer.getCodeInputType()) {
            return;
        }
        BaseTextDrawer newTextDrawer = this.createTextDrawer(codeInputType, this.codeTextColor, this.codeTextSize, this.dotRadius);
        this.setCodeInputType(newTextDrawer);
    }

    public void setCodeInputType(BaseTextDrawer newTextDrawer) {
        if (newTextDrawer == null) {
            return;
        }
        if (this.textDrawer != null) {
            newTextDrawer.setFocused(this.textDrawer.isFocused());
            newTextDrawer.setBlockRects(this.textDrawer.getBlockRects());
            newTextDrawer.setCurrentBlockIndex(this.textDrawer.getCurrentBlockIndex());
            newTextDrawer.setContent(this.textDrawer.getContent());
            newTextDrawer.setCodeTextSize(this.textDrawer.getCodeTextSize());
            newTextDrawer.setCodeTextColor(this.textDrawer.getCodeTextColor());
            newTextDrawer.setDotRadius(this.textDrawer.getDotRadius());
            newTextDrawer.setCanvas(this.textDrawer.getCanvas());
            this.textDrawer = newTextDrawer;
            this.invalidate();
        } else {
            this.textDrawer = newTextDrawer;
            this.textDrawer.setBlockRects(this.blockRects);
            this.requestLayout();
        }
    }

    public int dp2px(float dp) {
        float density = this.metrics.density;
        return (int)(dp * density + 0.5f);
    }

    public int sp2px(float sp) {
        return (int)(sp * this.metrics.scaledDensity + 0.5f);
    }

    public static interface OnTextChangedListener {
        public void onCodeChanged(CharSequence var1);

        public void onInputCompleted(CharSequence var1);
    }
}

