/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse.internal.loader;

import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.MergeCursor;
import android.net.Uri;
import android.provider.MediaStore;
import androidx.loader.content.CursorLoader;
import com.zhihu.matisse.internal.entity.Album;
import com.zhihu.matisse.internal.entity.SelectionSpec;

public class AlbumLoader
extends CursorLoader {
    public static final String COLUMN_COUNT = "count";
    private static final Uri QUERY_URI = MediaStore.Files.getContentUri((String)"external");
    private static final String[] COLUMNS = new String[]{"_id", "bucket_id", "bucket_display_name", "_data", "mime_type", "count"};
    private static final String[] PROJECTION = new String[]{"_id", "bucket_id", "bucket_display_name", "_data", "mime_type", "COUNT(*) AS count"};
    private static final String SELECTION = "(media_type=? OR media_type=?) AND _size>0) GROUP BY (bucket_id";
    private static final String[] SELECTION_ARGS = new String[]{String.valueOf(1), String.valueOf(3)};
    private static final String SELECTION_FOR_SINGLE_MEDIA_TYPE = "media_type=? AND _size>0) GROUP BY (bucket_id";
    private static final String SELECTION_FOR_SINGLE_MEDIA_GIF_TYPE = "media_type=? AND _size>0 AND mime_type=?) GROUP BY (bucket_id";
    private static final String BUCKET_ORDER_BY = "datetaken DESC";

    private static String[] getSelectionArgsForSingleMediaType(int mediaType) {
        return new String[]{String.valueOf(mediaType)};
    }

    private static String[] getSelectionArgsForSingleMediaGifType(int mediaType) {
        return new String[]{String.valueOf(mediaType), "image/gif"};
    }

    private AlbumLoader(Context context, String selection, String[] selectionArgs) {
        super(context, QUERY_URI, PROJECTION, selection, selectionArgs, BUCKET_ORDER_BY);
    }

    public static CursorLoader newInstance(Context context) {
        String[] selectionArgs;
        String selection;
        if (SelectionSpec.getInstance().onlyShowGif()) {
            selection = SELECTION_FOR_SINGLE_MEDIA_GIF_TYPE;
            selectionArgs = AlbumLoader.getSelectionArgsForSingleMediaGifType(1);
        } else if (SelectionSpec.getInstance().onlyShowImages()) {
            selection = SELECTION_FOR_SINGLE_MEDIA_TYPE;
            selectionArgs = AlbumLoader.getSelectionArgsForSingleMediaType(1);
        } else if (SelectionSpec.getInstance().onlyShowVideos()) {
            selection = SELECTION_FOR_SINGLE_MEDIA_TYPE;
            selectionArgs = AlbumLoader.getSelectionArgsForSingleMediaType(3);
        } else {
            selection = SELECTION;
            selectionArgs = SELECTION_ARGS;
        }
        return new AlbumLoader(context, selection, selectionArgs);
    }

    public Cursor loadInBackground() {
        Cursor albums = super.loadInBackground();
        MatrixCursor allAlbum = new MatrixCursor(COLUMNS);
        int totalCount = 0;
        String allAlbumCoverPath = "";
        if (albums != null) {
            while (albums.moveToNext()) {
                totalCount += albums.getInt(albums.getColumnIndex(COLUMN_COUNT));
            }
            if (albums.moveToFirst()) {
                allAlbumCoverPath = albums.getString(albums.getColumnIndex("_data"));
            }
        }
        allAlbum.addRow((Object[])new String[]{Album.ALBUM_ID_ALL, Album.ALBUM_ID_ALL, "All", allAlbumCoverPath, "", String.valueOf(totalCount)});
        return new MergeCursor(new Cursor[]{allAlbum, albums});
    }

    public void onContentChanged() {
    }
}

