/*
 * Decompiled with CFR 0.152.
 */
package com.zhihu.matisse;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.app.Fragment;
import com.zhihu.matisse.Matisse;
import com.zhihu.matisse.MimeType;
import com.zhihu.matisse.engine.ImageEngine;
import com.zhihu.matisse.filter.Filter;
import com.zhihu.matisse.internal.entity.CaptureStrategy;
import com.zhihu.matisse.internal.entity.SelectionSpec;
import com.zhihu.matisse.listener.OnCheckedListener;
import com.zhihu.matisse.listener.OnSelectedListener;
import com.zhihu.matisse.ui.MatisseActivity;
import java.util.ArrayList;
import java.util.Set;

public final class SelectionCreator {
    private final Matisse mMatisse;
    private final SelectionSpec mSelectionSpec;

    SelectionCreator(Matisse matisse, @NonNull Set<MimeType> mimeTypes, boolean mediaTypeExclusive) {
        this.mMatisse = matisse;
        this.mSelectionSpec = SelectionSpec.getCleanInstance();
        this.mSelectionSpec.mimeTypeSet = mimeTypes;
        this.mSelectionSpec.mediaTypeExclusive = mediaTypeExclusive;
        this.mSelectionSpec.orientation = -1;
    }

    public SelectionCreator showSingleMediaType(boolean showSingleMediaType) {
        this.mSelectionSpec.showSingleMediaType = showSingleMediaType;
        return this;
    }

    public SelectionCreator theme(@StyleRes int themeId) {
        this.mSelectionSpec.themeId = themeId;
        return this;
    }

    public SelectionCreator countable(boolean countable) {
        this.mSelectionSpec.countable = countable;
        return this;
    }

    public SelectionCreator maxSelectable(int maxSelectable) {
        if (maxSelectable < 1) {
            throw new IllegalArgumentException("maxSelectable must be greater than or equal to one");
        }
        if (this.mSelectionSpec.maxImageSelectable > 0 || this.mSelectionSpec.maxVideoSelectable > 0) {
            throw new IllegalStateException("already set maxImageSelectable and maxVideoSelectable");
        }
        this.mSelectionSpec.maxSelectable = maxSelectable;
        return this;
    }

    public SelectionCreator maxSelectablePerMediaType(int maxImageSelectable, int maxVideoSelectable) {
        if (maxImageSelectable < 1 || maxVideoSelectable < 1) {
            throw new IllegalArgumentException("max selectable must be greater than or equal to one");
        }
        this.mSelectionSpec.maxSelectable = -1;
        this.mSelectionSpec.maxImageSelectable = maxImageSelectable;
        this.mSelectionSpec.maxVideoSelectable = maxVideoSelectable;
        return this;
    }

    public SelectionCreator addFilter(@NonNull Filter filter) {
        if (this.mSelectionSpec.filters == null) {
            this.mSelectionSpec.filters = new ArrayList<Filter>();
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter cannot be null");
        }
        this.mSelectionSpec.filters.add(filter);
        return this;
    }

    public SelectionCreator capture(boolean enable) {
        this.mSelectionSpec.capture = enable;
        return this;
    }

    public SelectionCreator originalEnable(boolean enable) {
        this.mSelectionSpec.originalable = enable;
        return this;
    }

    public SelectionCreator autoHideToolbarOnSingleTap(boolean enable) {
        this.mSelectionSpec.autoHideToobar = enable;
        return this;
    }

    public SelectionCreator maxOriginalSize(int size) {
        this.mSelectionSpec.originalMaxSize = size;
        return this;
    }

    public SelectionCreator captureStrategy(CaptureStrategy captureStrategy) {
        this.mSelectionSpec.captureStrategy = captureStrategy;
        return this;
    }

    public SelectionCreator restrictOrientation(int orientation) {
        this.mSelectionSpec.orientation = orientation;
        return this;
    }

    public SelectionCreator spanCount(int spanCount) {
        if (spanCount < 1) {
            throw new IllegalArgumentException("spanCount cannot be less than 1");
        }
        this.mSelectionSpec.spanCount = spanCount;
        return this;
    }

    public SelectionCreator gridExpectedSize(int size) {
        this.mSelectionSpec.gridExpectedSize = size;
        return this;
    }

    public SelectionCreator thumbnailScale(float scale) {
        if (scale <= 0.0f || scale > 1.0f) {
            throw new IllegalArgumentException("Thumbnail scale must be between (0.0, 1.0]");
        }
        this.mSelectionSpec.thumbnailScale = scale;
        return this;
    }

    public SelectionCreator imageEngine(ImageEngine imageEngine) {
        this.mSelectionSpec.imageEngine = imageEngine;
        return this;
    }

    @NonNull
    public SelectionCreator setOnSelectedListener(@Nullable OnSelectedListener listener) {
        this.mSelectionSpec.onSelectedListener = listener;
        return this;
    }

    public SelectionCreator setOnCheckedListener(@Nullable OnCheckedListener listener) {
        this.mSelectionSpec.onCheckedListener = listener;
        return this;
    }

    public void forResult(int requestCode) {
        Activity activity = this.mMatisse.getActivity();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, MatisseActivity.class);
        Fragment fragment = this.mMatisse.getFragment();
        if (fragment != null) {
            fragment.startActivityForResult(intent, requestCode);
        } else {
            activity.startActivityForResult(intent, requestCode);
        }
    }
}

