/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.utils;

import com.luues.openoffice.core.OfficeDocumentConverter;
import com.luues.openoffice.utils.ConverterUtils;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OfficeToPdf {
    @Autowired
    ConverterUtils converterUtils;

    public boolean openOfficeToPDF(String inputFilePath, String outputFilePath) {
        return this.office2pdf(inputFilePath, outputFilePath);
    }

    public static void converterFile(File inputFile, String outputFilePath_end, String inputFilePath, String outputFilePath, OfficeDocumentConverter converter) {
        File outputFile = new File(outputFilePath_end);
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        converter.convert(inputFile, outputFile);
    }

    public boolean office2pdf(String inputFilePath, String outputFilePath) {
        boolean flag = false;
        OfficeDocumentConverter converter = this.converterUtils.getDocumentConverter();
        if (null != inputFilePath) {
            File inputFile = new File(inputFilePath);
            if (null == outputFilePath) {
                String outputFilePath_end = OfficeToPdf.getOutputFilePath(inputFilePath);
                if (inputFile.exists()) {
                    OfficeToPdf.converterFile(inputFile, outputFilePath_end, inputFilePath, outputFilePath, converter);
                    flag = true;
                }
            } else if (inputFile.exists()) {
                OfficeToPdf.converterFile(inputFile, outputFilePath, inputFilePath, outputFilePath, converter);
                flag = true;
            }
        } else {
            flag = false;
        }
        return flag;
    }

    public static String getOutputFilePath(String inputFilePath) {
        String outputFilePath = inputFilePath.replaceAll("." + OfficeToPdf.getPostfix(inputFilePath), ".pdf");
        return outputFilePath;
    }

    public static String getPostfix(String inputFilePath) {
        return inputFilePath.substring(inputFilePath.lastIndexOf(".") + 1);
    }
}

