/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.luues.openoffice.config.ConfigConstants;
import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.ReturnResponse;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.utils.DownloadUtils;
import com.luues.openoffice.utils.FileUtils;
import com.luues.openoffice.utils.PdfUtils;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PdfFilePreviewImpl
implements FilePreview {
    @Autowired
    FileUtils fileUtils;
    @Autowired
    PdfUtils pdfUtils;
    @Autowired
    DownloadUtils downloadUtils;
    @Autowired
    private ConfigConstants configConstants;

    @Override
    public JSONObject filePreviewHandle(FileAttribute fileAttribute) {
        JSONObject jsonObject = new JSONObject();
        String suffix = fileAttribute.getSuffix();
        String fileName = fileAttribute.getName();
        String officePreviewType = this.configConstants.getOfficePreviewType();
        String originUrl = fileAttribute.getUrl();
        jsonObject.put("pdfUrl", (Object)originUrl);
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf";
        String outFilePath = this.configConstants.getFileDir() + pdfName;
        if ("image".equals(officePreviewType) || "allImages".equals(officePreviewType)) {
            List<String> imageUrls;
            if (!new File(outFilePath).exists()) {
                ReturnResponse<String> response = this.downloadUtils.downLoad(fileAttribute, fileName);
                if (0 != response.getCode()) {
                    jsonObject.put("fileType", (Object)suffix);
                    jsonObject.put("msg", (Object)response.getMsg());
                    jsonObject.put("path", (Object)"fileNotSupported");
                    return jsonObject;
                }
                outFilePath = response.getContent();
            }
            if ((imageUrls = this.pdfUtils.pdf2jpg(outFilePath, pdfName, originUrl)) == null || imageUrls.size() < 1) {
                jsonObject.put("msg", (Object)"pdf\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                jsonObject.put("fileType", (Object)fileAttribute.getSuffix());
                jsonObject.put("path", (Object)"fileNotSupported");
                return jsonObject;
            }
            jsonObject.put("imgurls", imageUrls);
            jsonObject.put("currentUrl", (Object)imageUrls.get(0));
            if ("image".equals(officePreviewType)) {
                jsonObject.put("path", (Object)"officePicture");
            } else {
                jsonObject.put("path", (Object)"picture");
            }
            return jsonObject;
        }
        jsonObject.put("path", (Object)"pdf");
        return jsonObject;
    }
}

