/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.service;

import com.luues.openoffice.model.FileAttribute;
import com.luues.openoffice.model.FileType;
import com.luues.openoffice.service.FilePreview;
import com.luues.openoffice.service.FilePreviewFactory;
import com.luues.openoffice.service.cache.CacheService;
import com.luues.openoffice.utils.FileUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileConverQueueTask {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String queueTaskName = "FileConverQueueTask";
    @Autowired
    FilePreviewFactory previewFactory;
    @Autowired
    CacheService cacheService;
    @Autowired
    FileUtils fileUtils;

    @PostConstruct
    public void startTask() {
        ExecutorService executorService = Executors.newFixedThreadPool(3);
        executorService.submit(new ConverTask(this.previewFactory, this.cacheService, this.fileUtils));
        this.logger.info("Queue Processing File Conversion Task Start Completed");
    }

    class ConverTask
    implements Runnable {
        FilePreviewFactory previewFactory;
        CacheService cacheService;
        FileUtils fileUtils;

        public ConverTask(FilePreviewFactory previewFactory, CacheService cacheService, FileUtils fileUtils) {
            this.previewFactory = previewFactory;
            this.cacheService = cacheService;
            this.fileUtils = fileUtils;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String url;
                        if ((url = this.cacheService.takeQueueTask()) == null) {
                            continue;
                        }
                        FileAttribute fileAttribute = this.fileUtils.getFileAttribute(url);
                        FileConverQueueTask.this.logger.info("\u6b63\u5728\u5904\u7406\u8f6c\u6362\u4efb\u52a1\uff0c\u6587\u4ef6\u540d\u79f0\u3010{}\u3011", (Object)fileAttribute.getName());
                        FileType fileType = fileAttribute.getType();
                        if (!fileType.equals((Object)FileType.compress) && !fileType.equals((Object)FileType.office)) continue;
                        FilePreview filePreview = this.previewFactory.get(fileAttribute);
                        filePreview.filePreviewHandle(fileAttribute);
                    }
                }
                catch (Exception e) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

