/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.core.document;

import com.luues.openoffice.core.document.DocumentFamily;
import com.luues.openoffice.core.document.DocumentFormat;
import com.luues.openoffice.core.document.DocumentFormatRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleDocumentFormatRegistry
implements DocumentFormatRegistry {
    private List<DocumentFormat> documentFormats = new ArrayList<DocumentFormat>();

    public void addFormat(DocumentFormat documentFormat) {
        this.documentFormats.add(documentFormat);
    }

    @Override
    public DocumentFormat getFormatByExtension(String extension) {
        if (extension == null) {
            return null;
        }
        String lowerExtension = extension.toLowerCase();
        for (DocumentFormat format : this.documentFormats) {
            if (!format.getExtension().equals(lowerExtension)) continue;
            return format;
        }
        return null;
    }

    @Override
    public DocumentFormat getFormatByMediaType(String mediaType) {
        if (mediaType == null) {
            return null;
        }
        for (DocumentFormat format : this.documentFormats) {
            if (!format.getMediaType().equals(mediaType)) continue;
            return format;
        }
        return null;
    }

    @Override
    public Set<DocumentFormat> getOutputFormats(DocumentFamily family) {
        HashSet<DocumentFormat> formats = new HashSet<DocumentFormat>();
        for (DocumentFormat format : this.documentFormats) {
            if (format.getStoreProperties(family) == null) continue;
            formats.add(format);
        }
        return formats;
    }
}

