/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.core;

import com.luues.openoffice.core.AbstractConversionTask;
import com.luues.openoffice.core.OfficeDocumentUtils;
import com.luues.openoffice.core.document.DocumentFamily;
import com.luues.openoffice.core.document.DocumentFormat;
import com.luues.openoffice.core.office.OfficeException;
import com.luues.openoffice.core.office.OfficeUtils;
import com.sun.star.lang.XComponent;
import com.sun.star.util.XRefreshable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class StandardConversionTask
extends AbstractConversionTask {
    private final DocumentFormat outputFormat;
    private Map<String, ?> defaultLoadProperties;
    private DocumentFormat inputFormat;

    public StandardConversionTask(File inputFile, File outputFile, DocumentFormat outputFormat) {
        super(inputFile, outputFile);
        this.outputFormat = outputFormat;
    }

    public void setDefaultLoadProperties(Map<String, ?> defaultLoadProperties) {
        this.defaultLoadProperties = defaultLoadProperties;
    }

    public void setInputFormat(DocumentFormat inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Override
    protected void modifyDocument(XComponent document) throws OfficeException {
        XRefreshable refreshable = OfficeUtils.cast(XRefreshable.class, document);
        if (refreshable != null) {
            refreshable.refresh();
        }
    }

    @Override
    protected Map<String, ?> getLoadProperties(File inputFile) {
        HashMap loadProperties = new HashMap();
        if (this.defaultLoadProperties != null) {
            loadProperties.putAll(this.defaultLoadProperties);
        }
        if (this.inputFormat != null && this.inputFormat.getLoadProperties() != null) {
            loadProperties.putAll(this.inputFormat.getLoadProperties());
        }
        return loadProperties;
    }

    @Override
    protected Map<String, ?> getStoreProperties(File outputFile, XComponent document) {
        DocumentFamily family = OfficeDocumentUtils.getDocumentFamily(document);
        return this.outputFormat.getStoreProperties(family);
    }
}

