/*
 * Decompiled with CFR 0.152.
 */
package com.luues.openoffice.config;

import com.luues.openoffice.config.ApplicationData;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigConstants {
    private String[] simText = new String[0];
    private String[] media = new String[0];
    private String convertedFileCharset;
    private String officePreviewType;
    private String ftpUsername;
    private String ftpPassword;
    private String ftpControlEncoding;
    private String fileDir;
    private String homePath;
    @Autowired
    private ApplicationData applicationData;

    @PostConstruct
    public void init() {
        this.fileDir = this.applicationData.getFileDir();
        this.simText = this.applicationData.getSimText().split(",");
        this.media = this.applicationData.getMedia().split(",");
        this.convertedFileCharset = this.applicationData.getConvertedFileCharset();
        this.officePreviewType = this.applicationData.getOfficePreviewType();
        this.ftpUsername = this.applicationData.getFtpUsername();
        this.ftpPassword = this.applicationData.getFtpPassword();
        this.ftpControlEncoding = this.applicationData.getFtpControlEncoding();
    }

    public String getFileDir() {
        if (null == this.fileDir || "null".equals(this.fileDir)) {
            this.fileDir = ConfigConstants.class.getClassLoader().getResource("").getPath() + "fileDir/";
        }
        return this.fileDir;
    }

    public String getHomePath() {
        if (null == this.homePath || "null".equals(this.homePath)) {
            this.homePath = ConfigConstants.class.getClassLoader().getResource("").getPath();
        }
        return this.homePath;
    }

    public String[] getSimText() {
        return this.simText;
    }

    public String[] getMedia() {
        return this.media;
    }

    public String getConvertedFileCharset() {
        return this.convertedFileCharset;
    }

    public String getOfficePreviewType() {
        return this.officePreviewType;
    }

    public String getFtpUsername() {
        return this.ftpUsername;
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public String getFtpControlEncoding() {
        return this.ftpControlEncoding;
    }

    public ApplicationData getApplicationData() {
        return this.applicationData;
    }

    public void setSimText(String[] simText) {
        this.simText = simText;
    }

    public void setMedia(String[] media) {
        this.media = media;
    }

    public void setConvertedFileCharset(String convertedFileCharset) {
        this.convertedFileCharset = convertedFileCharset;
    }

    public void setOfficePreviewType(String officePreviewType) {
        this.officePreviewType = officePreviewType;
    }

    public void setFtpUsername(String ftpUsername) {
        this.ftpUsername = ftpUsername;
    }

    public void setFtpPassword(String ftpPassword) {
        this.ftpPassword = ftpPassword;
    }

    public void setFtpControlEncoding(String ftpControlEncoding) {
        this.ftpControlEncoding = ftpControlEncoding;
    }

    public void setFileDir(String fileDir) {
        this.fileDir = fileDir;
    }

    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }

    public void setApplicationData(ApplicationData applicationData) {
        this.applicationData = applicationData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigConstants)) {
            return false;
        }
        ConfigConstants other = (ConfigConstants)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSimText(), other.getSimText())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMedia(), other.getMedia())) {
            return false;
        }
        String this$convertedFileCharset = this.getConvertedFileCharset();
        String other$convertedFileCharset = other.getConvertedFileCharset();
        if (this$convertedFileCharset == null ? other$convertedFileCharset != null : !this$convertedFileCharset.equals(other$convertedFileCharset)) {
            return false;
        }
        String this$officePreviewType = this.getOfficePreviewType();
        String other$officePreviewType = other.getOfficePreviewType();
        if (this$officePreviewType == null ? other$officePreviewType != null : !this$officePreviewType.equals(other$officePreviewType)) {
            return false;
        }
        String this$ftpUsername = this.getFtpUsername();
        String other$ftpUsername = other.getFtpUsername();
        if (this$ftpUsername == null ? other$ftpUsername != null : !this$ftpUsername.equals(other$ftpUsername)) {
            return false;
        }
        String this$ftpPassword = this.getFtpPassword();
        String other$ftpPassword = other.getFtpPassword();
        if (this$ftpPassword == null ? other$ftpPassword != null : !this$ftpPassword.equals(other$ftpPassword)) {
            return false;
        }
        String this$ftpControlEncoding = this.getFtpControlEncoding();
        String other$ftpControlEncoding = other.getFtpControlEncoding();
        if (this$ftpControlEncoding == null ? other$ftpControlEncoding != null : !this$ftpControlEncoding.equals(other$ftpControlEncoding)) {
            return false;
        }
        String this$fileDir = this.getFileDir();
        String other$fileDir = other.getFileDir();
        if (this$fileDir == null ? other$fileDir != null : !this$fileDir.equals(other$fileDir)) {
            return false;
        }
        String this$homePath = this.getHomePath();
        String other$homePath = other.getHomePath();
        if (this$homePath == null ? other$homePath != null : !this$homePath.equals(other$homePath)) {
            return false;
        }
        ApplicationData this$applicationData = this.getApplicationData();
        ApplicationData other$applicationData = other.getApplicationData();
        return !(this$applicationData == null ? other$applicationData != null : !((Object)this$applicationData).equals(other$applicationData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigConstants;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getSimText());
        result = result * 59 + Arrays.deepHashCode(this.getMedia());
        String $convertedFileCharset = this.getConvertedFileCharset();
        result = result * 59 + ($convertedFileCharset == null ? 43 : $convertedFileCharset.hashCode());
        String $officePreviewType = this.getOfficePreviewType();
        result = result * 59 + ($officePreviewType == null ? 43 : $officePreviewType.hashCode());
        String $ftpUsername = this.getFtpUsername();
        result = result * 59 + ($ftpUsername == null ? 43 : $ftpUsername.hashCode());
        String $ftpPassword = this.getFtpPassword();
        result = result * 59 + ($ftpPassword == null ? 43 : $ftpPassword.hashCode());
        String $ftpControlEncoding = this.getFtpControlEncoding();
        result = result * 59 + ($ftpControlEncoding == null ? 43 : $ftpControlEncoding.hashCode());
        String $fileDir = this.getFileDir();
        result = result * 59 + ($fileDir == null ? 43 : $fileDir.hashCode());
        String $homePath = this.getHomePath();
        result = result * 59 + ($homePath == null ? 43 : $homePath.hashCode());
        ApplicationData $applicationData = this.getApplicationData();
        result = result * 59 + ($applicationData == null ? 43 : ((Object)$applicationData).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigConstants(simText=" + Arrays.deepToString(this.getSimText()) + ", media=" + Arrays.deepToString(this.getMedia()) + ", convertedFileCharset=" + this.getConvertedFileCharset() + ", officePreviewType=" + this.getOfficePreviewType() + ", ftpUsername=" + this.getFtpUsername() + ", ftpPassword=" + this.getFtpPassword() + ", ftpControlEncoding=" + this.getFtpControlEncoding() + ", fileDir=" + this.getFileDir() + ", homePath=" + this.getHomePath() + ", applicationData=" + this.getApplicationData() + ")";
    }
}

