/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import io.github.luizgrp.sectionedrecyclerviewadapter.Section;
import io.github.luizgrp.sectionedrecyclerviewadapter.SectionAdapter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.map.ListOrderedMap;

public class SectionedRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int VIEW_TYPE_HEADER = 0;
    public static final int VIEW_TYPE_FOOTER = 1;
    public static final int VIEW_TYPE_ITEM_LOADED = 2;
    public static final int VIEW_TYPE_LOADING = 3;
    public static final int VIEW_TYPE_FAILED = 4;
    public static final int VIEW_TYPE_EMPTY = 5;
    private final transient ListOrderedMap<String, Section> sections = new ListOrderedMap();
    private final transient Map<String, Integer> sectionViewTypeNumbers = new LinkedHashMap<String, Integer>();
    private final transient Map<Section, SectionAdapter> sectionAdapters = new HashMap<Section, SectionAdapter>();
    private transient int viewTypeCount;
    private static final int VIEW_TYPE_QTY = 6;

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder = null;
        block8: for (Map.Entry<String, Integer> entry : this.sectionViewTypeNumbers.entrySet()) {
            if (viewType < entry.getValue() || viewType >= entry.getValue() + 6) continue;
            Section section = (Section)this.sections.get((Object)entry.getKey());
            int sectionViewType = viewType - entry.getValue();
            switch (sectionViewType) {
                case 0: {
                    viewHolder = this.getHeaderViewHolder(parent, section);
                    continue block8;
                }
                case 1: {
                    viewHolder = this.getFooterViewHolder(parent, section);
                    continue block8;
                }
                case 2: {
                    viewHolder = this.getItemViewHolder(parent, section);
                    continue block8;
                }
                case 3: {
                    viewHolder = this.getLoadingViewHolder(parent, section);
                    continue block8;
                }
                case 4: {
                    viewHolder = this.getFailedViewHolder(parent, section);
                    continue block8;
                }
                case 5: {
                    viewHolder = this.getEmptyViewHolder(parent, section);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid viewType");
        }
        return viewHolder;
    }

    private RecyclerView.ViewHolder getItemViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isItemViewWillBeProvided()) {
            view = section.getItemView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getItemView() returned null");
            }
        } else {
            Integer resId = section.getItemResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'item' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getItemViewHolder(view);
    }

    private RecyclerView.ViewHolder getHeaderViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isHeaderViewWillBeProvided()) {
            view = section.getHeaderView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getHeaderView() returned null");
            }
        } else {
            Integer resId = section.getHeaderResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'header' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getHeaderViewHolder(view);
    }

    private RecyclerView.ViewHolder getFooterViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isFooterViewWillBeProvided()) {
            view = section.getFooterView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getFooterView() returned null");
            }
        } else {
            Integer resId = section.getFooterResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'footer' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getFooterViewHolder(view);
    }

    private RecyclerView.ViewHolder getLoadingViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isLoadingViewWillBeProvided()) {
            view = section.getLoadingView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getLoadingView() returned null");
            }
        } else {
            Integer resId = section.getLoadingResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'loading' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getLoadingViewHolder(view);
    }

    private RecyclerView.ViewHolder getFailedViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isFailedViewWillBeProvided()) {
            view = section.getFailedView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getFailedView() returned null");
            }
        } else {
            Integer resId = section.getFailedResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'failed' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getFailedViewHolder(view);
    }

    private RecyclerView.ViewHolder getEmptyViewHolder(ViewGroup parent, Section section) {
        View view;
        if (section.isEmptyViewWillBeProvided()) {
            view = section.getEmptyView(parent);
            if (view == null) {
                throw new NullPointerException("Section.getEmptyView() returned null");
            }
        } else {
            Integer resId = section.getEmptyResourceId();
            if (resId == null) {
                throw new NullPointerException("Missing 'empty' resource id");
            }
            view = this.inflate(resId, parent);
        }
        return section.getEmptyViewHolder(view);
    }

    public String addSection(Section section) {
        String tag = this.generateSectionTag();
        this.addSection(tag, section);
        return tag;
    }

    public void addSection(String tag, Section section) {
        this.addSection(this.sections.size(), tag, section);
    }

    public void addSection(int index, String tag, Section section) {
        this.sections.put(index, (Object)tag, (Object)section);
        this.addSectionViewTypeNumbers(tag);
        SectionAdapter result = this.sectionAdapters.put(section, new SectionAdapter(this, section));
        if (result != null) {
            throw new IllegalArgumentException("This adapter already contains this Section");
        }
    }

    public String addSection(int index, Section section) {
        String tag = this.generateSectionTag();
        this.addSection(index, tag, section);
        return tag;
    }

    private String generateSectionTag() {
        return UUID.randomUUID().toString();
    }

    private void addSectionViewTypeNumbers(String tag) {
        this.sectionViewTypeNumbers.put(tag, this.viewTypeCount);
        this.viewTypeCount += 6;
    }

    public Section getSection(String tag) {
        return (Section)this.sections.get((Object)tag);
    }

    public void removeSection(Section section) {
        String tag = null;
        for (Map.Entry entry : this.sections.entrySet()) {
            if (entry.getValue() != section) continue;
            tag = (String)entry.getKey();
        }
        if (tag != null) {
            this.removeSection(tag);
        }
    }

    public void removeSection(String tag) {
        Section section = (Section)this.sections.remove((Object)tag);
        this.sectionViewTypeNumbers.remove(tag);
        this.sectionAdapters.remove(section);
    }

    public void removeAllSections() {
        this.sections.clear();
        this.sectionViewTypeNumbers.clear();
        this.sectionAdapters.clear();
        this.viewTypeCount = 0;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        this.internalOnBindViewHolder(holder, position, null);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (payloads.isEmpty()) {
            super.onBindViewHolder(holder, position, payloads);
            return;
        }
        this.internalOnBindViewHolder(holder, position, payloads);
    }

    private void internalOnBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        int currentPos = 0;
        for (Map.Entry entry : this.sections.entrySet()) {
            Section section = (Section)entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                if (section.hasHeader() && position == currentPos) {
                    if (payloads == null) {
                        this.getSectionForPosition(position).onBindHeaderViewHolder(holder);
                    } else {
                        this.getSectionForPosition(position).onBindHeaderViewHolder(holder, payloads);
                    }
                    return;
                }
                if (section.hasFooter() && position == currentPos + sectionTotal - 1) {
                    if (payloads == null) {
                        this.getSectionForPosition(position).onBindFooterViewHolder(holder);
                    } else {
                        this.getSectionForPosition(position).onBindFooterViewHolder(holder, payloads);
                    }
                    return;
                }
                this.onBindContentViewHolder(this.getSectionForPosition(position), holder, position, payloads);
                return;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    private void onBindContentViewHolder(@NonNull Section section, @NonNull RecyclerView.ViewHolder holder, int position, List<Object> payloads) {
        switch (section.getState()) {
            case LOADING: {
                if (payloads == null) {
                    section.onBindLoadingViewHolder(holder);
                    break;
                }
                section.onBindLoadingViewHolder(holder, payloads);
                break;
            }
            case LOADED: {
                if (payloads == null) {
                    section.onBindItemViewHolder(holder, this.getPositionInSection(position));
                    break;
                }
                section.onBindItemViewHolder(holder, this.getPositionInSection(position), payloads);
                break;
            }
            case FAILED: {
                if (payloads == null) {
                    section.onBindFailedViewHolder(holder);
                    break;
                }
                section.onBindFailedViewHolder(holder, payloads);
                break;
            }
            case EMPTY: {
                if (payloads == null) {
                    section.onBindEmptyViewHolder(holder);
                    break;
                }
                section.onBindEmptyViewHolder(holder, payloads);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state");
            }
        }
    }

    public int getItemCount() {
        int count = 0;
        for (Map.Entry entry : this.sections.entrySet()) {
            Section section = (Section)entry.getValue();
            if (!section.isVisible()) continue;
            count += section.getSectionItemsTotal();
        }
        return count;
    }

    public int getItemViewType(int position) {
        int currentPos = 0;
        for (Map.Entry entry : this.sections.entrySet()) {
            Section section = (Section)entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                int viewType = this.sectionViewTypeNumbers.get(entry.getKey());
                if (section.hasHeader() && position == currentPos) {
                    return viewType;
                }
                if (section.hasFooter() && position == currentPos + sectionTotal - 1) {
                    return viewType + 1;
                }
                switch (section.getState()) {
                    case LOADED: {
                        return viewType + 2;
                    }
                    case LOADING: {
                        return viewType + 3;
                    }
                    case FAILED: {
                        return viewType + 4;
                    }
                    case EMPTY: {
                        return viewType + 5;
                    }
                }
                throw new IllegalStateException("Invalid state");
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public static int getSectionItemViewTypeForAdapterViewType(int itemViewType) {
        return itemViewType % 6;
    }

    public int getSectionItemViewType(int position) {
        int viewType = this.getItemViewType(position);
        return SectionedRecyclerViewAdapter.getSectionItemViewTypeForAdapterViewType(viewType);
    }

    public Section getSectionForPosition(int position) {
        int currentPos = 0;
        for (Map.Entry entry : this.sections.entrySet()) {
            Section section = (Section)entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                return section;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public int getPositionInSection(int position) {
        int currentPos = 0;
        for (Map.Entry entry : this.sections.entrySet()) {
            Section section = (Section)entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                int result = position - currentPos - (section.hasHeader() ? 1 : 0);
                if (result == -1 || result == section.getContentItemsTotal()) {
                    throw new IllegalArgumentException("This method is not applicable for header or footer position");
                }
                return result;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    ListOrderedMap<String, Section> getSections() {
        return this.sections;
    }

    @NonNull
    public Map<String, Section> getCopyOfSectionsMap() {
        return ListOrderedMap.listOrderedMap(this.sections);
    }

    public int getSectionCount() {
        return this.sections.size();
    }

    public Section getSection(int index) {
        return (Section)this.sections.getValue(index);
    }

    public int getSectionIndex(Section section) {
        int index = 0;
        for (Map.Entry entry : this.sections.entrySet()) {
            if (entry.getValue() == section) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public SectionAdapter getAdapterForSection(String tag) {
        Section section = this.getValidSectionOrThrowException(tag);
        return this.getAdapterForSection(section);
    }

    public SectionAdapter getAdapterForSection(Section section) {
        SectionAdapter sectionAdapter = this.sectionAdapters.get(section);
        if (sectionAdapter == null) {
            throw new IllegalArgumentException("Invalid section");
        }
        return sectionAdapter;
    }

    @VisibleForTesting
    public View inflate(@LayoutRes int layoutResourceId, ViewGroup parent) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(layoutResourceId, parent, false);
    }

    @NonNull
    private Section getValidSectionOrThrowException(String tag) {
        Section section = this.getSection(tag);
        if (section == null) {
            throw new IllegalArgumentException("Invalid tag: " + tag);
        }
        return section;
    }
}

