/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.github.luizgrp.sectionedrecyclerviewadapter.Section;
import io.github.luizgrp.sectionedrecyclerviewadapter.SectionNotifier;
import io.github.luizgrp.sectionedrecyclerviewadapter.SectionPositionIdentifier;
import io.github.luizgrp.sectionedrecyclerviewadapter.SectionedRecyclerViewAdapter;
import java.util.Map;

public class SectionAdapter
implements SectionPositionIdentifier,
SectionNotifier {
    private final transient SectionedRecyclerViewAdapter sectionedAdapter;
    private final transient Section section;

    SectionAdapter(SectionedRecyclerViewAdapter sectionedAdapter, Section section) {
        this.sectionedAdapter = sectionedAdapter;
        this.section = section;
    }

    @VisibleForTesting
    Section getSection() {
        return this.section;
    }

    @Override
    public int getHeaderPosition() {
        if (!this.section.hasHeader()) {
            throw new IllegalStateException("Section doesn't have a header");
        }
        return this.getSectionPosition();
    }

    @Override
    public int getFooterPosition() {
        if (!this.section.hasFooter()) {
            throw new IllegalStateException("Section doesn't have a footer");
        }
        return this.getSectionPosition() + this.section.getSectionItemsTotal() - 1;
    }

    @Override
    public int getSectionPosition() {
        int currentPos = 0;
        for (Map.Entry entry : this.sectionedAdapter.getSections().entrySet()) {
            Section loopSection = (Section)entry.getValue();
            if (!loopSection.isVisible()) continue;
            if (loopSection == this.section) {
                return currentPos;
            }
            int sectionTotal = loopSection.getSectionItemsTotal();
            currentPos += sectionTotal;
        }
        throw new IllegalArgumentException("Section is not in the adapter.");
    }

    @Override
    public int getPositionInAdapter(int position) {
        return this.getSectionPosition() + (this.section.hasHeader() ? 1 : 0) + position;
    }

    @Override
    public int getPositionInSection(int position) {
        return this.sectionedAdapter.getPositionInSection(position);
    }

    @Override
    public void notifyItemInserted(int position) {
        this.sectionedAdapter.notifyItemInserted(this.getPositionInAdapter(position));
    }

    @Override
    public void notifyAllItemsInserted() {
        this.sectionedAdapter.notifyItemRangeInserted(this.getPositionInAdapter(0), this.section.getContentItemsTotal());
    }

    @Override
    public void notifyItemRangeInserted(int positionStart, int itemCount) {
        this.sectionedAdapter.notifyItemRangeInserted(this.getPositionInAdapter(positionStart), itemCount);
    }

    @Override
    public void notifyItemRemoved(int position) {
        this.sectionedAdapter.notifyItemRemoved(this.getPositionInAdapter(position));
    }

    @Override
    public void notifyItemRangeRemoved(int positionStart, int itemCount) {
        this.sectionedAdapter.notifyItemRangeRemoved(this.getPositionInAdapter(positionStart), itemCount);
    }

    @Override
    public void notifyHeaderChanged() {
        this.sectionedAdapter.notifyItemChanged(this.getHeaderPosition());
    }

    @Override
    public void notifyHeaderChanged(@Nullable Object payload) {
        this.sectionedAdapter.notifyItemChanged(this.getHeaderPosition(), payload);
    }

    @Override
    public void notifyFooterChanged() {
        this.sectionedAdapter.notifyItemChanged(this.getFooterPosition());
    }

    @Override
    public void notifyFooterChanged(@Nullable Object payload) {
        this.sectionedAdapter.notifyItemChanged(this.getFooterPosition(), payload);
    }

    @Override
    public void notifyItemChanged(int position) {
        this.sectionedAdapter.notifyItemChanged(this.getPositionInAdapter(position));
    }

    @Override
    public void notifyItemChanged(int position, @Nullable Object payload) {
        this.sectionedAdapter.notifyItemChanged(this.getPositionInAdapter(position), payload);
    }

    @Override
    public void notifyAllItemsChanged() {
        this.sectionedAdapter.notifyItemRangeChanged(this.getPositionInAdapter(0), this.section.getContentItemsTotal());
    }

    @Override
    public void notifyAllItemsChanged(@Nullable Object payload) {
        this.sectionedAdapter.notifyItemRangeChanged(this.getPositionInAdapter(0), this.section.getContentItemsTotal(), payload);
    }

    @Override
    public void notifyItemRangeChanged(int positionStart, int itemCount) {
        this.sectionedAdapter.notifyItemRangeChanged(this.getPositionInAdapter(positionStart), itemCount);
    }

    @Override
    public void notifyItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
        this.sectionedAdapter.notifyItemRangeChanged(this.getPositionInAdapter(positionStart), itemCount, payload);
    }

    @Override
    public void notifyItemMoved(int fromPosition, int toPosition) {
        this.sectionedAdapter.notifyItemMoved(this.getPositionInAdapter(fromPosition), this.getPositionInAdapter(toPosition));
    }

    @Override
    public void notifyNotLoadedStateChanged(Section.State previousState) {
        Section.State state = this.section.getState();
        if (state == previousState) {
            throw new IllegalStateException("No state changed");
        }
        if (previousState == Section.State.LOADED) {
            throw new IllegalStateException("Use notifyStateChangedFromLoaded");
        }
        if (state == Section.State.LOADED) {
            throw new IllegalStateException("Use notifyStateChangedToLoaded");
        }
        this.notifyItemChanged(0);
    }

    @Override
    public void notifyStateChangedToLoaded(Section.State previousState) {
        Section.State state = this.section.getState();
        if (state == previousState) {
            throw new IllegalStateException("No state changed");
        }
        if (state != Section.State.LOADED) {
            if (previousState == Section.State.LOADED) {
                throw new IllegalStateException("Use notifyStateChangedFromLoaded");
            }
            throw new IllegalStateException("Use notifyNotLoadedStateChanged");
        }
        int contentItemsTotal = this.section.getContentItemsTotal();
        if (contentItemsTotal == 0) {
            this.notifyItemRemoved(0);
        } else {
            this.notifyItemChanged(0);
            if (contentItemsTotal > 1) {
                this.notifyItemRangeInserted(1, contentItemsTotal - 1);
            }
        }
    }

    @Override
    public void notifyStateChangedFromLoaded(int previousContentItemsCount) {
        if (previousContentItemsCount < 0) {
            throw new IllegalArgumentException("previousContentItemsCount cannot have a negative value");
        }
        Section.State state = this.section.getState();
        if (state == Section.State.LOADED) {
            throw new IllegalStateException("Use notifyStateChangedToLoaded");
        }
        if (previousContentItemsCount == 0) {
            this.notifyItemInserted(0);
        } else {
            if (previousContentItemsCount > 1) {
                this.notifyItemRangeRemoved(1, previousContentItemsCount - 1);
            }
            this.notifyItemChanged(0);
        }
    }

    @Override
    public void notifyHeaderInserted() {
        int headerPosition = this.getHeaderPosition();
        this.sectionedAdapter.notifyItemInserted(headerPosition);
    }

    @Override
    public void notifyFooterInserted() {
        int footerPosition = this.getFooterPosition();
        this.sectionedAdapter.notifyItemInserted(footerPosition);
    }

    @Override
    public void notifyHeaderRemoved() {
        int position = this.getSectionPosition();
        this.sectionedAdapter.notifyItemRemoved(position);
    }

    @Override
    public void notifyFooterRemoved() {
        int position = this.getSectionPosition() + this.section.getSectionItemsTotal();
        this.sectionedAdapter.notifyItemRemoved(position);
    }

    @Override
    public void notifySectionChangedToVisible() {
        if (!this.section.isVisible()) {
            throw new IllegalStateException("This section is not visible.");
        }
        int sectionPosition = this.getSectionPosition();
        int sectionItemsTotal = this.section.getSectionItemsTotal();
        this.sectionedAdapter.notifyItemRangeInserted(sectionPosition, sectionItemsTotal);
    }

    @Override
    public void notifySectionChangedToInvisible(int previousSectionPosition) {
        if (this.section.isVisible()) {
            throw new IllegalStateException("This section is not invisible.");
        }
        int sectionItemsTotal = this.section.getSectionItemsTotal();
        this.sectionedAdapter.notifyItemRangeRemoved(previousSectionPosition, sectionItemsTotal);
    }
}

