/*
 * Decompiled with CFR 0.152.
 */
package io.github.luizgrp.sectionedrecyclerviewadapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.github.luizgrp.sectionedrecyclerviewadapter.Section;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class SectionedRecyclerViewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    public static final int VIEW_TYPE_HEADER = 0;
    public static final int VIEW_TYPE_FOOTER = 1;
    public static final int VIEW_TYPE_ITEM_LOADED = 2;
    public static final int VIEW_TYPE_LOADING = 3;
    public static final int VIEW_TYPE_FAILED = 4;
    private LinkedHashMap<String, Section> sections = new LinkedHashMap();
    private HashMap<String, Integer> sectionViewTypeNumbers = new HashMap();
    private int viewTypeCount = 0;
    private static final int VIEW_TYPE_QTY = 5;

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder viewHolder = null;
        block7: for (Map.Entry<String, Integer> entry : this.sectionViewTypeNumbers.entrySet()) {
            if (viewType < entry.getValue() || viewType >= entry.getValue() + 5) continue;
            Section section = this.sections.get(entry.getKey());
            int sectionViewType = viewType - entry.getValue();
            switch (sectionViewType) {
                case 0: {
                    viewHolder = this.getHeaderViewHolder(parent, section);
                    continue block7;
                }
                case 1: {
                    viewHolder = this.getFooterViewHolder(parent, section);
                    continue block7;
                }
                case 2: {
                    viewHolder = this.getItemViewHolder(parent, section);
                    continue block7;
                }
                case 3: {
                    viewHolder = this.getLoadingViewHolder(parent, section);
                    continue block7;
                }
                case 4: {
                    viewHolder = this.getFailedViewHolder(parent, section);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Invalid viewType");
        }
        return viewHolder;
    }

    private RecyclerView.ViewHolder getItemViewHolder(ViewGroup parent, Section section) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(section.getItemResourceId(), parent, false);
        return section.getItemViewHolder(view);
    }

    private RecyclerView.ViewHolder getHeaderViewHolder(ViewGroup parent, Section section) {
        Integer resId = section.getHeaderResourceId();
        if (resId == null) {
            throw new NullPointerException("Missing 'header' resource id");
        }
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(resId.intValue(), parent, false);
        return section.getHeaderViewHolder(view);
    }

    private RecyclerView.ViewHolder getFooterViewHolder(ViewGroup parent, Section section) {
        Integer resId = section.getFooterResourceId();
        if (resId == null) {
            throw new NullPointerException("Missing 'footer' resource id");
        }
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(resId.intValue(), parent, false);
        return section.getFooterViewHolder(view);
    }

    private RecyclerView.ViewHolder getLoadingViewHolder(ViewGroup parent, Section section) {
        Integer resId = section.getLoadingResourceId();
        if (resId == null) {
            throw new NullPointerException("Missing 'loading state' resource id");
        }
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(resId.intValue(), parent, false);
        return section.getLoadingViewHolder(view);
    }

    private RecyclerView.ViewHolder getFailedViewHolder(ViewGroup parent, Section section) {
        Integer resId = section.getFailedResourceId();
        if (resId == null) {
            throw new NullPointerException("Missing 'failed state' resource id");
        }
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(resId.intValue(), parent, false);
        return section.getFailedViewHolder(view);
    }

    public void addSection(String tag, Section section) {
        this.sections.put(tag, section);
        this.sectionViewTypeNumbers.put(tag, this.viewTypeCount);
        this.viewTypeCount += 5;
    }

    public String addSection(Section section) {
        String tag = UUID.randomUUID().toString();
        this.addSection(tag, section);
        return tag;
    }

    public Section getSection(String tag) {
        return this.sections.get(tag);
    }

    public void removeSection(String tag) {
        this.sections.remove(tag);
    }

    public void removeAllSections() {
        this.sections.clear();
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                if (section.hasHeader() && position == currentPos) {
                    this.getSectionForPosition(position).onBindHeaderViewHolder(holder);
                    return;
                }
                if (section.hasFooter() && position == currentPos + sectionTotal - 1) {
                    this.getSectionForPosition(position).onBindFooterViewHolder(holder);
                    return;
                }
                this.getSectionForPosition(position).onBindContentViewHolder(holder, this.getPositionInSection(position));
                return;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public int getItemCount() {
        int count = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            count += section.getSectionItemsTotal();
        }
        return count;
    }

    public int getItemViewType(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                int viewType = this.sectionViewTypeNumbers.get(entry.getKey());
                if (section.hasHeader() && position == currentPos) {
                    return viewType;
                }
                if (section.hasFooter() && position == currentPos + sectionTotal - 1) {
                    return viewType + 1;
                }
                switch (section.getState()) {
                    case LOADED: {
                        return viewType + 2;
                    }
                    case LOADING: {
                        return viewType + 3;
                    }
                    case FAILED: {
                        return viewType + 4;
                    }
                }
                throw new IllegalStateException("Invalid state");
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public int getSectionItemViewType(int position) {
        int viewType = this.getItemViewType(position);
        return viewType % 5;
    }

    public Section getSectionForPosition(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                return section;
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    @Deprecated
    public int getSectionPosition(int position) {
        return this.getPositionInSection(position);
    }

    public int getPositionInSection(int position) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (position >= currentPos && position <= currentPos + sectionTotal - 1) {
                return position - currentPos - (section.hasHeader() ? 1 : 0);
            }
            currentPos += sectionTotal;
        }
        throw new IndexOutOfBoundsException("Invalid position");
    }

    public int getSectionPosition(String tag) {
        int currentPos = 0;
        for (Map.Entry<String, Section> entry : this.sections.entrySet()) {
            Section section = entry.getValue();
            if (!section.isVisible()) continue;
            int sectionTotal = section.getSectionItemsTotal();
            if (entry.getKey().equalsIgnoreCase(tag)) {
                return currentPos;
            }
            currentPos += sectionTotal;
        }
        throw new IllegalArgumentException("Invalid tag: " + tag);
    }

    public LinkedHashMap<String, Section> getSectionsMap() {
        return this.sections;
    }

    public void notifyItemInsertedInSection(String tag, int position) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.callSuperNotifyItemInserted(this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + position);
    }

    void callSuperNotifyItemInserted(int position) {
        super.notifyItemInserted(position);
    }

    public void notifyItemRangeInsertedInSection(String tag, int positionStart, int itemCount) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.callSuperNotifyItemRangeInserted(this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + positionStart, itemCount);
    }

    void callSuperNotifyItemRangeInserted(int positionStart, int itemCount) {
        super.notifyItemRangeInserted(positionStart, itemCount);
    }

    public void notifyItemRemovedFromSection(String tag, int position) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.callSuperNotifyItemRemoved(this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + position);
    }

    void callSuperNotifyItemRemoved(int position) {
        super.notifyItemRemoved(position);
    }

    public void notifyItemRangeRemovedFromSection(String tag, int positionStart, int itemCount) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.callSuperNotifyItemRangeRemoved(this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + positionStart, itemCount);
    }

    void callSuperNotifyItemRangeRemoved(int positionStart, int itemCount) {
        super.notifyItemRangeRemoved(positionStart, itemCount);
    }

    public void notifyItemChangedInSection(String tag, int position) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.callSuperNotifyItemChanged(this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + position);
    }

    void callSuperNotifyItemChanged(int position) {
        super.notifyItemChanged(position);
    }

    public void notifyItemRangeChangedInSection(String tag, int positionStart, int itemCount) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.callSuperNotifyItemRangeChanged(this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + positionStart, itemCount);
    }

    void callSuperNotifyItemRangeChanged(int positionStart, int itemCount) {
        super.notifyItemRangeChanged(positionStart, itemCount);
    }

    public void notifyItemRangeChangedInSection(String tag, int positionStart, int itemCount, Object payload) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.callSuperNotifyItemRangeChanged(this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + positionStart, itemCount, payload);
    }

    void callSuperNotifyItemRangeChanged(int positionStart, int itemCount, Object payload) {
        super.notifyItemRangeChanged(positionStart, itemCount, payload);
    }

    public void notifyItemMovedInSection(String tag, int fromPosition, int toPosition) {
        Section section = this.getValidSectionOrThrowException(tag);
        this.callSuperNotifyItemMoved(this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + fromPosition, this.getSectionPosition(tag) + (section.hasHeader ? 1 : 0) + toPosition);
    }

    void callSuperNotifyItemMoved(int fromPosition, int toPosition) {
        super.notifyItemMoved(fromPosition, toPosition);
    }

    @NonNull
    private Section getValidSectionOrThrowException(String tag) {
        Section section = this.getSection(tag);
        if (section == null) {
            throw new IllegalArgumentException("Invalid tag: " + tag);
        }
        return section;
    }

    public static class EmptyViewHolder
    extends RecyclerView.ViewHolder {
        public EmptyViewHolder(View itemView) {
            super(itemView);
        }
    }
}

