/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public enum Native {

    private static final String libname = "libzstd";
    private static boolean loaded = false;

    private static String osName() {
        return System.getProperty("os.name").toLowerCase().replace(' ', '_');
    }

    private static String osArch() {
        return System.getProperty("os.arch");
    }

    private static String libExtension() {
        if (Native.osName().contains("os_x")) {
            return "dynlib";
        }
        return "so";
    }

    private static String resourceName() {
        return "/" + Native.osName() + "/" + Native.osArch() + "/" + libname + "." + Native.libExtension();
    }

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void load() {
        if (loaded) {
            return;
        }
        String string = Native.resourceName();
        InputStream inputStream = Native.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + string + ". Please try building from source.");
        }
        try {
            File file = File.createTempFile(libname, "." + Native.libExtension());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                int n;
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                try {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.load(file.getAbsolutePath());
                loaded = true;
            }
            finally {
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                if (file != null && file.exists()) {
                    if (!loaded) {
                        file.delete();
                    } else {
                        file.deleteOnExit();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError("Cannot unpack libzstd");
        }
    }
}

