/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ZstdOutputStream
extends FilterOutputStream {
    private long ctx = ZstdOutputStream.createCCtx();
    private static final int blockSize = 131072;
    private static final int oBuffSize;
    private int iBuffSize = 0;
    private ByteBuffer iBuff = null;
    private byte[] oBuff = null;
    private int iPos = 0;

    private static native long createCCtx();

    private static native long freeCCtx(long var0);

    private static native int findIBuffSize(int var0);

    private static native long compressBegin(long var0, int var2);

    private static native long compressContinue(long var0, byte[] var2, long var3, ByteBuffer var5, long var6, long var8);

    private static native long compressEnd(long var0, byte[] var2, long var3);

    public ZstdOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream);
        this.iBuffSize = ZstdOutputStream.findIBuffSize(n);
        this.iBuff = ByteBuffer.allocateDirect(this.iBuffSize);
        this.oBuff = ByteBuffer.allocate(oBuffSize).array();
        if (this.iBuff == null || this.oBuff == null) {
            throw new IOException("Error allocating the buffers");
        }
        long l = ZstdOutputStream.compressBegin(this.ctx, n);
        if (Zstd.isError(l)) {
            throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(l));
        }
        this.out.write(this.oBuff, 0, (int)l);
    }

    public ZstdOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.iPos + 131072 - this.iBuff.position();
            if (n2 < n3) {
                this.iBuff.put(byArray, n, n2);
                n2 = 0;
                continue;
            }
            this.iBuff.put(byArray, n, n3);
            n += n3;
            n2 -= n3;
            long l = ZstdOutputStream.compressContinue(this.ctx, this.oBuff, oBuffSize, this.iBuff, this.iPos, 131072L);
            if (Zstd.isError(l)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(l));
            }
            this.out.write(this.oBuff, 0, (int)l);
            this.iPos += 131072;
            if (this.iPos != this.iBuffSize) continue;
            this.iPos = 0;
            this.iBuff.position(0);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        long l = 0L;
        int n = this.iBuff.position();
        if (this.iPos != n) {
            l = ZstdOutputStream.compressContinue(this.ctx, this.oBuff, oBuffSize, this.iBuff, this.iPos, n - this.iPos);
            if (Zstd.isError(l)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(l));
            }
            this.out.write(this.oBuff, 0, (int)l);
        }
        l = ZstdOutputStream.compressEnd(this.ctx, this.oBuff, oBuffSize);
        this.out.write(this.oBuff, 0, (int)l);
        ZstdOutputStream.freeCCtx(this.ctx);
        this.out.close();
    }

    static {
        Native.load();
        oBuffSize = (int)Zstd.compressBound(131072L) + 6;
    }
}

