/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.util.Native;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Zstd {
    public static native long compress(byte[] var0, byte[] var1, int var2);

    public static native long decompress(byte[] var0, byte[] var1);

    public static native long compressBound(long var0);

    public static native boolean isError(long var0);

    public static native String getErrorName(long var0);

    public static byte[] compress(byte[] byArray, int n) {
        long l = Zstd.compressBound(byArray.length);
        if (l > Integer.MAX_VALUE) {
            throw new RuntimeException("Max output size is greater than MAX_INT");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)l);
        byte[] byArray2 = byteBuffer.array();
        long l2 = Zstd.compress(byArray2, byArray, n);
        if (Zstd.isError(l2)) {
            throw new RuntimeException(Zstd.getErrorName(l2));
        }
        return Arrays.copyOfRange(byArray2, 0, (int)l2);
    }

    public static byte[] compress(byte[] byArray) {
        return Zstd.compress(byArray, 1);
    }

    public static byte[] decompress(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        byte[] byArray2 = byteBuffer.array();
        long l = Zstd.decompress(byArray2, byArray);
        if (Zstd.isError(l)) {
            throw new RuntimeException(Zstd.getErrorName(l));
        }
        if (l != (long)n) {
            return Arrays.copyOfRange(byArray2, 0, (int)l);
        }
        return byArray2;
    }

    static {
        Native.load();
    }
}

