/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.util.Native;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ZstdOutputStream
extends FilterOutputStream {
    private long ctx = ZstdOutputStream.createCCtx();
    private static final int blockSize = 131072;
    private int iBuffSize = 0;
    private int oBuffSize = 0;
    private byte[] iBuff = null;
    private byte[] oBuff = null;
    private int iPos = 0;
    private int iEnd = 0;

    private static native long createCCtx();

    private static native long freeCCtx(long var0);

    private static native int findIBuffSize(int var0);

    private static native long compressBegin(long var0, byte[] var2, long var3, int var5);

    private static native long compressContinue(long var0, byte[] var2, long var3, byte[] var5, long var6, long var8);

    private static native long compressEnd(long var0, byte[] var2, long var3);

    public ZstdOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream);
        this.iBuffSize = ZstdOutputStream.findIBuffSize(n);
        this.oBuffSize = (int)Zstd.compressBound(131072L) + 6;
        this.iBuff = ByteBuffer.allocate(this.iBuffSize).array();
        this.oBuff = ByteBuffer.allocate(this.oBuffSize).array();
        if (this.iBuff == null || this.oBuff == null) {
            throw new IOException("Error allocating the buffers");
        }
        long l = ZstdOutputStream.compressBegin(this.ctx, this.oBuff, this.oBuffSize, n);
        if (Zstd.isError(l)) {
            throw new IOException("Compression error: cannot create header: " + Zstd.getErrorName(l));
        }
        this.out.write(this.oBuff, 0, (int)l);
    }

    public ZstdOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.iPos + 131072 - this.iEnd;
            if (n2 < n3) {
                System.arraycopy(byArray, n, this.iBuff, this.iEnd, n2);
                this.iEnd += n2;
                n2 = 0;
                continue;
            }
            System.arraycopy(byArray, n, this.iBuff, this.iEnd, n3);
            this.iEnd += n3;
            n += n3;
            n2 -= n3;
            long l = ZstdOutputStream.compressContinue(this.ctx, this.oBuff, this.oBuffSize, this.iBuff, this.iPos, 131072L);
            if (Zstd.isError(l)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(l));
            }
            this.out.write(this.oBuff, 0, (int)l);
            this.iPos += 131072;
            if (this.iPos != this.iBuffSize) continue;
            this.iPos = 0;
            this.iEnd = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        long l = 0L;
        if (this.iPos != this.iEnd) {
            l = ZstdOutputStream.compressContinue(this.ctx, this.oBuff, this.oBuffSize, this.iBuff, this.iPos, this.iEnd - this.iPos);
            if (Zstd.isError(l)) {
                throw new IOException("Compression error: " + Zstd.getErrorName(l));
            }
            this.out.write(this.oBuff, 0, (int)l);
        }
        l = ZstdOutputStream.compressEnd(this.ctx, this.oBuff, this.oBuffSize);
        this.out.write(this.oBuff, 0, (int)l);
        ZstdOutputStream.freeCCtx(this.ctx);
        this.out.close();
    }

    static {
        Native.load();
    }
}

