/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import com.zebra.printconnectintentswrapper.PCConstants;
import com.zebra.printconnectintentswrapper.PCIntentsBase;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;
import com.zebra.printconnectintentswrapper.PCTemplateStringPrintSettings;
import java.io.UnsupportedEncodingException;

public class PCTemplateStringPrint
extends PCIntentsBase {
    private onPrintTemplateStringResult mPrintTemplateStringCallback = null;

    public PCTemplateStringPrint(Context aContext) {
        super(aContext);
    }

    public void execute(PCTemplateStringPrintSettings settings, onPrintTemplateStringResult callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"Error: callback member is null.");
            return;
        }
        this.mPrintTemplateStringCallback = callback;
        if (settings.mZPLTemplateString.isEmpty() && this.mPrintTemplateStringCallback != null) {
            this.mPrintTemplateStringCallback.error("Error: no zpl data.", -1, null, settings);
        }
        super.execute(settings);
        this.PrintTemplateString(settings);
    }

    private void PrintTemplateString(final PCTemplateStringPrintSettings settings) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.zebra.printconnect", "com.zebra.printconnect.print.TemplatePrintWithContentService"));
        byte[] templateBytes = null;
        try {
            templateBytes = settings.mZPLTemplateString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (this.mPrintTemplateStringCallback != null) {
                this.mPrintTemplateStringCallback.error(e.getMessage(), -1, null, settings);
            }
            this.cleanAll();
            return;
        }
        intent.putExtra("com.zebra.printconnect.PrintService.TEMPLATE_DATA", templateBytes);
        if (settings.mVariableData != null && settings.mVariableData.size() > 0) {
            intent.putExtra("com.zebra.printconnect.PrintService.VARIABLE_DATA", settings.mVariableData);
        }
        ResultReceiver receiver = this.buildIPCSafeReceiver(new ResultReceiver(null){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                PCTemplateStringPrint.this.cleanAll();
                if (resultCode == 0) {
                    if (PCTemplateStringPrint.this.mPrintTemplateStringCallback != null) {
                        PCTemplateStringPrint.this.mPrintTemplateStringCallback.success(settings);
                    }
                } else {
                    String errorMessage = resultData.getString("com.zebra.printconnect.PrintService.ERROR_MESSAGE");
                    if (errorMessage == null) {
                        errorMessage = PCConstants.getErrorMessage(resultCode);
                    }
                    if (PCTemplateStringPrint.this.mPrintTemplateStringCallback != null) {
                        PCTemplateStringPrint.this.mPrintTemplateStringCallback.error(errorMessage, resultCode, resultData, settings);
                    }
                }
            }
        });
        intent.putExtra("com.zebra.printconnect.PrintService.RESULT_RECEIVER", (Parcelable)receiver);
        this.mContext.startService(intent);
    }

    @Override
    protected void onTimeOut(PCIntentsBaseSettings settings) {
        if (this.mPrintTemplateStringCallback != null) {
            this.mPrintTemplateStringCallback.timeOut((PCTemplateStringPrintSettings)settings);
        }
    }

    public static interface onPrintTemplateStringResult {
        public void success(PCTemplateStringPrintSettings var1);

        public void error(String var1, int var2, Bundle var3, PCTemplateStringPrintSettings var4);

        public void timeOut(PCTemplateStringPrintSettings var1);
    }
}

